/*
 * Decompiled with CFR 0.152.
 */
package tschipp.carryon.client.render;

import com.mojang.datafixers.util.Either;
import java.util.Optional;
import net.minecraft.class_11352;
import net.minecraft.class_11368;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1935;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2281;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_3730;
import net.minecraft.class_4050;
import net.minecraft.class_4587;
import net.minecraft.class_6880;
import net.minecraft.class_7225;
import net.minecraft.class_7833;
import net.minecraft.class_7923;
import net.minecraft.class_8942;
import org.joml.Matrix4fc;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import tschipp.carryon.Constants;
import tschipp.carryon.client.modeloverride.ModelOverride;
import tschipp.carryon.client.modeloverride.ModelOverrideHandler;
import tschipp.carryon.common.carry.CarryOnData;
import tschipp.carryon.common.carry.CarryOnDataManager;
import tschipp.carryon.common.scripting.CarryOnScript;

public class CarryRenderHelper {
    public static class_243 getExactPos(class_1297 entity, float partialticks) {
        return new class_243(entity.field_6038 + (entity.method_23317() - entity.field_6038) * (double)partialticks, entity.field_5971 + (entity.method_23318() - entity.field_5971) * (double)partialticks, entity.field_5989 + (entity.method_23321() - entity.field_5989) * (double)partialticks);
    }

    public static float getExactBodyRotationDegrees(class_1309 entity, float partialticks) {
        class_1297 class_12972;
        if (entity.method_5854() != null && (class_12972 = entity.method_5854()) instanceof class_1309) {
            class_1309 vehicle = (class_1309)class_12972;
            if (vehicle instanceof class_1657) {
                class_1657 player = (class_1657)vehicle;
                return -(player.field_6220 + (player.field_6283 - player.field_6220) * partialticks);
            }
            return -(entity.field_6259 + (entity.field_6241 - entity.field_6259) * partialticks);
        }
        return -(entity.field_6220 + (entity.field_6283 - entity.field_6220) * partialticks);
    }

    public static Quaternionf getExactBodyRotation(class_1309 entity, float partialticks) {
        return class_7833.field_40716.rotationDegrees(CarryRenderHelper.getExactBodyRotationDegrees(entity, partialticks));
    }

    public static void applyGeneralTransformations(class_1657 player, class_4587 matrix) {
        class_4050 pose = player.method_18376();
        matrix.method_22903();
        matrix.method_22905(0.6f, 0.6f, 0.6f);
        matrix.method_22904(0.0, 0.0, -1.35);
        if (CarryRenderHelper.doSneakCheck(player)) {
            matrix.method_22904(0.0, -0.4, 0.0);
        }
        if (pose == class_4050.field_18079 || pose == class_4050.field_18077) {
            matrix.method_22904(0.0, 0.0, 2.5);
            matrix.method_22907((Quaternionfc)class_7833.field_40714.rotationDegrees(90.0f));
        }
        matrix.method_22904(0.0, -0.5, 0.65);
    }

    public static class_4587 setupBlockTransformations(class_1657 player, class_4587 matrix, CarryOnData carry, boolean firstPerson) {
        if (firstPerson) {
            matrix.method_22905(2.5f, 2.5f, 2.5f);
            matrix.method_22904(0.0, -0.5, -1.0);
            if (Constants.CLIENT_CONFIG.facePlayer != CarryRenderHelper.isChest(carry.getBlock().method_26204())) {
                matrix.method_22907((Quaternionfc)class_7833.field_40716.rotationDegrees(180.0f));
                matrix.method_22907((Quaternionfc)class_7833.field_40713.rotationDegrees(8.0f));
            } else {
                matrix.method_22907((Quaternionfc)class_7833.field_40714.rotationDegrees(8.0f));
            }
            carry.getActiveScript().ifPresent(script -> CarryRenderHelper.performScriptTransformation(matrix, script));
            return matrix;
        }
        CarryRenderHelper.applyBlockTransformations(player, matrix, carry.getBlock().method_26204());
        carry.getActiveScript().ifPresent(script -> CarryRenderHelper.performScriptTransformation(matrix, script));
        class_4587.class_4665 p = matrix.method_23760();
        class_4587 copy = new class_4587();
        copy.method_34425((Matrix4fc)p.method_23761());
        matrix.method_22909();
        return copy;
    }

    public static void applyBlockTransformations(class_1657 player, class_4587 matrix, class_2248 block) {
        matrix.method_22907((Quaternionfc)class_7833.field_40717.rotationDegrees(180.0f));
        CarryRenderHelper.applyGeneralTransformations(player, matrix);
        if (Constants.CLIENT_CONFIG.facePlayer != CarryRenderHelper.isChest(block)) {
            matrix.method_22907((Quaternionfc)class_7833.field_40716.rotationDegrees(180.0f));
        }
        float height = CarryRenderHelper.getRenderHeight(player);
        float offset = (height - 1.0f) / 1.2f;
        matrix.method_46416(0.0f, -offset, 0.0f);
    }

    public static void setupEntityTransformations(class_1657 player, class_4587 matrix, CarryOnData carry, boolean firstPerson) {
        class_1297 entity = carry.getEntity(player.method_73183());
        float height = entity.method_17682();
        float width = entity.method_17681();
        if (firstPerson) {
            matrix.method_22907((Quaternionfc)class_7833.field_40716.rotationDegrees(180.0f));
            matrix.method_22905(0.8f, 0.8f, 0.8f);
            matrix.method_22904(0.0, (double)(-height) - 0.2, (double)width * 1.3 + 0.1);
            carry.getActiveScript().ifPresent(script -> CarryRenderHelper.performScriptTransformation(matrix, script));
            if (Constants.CLIENT_CONFIG.rotateEntitiesSideways) {
                matrix.method_22907((Quaternionfc)class_7833.field_40716.rotationDegrees(90.0f));
            }
        } else {
            CarryRenderHelper.applyEntityTransformations(player, matrix, entity);
            carry.getActiveScript().ifPresent(script -> CarryRenderHelper.performScriptTransformation(matrix, script));
        }
    }

    public static void applyEntityTransformations(class_1657 player, class_4587 matrix, class_1297 entity) {
        class_4050 pose = player.method_18376();
        CarryRenderHelper.applyGeneralTransformations(player, matrix);
        matrix.method_22907((Quaternionfc)class_7833.field_40714.rotationDegrees(180.0f));
        matrix.method_22904(0.0, -3.1, -0.65);
        matrix.method_22905(1.666f, 1.666f, 1.666f);
        float height = entity.method_17682();
        float width = entity.method_17681();
        float multiplier = Math.min(9.9f, height * width);
        entity.field_6036 = 0.0;
        entity.field_5982 = 0.0f;
        entity.method_5847(0.0f);
        entity.field_6014 = 0.0;
        entity.field_6004 = 0.0f;
        matrix.method_22905((10.0f - multiplier) * 0.08f, (10.0f - multiplier) * 0.08f, (10.0f - multiplier) * 0.08f);
        matrix.method_22904(0.0, (double)(height / 2.0f + -(height / 4.0f) + 1.0f), (double)width - 0.1 < 0.7 ? (double)width - 0.1 + (0.7 - ((double)width - 0.1)) : (double)width - 0.1);
        if (CarryRenderHelper.doSneakCheck(player)) {
            matrix.method_22904(0.0, -0.4, 0.0);
        }
        if (pose == class_4050.field_18079 || pose == class_4050.field_18077) {
            matrix.method_22907((Quaternionfc)class_7833.field_40713.rotationDegrees(180.0f));
            matrix.method_22904(0.0, 0.2 * (double)height - 2.0, -0.5);
        }
        if (Constants.CLIENT_CONFIG.rotateEntitiesSideways) {
            matrix.method_22907((Quaternionfc)class_7833.field_40716.rotationDegrees(90.0f));
        }
    }

    public static void performScriptTransformation(class_4587 matrix, CarryOnScript script) {
        int perspective = CarryRenderHelper.getPerspective();
        CarryOnScript.ScriptRender render = script.scriptRender();
        class_243 translation = render.renderTranslation().getVec();
        class_243 rotation = render.renderRotation().getVec();
        class_243 scale = render.renderscale().getVec(1.0, 1.0, 1.0);
        Quaternionf rot = class_7833.field_40714.rotationDegrees((float)rotation.field_1352);
        rot.mul((Quaternionfc)class_7833.field_40716.rotationDegrees((float)rotation.field_1351));
        rot.mul((Quaternionfc)class_7833.field_40718.rotationDegrees((float)rotation.field_1350));
        matrix.method_22907((Quaternionfc)rot);
        matrix.method_22904(translation.field_1352, translation.field_1351, perspective == 1 && script.isBlock() ? -translation.field_1350 : translation.field_1350);
        matrix.method_22905((float)scale.field_1352, (float)scale.field_1351, (float)scale.field_1350);
    }

    public static class_1799 getRenderItemStack(class_1657 player) {
        CarryOnScript.ScriptRender render;
        CarryOnData carry = CarryOnDataManager.getCarryData(player);
        class_2680 state = carry.getBlock().method_26204().method_9564();
        if (carry.getActiveScript().isPresent() && (render = carry.getActiveScript().get().scriptRender()).renderNameBlock().isPresent()) {
            state = ((class_2248)((class_6880.class_6883)class_7923.field_41175.method_46746(render.renderNameBlock().get()).get()).comp_349()).method_9564();
        }
        class_1799 renderStack = class_1799.field_8037;
        Optional<ModelOverride> ov = ModelOverrideHandler.getModelOverride(state, carry.getContentNbt());
        if (ov.isPresent()) {
            Either<class_1799, class_2680> renderObj = ov.get().getRenderObject();
            if (renderObj.right().isPresent()) {
                state = (class_2680)renderObj.right().get();
            } else if (renderObj.left().isPresent()) {
                renderStack = (class_1799)renderObj.left().get();
            }
        }
        if (renderStack.method_7960()) {
            renderStack = new class_1799((class_1935)state.method_26204());
        }
        return renderStack;
    }

    public static class_2680 getRenderState(class_1657 player) {
        Either<class_1799, class_2680> renderObj;
        Optional<ModelOverride> ov;
        CarryOnScript.ScriptRender render;
        CarryOnData carry = CarryOnDataManager.getCarryData(player);
        class_2680 state = carry.getBlock().method_26204().method_9564();
        if (carry.getActiveScript().isPresent() && (render = carry.getActiveScript().get().scriptRender()).renderNameBlock().isPresent()) {
            state = ((class_2248)((class_6880.class_6883)class_7923.field_41175.method_46746(render.renderNameBlock().get()).get()).comp_349()).method_9564();
        }
        if ((ov = ModelOverrideHandler.getModelOverride(state, carry.getContentNbt())).isPresent() && (renderObj = ov.get().getRenderObject()).right().isPresent()) {
            state = (class_2680)renderObj.right().get();
        }
        return state;
    }

    public static class_1297 getRenderEntity(class_1657 player) {
        CarryOnData carry = CarryOnDataManager.getCarryData(player);
        class_1297 entity = carry.getEntity(player.method_73183());
        if (carry.getActiveScript().isPresent()) {
            CarryOnScript script = carry.getActiveScript().get();
            CarryOnScript.ScriptRender render = script.scriptRender();
            if (render.renderNameEntity().isPresent()) {
                entity = ((class_1299)((class_6880.class_6883)class_7923.field_41177.method_46746(render.renderNameEntity().get()).get()).comp_349()).method_5883(player.method_73183(), class_3730.field_16467);
            }
            if (render.renderNBT().isPresent()) {
                class_11368 input = class_11352.method_71417((class_8942)new class_8942.class_11340(Constants.LOG), (class_7225.class_7874)player.method_56673(), (class_2487)render.renderNBT().get());
                entity.method_5651(input);
            }
        }
        return entity;
    }

    public static float getRenderWidth(class_1657 player) {
        CarryOnData carry = CarryOnDataManager.getCarryData(player);
        if (carry.isCarrying(CarryOnData.CarryType.BLOCK)) {
            Either<class_1799, class_2680> renderObj;
            class_2680 state = CarryRenderHelper.getRenderState(player);
            class_265 shape = state.method_26218((class_1922)player.method_73183(), player.method_24515());
            if (shape == null || shape.method_1110()) {
                return 1.0f;
            }
            Optional<ModelOverride> ov = ModelOverrideHandler.getModelOverride(state, carry.getContentNbt());
            if (ov.isPresent() && (renderObj = ov.get().getRenderObject()).left().isPresent()) {
                return 0.8f;
            }
            float width = (float)Math.abs(shape.method_1107().field_1320 - shape.method_1107().field_1323);
            return width;
        }
        if (carry.isCarrying(CarryOnData.CarryType.ENTITY)) {
            class_1297 entity = CarryRenderHelper.getRenderEntity(player);
            float w = entity.method_17681();
            if (Constants.CLIENT_CONFIG.rotateEntitiesSideways) {
                return w - w * w * 0.35f;
            }
            return w * 0.9f;
        }
        return 1.0f;
    }

    public static float getRenderHeight(class_1657 player) {
        CarryOnData carry = CarryOnDataManager.getCarryData(player);
        if (carry.isCarrying(CarryOnData.CarryType.BLOCK)) {
            Either<class_1799, class_2680> renderObj;
            class_2680 state = CarryRenderHelper.getRenderState(player);
            class_265 shape = state.method_26218((class_1922)player.method_73183(), player.method_24515());
            if (shape == null || shape.method_1110()) {
                return 1.0f;
            }
            Optional<ModelOverride> ov = ModelOverrideHandler.getModelOverride(state, carry.getContentNbt());
            if (ov.isPresent() && (renderObj = ov.get().getRenderObject()).left().isPresent()) {
                return 0.5f;
            }
            float height = (float)Math.abs(shape.method_1107().field_1325 - shape.method_1107().field_1322);
            return height;
        }
        if (carry.isCarrying(CarryOnData.CarryType.ENTITY)) {
            class_1297 entity = CarryRenderHelper.getRenderEntity(player);
            return entity.method_17682();
        }
        return 1.0f;
    }

    public static int getPerspective() {
        boolean isThirdPerson = !class_310.method_1551().field_1690.method_31044().method_31034();
        boolean isThirdPersonReverse = class_310.method_1551().field_1690.method_31044().method_31035();
        if (!isThirdPerson && !isThirdPersonReverse) {
            return 0;
        }
        if (isThirdPerson && !isThirdPersonReverse) {
            return 1;
        }
        return 2;
    }

    public static boolean doSneakCheck(class_1657 player) {
        if (player.method_31549().field_7479) {
            return false;
        }
        return player.method_5715() || player.method_18276();
    }

    public static boolean isChest(class_2248 block) {
        return block == class_2246.field_10034 || block == class_2246.field_10443 || block == class_2246.field_10380 || block instanceof class_2281;
    }
}

