/*
 * GNU Lesser General Public License v3
 * Copyright (C) 2024 Tschipp
 * mrtschipp@gmail.com
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */

package tschipp.carryon.networking.clientbound;

import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_8710;
import net.minecraft.class_9129;
import net.minecraft.class_9135;
import net.minecraft.class_9139;
import tschipp.carryon.Constants;
import tschipp.carryon.networking.PacketBase;

public record ClientboundStartRidingPacket(int iden, boolean ride) implements PacketBase
{
	public static final class_9139<class_9129, ClientboundStartRidingPacket> CODEC = class_9139.method_56435(
			class_9135.field_49675, ClientboundStartRidingPacket::iden,
			class_9135.field_48547, ClientboundStartRidingPacket::ride,
			ClientboundStartRidingPacket::new
	);

	public static final class_8710.class_9154<ClientboundStartRidingPacket> TYPE = new class_9154<>(Constants.PACKET_ID_START_RIDING);

	@Override
	public void handle(class_1657 player)
	{
		class_1297 otherPlayer = player.method_73183().method_8469(this.iden);
		if(otherPlayer != null)
			if(ride)
				otherPlayer.method_5804(player);
			else
				otherPlayer.method_5848();
	}

	@Override
	public class_9154<ClientboundStartRidingPacket> method_56479() {
		return TYPE;
	}
}
