/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.craftingeffect.outcome;

import java.util.Arrays;
import java.util.Map;
import java.util.Optional;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.MultifaceBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.common.ToolAction;
import se.mickelus.tetra.craftingeffect.outcome.CraftingEffectOutcome;
import se.mickelus.tetra.effect.SculkTaintEffect;
import se.mickelus.tetra.module.schematic.UpgradeSchematic;

@ParametersAreNonnullByDefault
public class SpawnSculkOutcome
implements CraftingEffectOutcome {
    int severity = 5;
    double chance = 1.0;
    boolean catalystSource = false;
    boolean workbenchSource = true;

    @Override
    public boolean apply(ResourceLocation[] unlockedEffects, ItemStack upgradedStack, String slot, boolean isReplacing, Player player, ItemStack[] preMaterials, Map<ToolAction, Integer> tools, Level world, UpgradeSchematic schematic, BlockPos origin, BlockState blockState, boolean consumeResources, ItemStack[] postMaterials, float craftingSeverity) {
        if (consumeResources && !world.m_5776_() && world.f_46441_.m_188500_() < this.chance) {
            Optional<BlockPos> workbenchOrigin;
            if (this.catalystSource) {
                Optional<BlockPos> catalystOrigin = BlockPos.m_121921_((AABB)new AABB(-2.0, 0.0, -2.0, 2.0, 5.0, 2.0)).map(arg_0 -> ((BlockPos)origin).m_121955_(arg_0)).filter(pos -> world.m_8055_(pos).m_60713_(Blocks.f_220857_)).map(pos -> this.findVeinOrigin(world, (BlockPos)pos)).filter(Optional::isPresent).map(Optional::get).findAny();
                if (catalystOrigin.isPresent()) {
                    SculkTaintEffect.startSpread((ServerLevel)world, catalystOrigin.get(), this.severity);
                    return true;
                }
            }
            if (this.workbenchSource && (workbenchOrigin = this.findVeinOrigin(world, origin)).isPresent()) {
                SculkTaintEffect.startSpread((ServerLevel)world, workbenchOrigin.get(), this.severity);
                return true;
            }
        }
        return false;
    }

    private Optional<BlockPos> findVeinOrigin(Level world, BlockPos origin) {
        return Direction.m_235667_((RandomSource)world.m_213780_()).stream().map(arg_0 -> ((BlockPos)origin).m_121945_(arg_0)).filter(arg_0 -> ((Level)world).m_46859_(arg_0)).filter(pos -> Arrays.stream(Direction.values()).anyMatch(direction -> SpawnSculkOutcome.canSpawnVeinAt(world, direction, pos))).findAny();
    }

    private static boolean canSpawnVeinAt(Level world, Direction direction, BlockPos pos) {
        return MultifaceBlock.m_153829_((BlockGetter)world, (Direction)direction, (BlockPos)pos.m_121945_(direction), (BlockState)world.m_8055_(pos.m_121945_(direction))) && !world.m_8055_(pos.m_121945_(direction)).m_60713_(Blocks.f_220857_);
    }
}

