/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.craftingeffect.outcome;

import java.util.Map;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.AreaEffectCloud;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ToolAction;
import se.mickelus.tetra.craftingeffect.outcome.CraftingEffectOutcome;
import se.mickelus.tetra.module.schematic.UpgradeSchematic;

@ParametersAreNonnullByDefault
public class SpawnEffectCloudOutcome
implements CraftingEffectOutcome {
    MobEffect effect;
    int amplifier = 0;
    int duration = 200;
    int cloudDuration = 200;
    int waitTime = 10;
    float radius = 3.0f;
    float radiusChange = 0.0f;
    float chance = 1.0f;
    int randomOriginDistance = 0;

    @Override
    public boolean apply(ResourceLocation[] unlockedEffects, ItemStack upgradedStack, String slot, boolean isReplacing, Player player, ItemStack[] preMaterials, Map<ToolAction, Integer> tools, Level world, UpgradeSchematic schematic, BlockPos pos, BlockState blockState, boolean consumeResources, ItemStack[] postMaterials, float severity) {
        if (consumeResources && !world.m_5776_() && world.m_213780_().m_188501_() < this.chance) {
            Vec3 spawnPos = this.randomOriginDistance > 0 ? Vec3.m_82539_((Vec3i)SpawnEffectCloudOutcome.findRandomBlockPos(world, pos, this.randomOriginDistance)) : Vec3.m_82539_((Vec3i)pos);
            AreaEffectCloud cloud = new AreaEffectCloud(EntityType.f_20476_, world);
            cloud.m_19718_((LivingEntity)player);
            cloud.m_6034_(spawnPos.m_7096_(), spawnPos.m_7098_(), spawnPos.m_7094_());
            cloud.m_19712_(this.radius);
            cloud.m_19734_(this.cloudDuration);
            cloud.m_19740_(this.waitTime);
            cloud.m_19738_(this.radiusChange);
            MobEffectInstance effectInstance = new MobEffectInstance(this.effect, this.duration, this.amplifier, false, true);
            cloud.m_19716_(effectInstance);
            world.m_7967_((Entity)cloud);
            return true;
        }
        return false;
    }

    private static BlockPos findRandomBlockPos(Level level, BlockPos origin, int radius) {
        BlockPos adjustedPos;
        int i;
        BlockPos randomOffset = new BlockPos(level.f_46441_.m_216332_(-radius, radius), 0, level.f_46441_.m_216332_(-radius, radius));
        for (i = 0; i < 4; ++i) {
            adjustedPos = randomOffset.m_6625_(i).m_121955_((Vec3i)origin);
            if (!level.m_8055_(adjustedPos).m_60795_() || level.m_8055_(adjustedPos.m_7495_()).m_60795_()) continue;
            return adjustedPos;
        }
        for (i = 1; i < 4; ++i) {
            adjustedPos = randomOffset.m_6630_(i).m_121955_((Vec3i)origin);
            if (!level.m_8055_(adjustedPos).m_60795_() || level.m_8055_(adjustedPos.m_7495_()).m_60795_()) continue;
            return adjustedPos;
        }
        return randomOffset;
    }
}

