/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.craftingeffect.outcome;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.util.Map;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.ToolAction;
import se.mickelus.tetra.craftingeffect.outcome.CraftingEffectOutcome;
import se.mickelus.tetra.module.schematic.UpgradeSchematic;

@ParametersAreNonnullByDefault
public class ApplyNbtOutcome
implements CraftingEffectOutcome {
    JsonObject nbt;
    boolean force = false;

    @Override
    public boolean apply(ResourceLocation[] unlockedEffects, ItemStack upgradedStack, String slot, boolean isReplacing, Player player, ItemStack[] preMaterials, Map<ToolAction, Integer> tools, Level world, UpgradeSchematic schematic, BlockPos pos, BlockState blockState, boolean consumeResources, ItemStack[] postMaterials, float severity) {
        if (this.nbt != null) {
            CompoundTag tag = upgradedStack.m_41784_();
            this.writeObject(this.nbt, tag);
            return true;
        }
        return false;
    }

    private void writeObject(JsonObject json, CompoundTag tag) {
        json.entrySet().forEach(pair -> {
            JsonElement value = (JsonElement)pair.getValue();
            String key = (String)pair.getKey();
            if (value.isJsonPrimitive()) {
                JsonPrimitive primitive = value.getAsJsonPrimitive();
                if (primitive.isNumber()) {
                    Number numberValue = primitive.getAsNumber();
                    String stringValue = value.getAsString();
                    boolean isFloat = stringValue.matches("[-+]?[0-9]*\\.[0-9]+");
                    if (isFloat) {
                        tag.m_128350_(key, numberValue.floatValue());
                    } else {
                        tag.m_128405_(key, numberValue.intValue());
                    }
                } else if (primitive.isBoolean()) {
                    tag.m_128379_(key, primitive.getAsBoolean());
                } else if (primitive.isString()) {
                    tag.m_128359_(key, primitive.getAsString());
                }
            } else if (json.isJsonObject()) {
                CompoundTag childTag = new CompoundTag();
                this.writeObject(value.getAsJsonObject(), childTag);
                tag.m_128365_(key, (Tag)childTag);
            } else if (value.isJsonArray()) {
                // empty if block
            }
        });
    }
}

