/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.crafting;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import javax.annotation.Nullable;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraftforge.common.ToolAction;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.IIngredientSerializer;
import net.minecraftforge.registries.ForgeRegistries;
import se.mickelus.tetra.data.DataManager;
import se.mickelus.tetra.items.modular.ItemModularHandheld;
import se.mickelus.tetra.module.schematic.requirement.IntegerPredicate;

public class ToolActionIngredient
extends Ingredient {
    private final ToolAction toolAction;
    private final IntegerPredicate tier;

    protected ToolActionIngredient(ToolAction toolAction, IntegerPredicate tier) {
        super(ForgeRegistries.ITEMS.getValues().stream().map(Item::m_7968_).filter(stack -> stack.canPerformAction(toolAction)).map(Ingredient.ItemValue::new));
        this.toolAction = toolAction;
        this.tier = tier;
    }

    public boolean test(@Nullable ItemStack input) {
        ItemModularHandheld item;
        Item item2;
        if (input == null) {
            return false;
        }
        return input.canPerformAction(this.toolAction) && (this.tier == null || (item2 = input.m_41720_()) instanceof ItemModularHandheld && this.tier.test((item = (ItemModularHandheld)item2).getHarvestTier(input, this.toolAction)));
    }

    public boolean isSimple() {
        return false;
    }

    public IIngredientSerializer<? extends Ingredient> getSerializer() {
        return Serializer.instance;
    }

    public JsonElement m_43942_() {
        JsonObject json = new JsonObject();
        json.addProperty("type", CraftingHelper.getID(this.getSerializer()).toString());
        json.addProperty("tool", this.toolAction.name());
        if (this.tier != null) {
            json.add("tier", this.tier.serialize());
        }
        return json;
    }

    public static class Serializer
    implements IIngredientSerializer<ToolActionIngredient> {
        public static final Serializer instance = new Serializer();

        public ToolActionIngredient parse(JsonObject json) {
            ToolAction toolAction = ToolAction.get((String)json.get("tool").getAsString());
            IntegerPredicate tier = json.has("tier") ? (IntegerPredicate)DataManager.gson.fromJson((JsonElement)json.getAsJsonObject("tier"), IntegerPredicate.class) : null;
            return new ToolActionIngredient(toolAction, tier);
        }

        public ToolActionIngredient parse(FriendlyByteBuf buffer) {
            ToolAction toolAction = ToolAction.get((String)buffer.m_130277_());
            IntegerPredicate tier = IntegerPredicate.fromBuffer(buffer);
            return new ToolActionIngredient(toolAction, tier);
        }

        public void write(FriendlyByteBuf buffer, ToolActionIngredient ingredient) {
            buffer.m_130070_(ingredient.toolAction.name());
            if (ingredient.tier != null) {
                ingredient.tier.toBuffer(buffer);
            } else {
                IntegerPredicate.writeNull(buffer);
            }
        }
    }
}

