/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.blocks.forged.extractor;

import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.registries.RegistryObject;
import se.mickelus.mutil.network.AbstractPacket;
import se.mickelus.mutil.util.TileEntityOptional;
import se.mickelus.tetra.TetraMod;
import se.mickelus.tetra.blocks.forged.extractor.CoreExtractorBaseBlockEntity;
import se.mickelus.tetra.blocks.forged.extractor.CoreExtractorPistonUpdatePacket;

@ParametersAreNonnullByDefault
public class CoreExtractorPistonBlockEntity
extends BlockEntity {
    static final long activationDuration = 105L;
    private static final int fillAmount = 40;
    public static RegistryObject<BlockEntityType<CoreExtractorPistonBlockEntity>> type;
    private long endTime = Long.MAX_VALUE;

    public CoreExtractorPistonBlockEntity(BlockPos blockPos, BlockState blockState) {
        super((BlockEntityType)type.get(), blockPos, blockState);
    }

    public void activate() {
        if (!this.isActive()) {
            this.endTime = this.f_58857_.m_46467_() + 105L;
            if (!this.f_58857_.f_46443_) {
                TetraMod.packetHandler.sendToAllPlayersNear((AbstractPacket)new CoreExtractorPistonUpdatePacket(this.f_58858_, this.endTime), this.f_58858_, 64.0, this.f_58857_.m_46472_());
            }
        }
    }

    public void setEndTime(long endTime) {
        this.endTime = endTime;
    }

    public boolean isActive() {
        return this.endTime != Long.MAX_VALUE;
    }

    public float getProgress(float partialTicks) {
        if (this.isActive()) {
            return Math.min(1.0f, Math.max(0.0f, ((float)(this.f_58857_.m_46467_() + 105L - this.endTime) + partialTicks) / 105.0f));
        }
        return 0.0f;
    }

    private void runEndEffects() {
        Level level = this.f_58857_;
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123755_, (double)this.f_58858_.m_123341_() + 0.5, (double)this.f_58858_.m_123342_() + 0.1, (double)this.f_58858_.m_123343_() + 0.5, 5, 0.0, 0.0, 0.0, (double)0.02f);
        }
        this.f_58857_.m_5594_(null, this.f_58858_, SoundEvents.f_11937_, SoundSource.BLOCKS, 0.1f, 1.0f);
        this.f_58857_.m_5594_(null, this.f_58858_, SoundEvents.f_12063_, SoundSource.BLOCKS, 0.2f, 0.5f);
    }

    public void tick(Level level, BlockPos pos, BlockState state) {
        if (this.endTime < level.m_46467_()) {
            this.endTime = Long.MAX_VALUE;
            if (!level.f_46443_) {
                TileEntityOptional.from((BlockGetter)level, (BlockPos)pos.m_121945_(Direction.DOWN), CoreExtractorBaseBlockEntity.class).ifPresent(base -> base.fill(40));
                this.runEndEffects();
                this.m_6596_();
            }
        }
    }
}

