/*
 * Decompiled with CFR 0.152.
 */
package rearth.oritech.client.renderers;

import java.util.HashMap;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_310;
import org.joml.Vector2f;
import org.joml.Vector2fc;
import rearth.oritech.block.entity.interaction.LaserArmBlockEntity;
import rearth.oritech.client.renderers.MachineModel;
import rearth.oritech.util.Geometry;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.cache.object.GeoBone;

public class LaserArmModel<T extends LaserArmBlockEntity>
extends MachineModel<T> {
    private static final HashMap<Long, ModelRenderData> additionalData = new HashMap();
    private static final HashMap<Long, class_243> drillOffsets = new HashMap();
    private class_243 lastActivePlayerPos = class_243.field_1353;

    public LaserArmModel(String subpath) {
        super(subpath);
    }

    private ModelRenderData getById(long id) {
        return additionalData.computeIfAbsent(id, s -> new ModelRenderData(0.0f, 0.0f, this.getAnimationProcessor().getBone("pivotX"), this.getAnimationProcessor().getBone("pivotY")));
    }

    private class_243 getOffsetByDrillId(long id, T laserEntity) {
        return drillOffsets.computeIfAbsent(id, s -> {
            class_2350 drillFacing = (class_2350)laserEntity.method_10997().method_8320(laserEntity.getCurrentTarget()).method_11654((class_2769)class_2741.field_12481);
            return Geometry.rotatePosition(new class_243(1.0, 1.4, 0.0), drillFacing);
        });
    }

    public void setCustomAnimations(T laserEntity, long instanceId, AnimationState<T> animationState) {
        class_243 target;
        boolean isIdle = false;
        if (((LaserArmBlockEntity)laserEntity).getCurrentTarget() == null || ((LaserArmBlockEntity)laserEntity).getCurrentTarget().method_19771((class_2382)class_2338.field_10980, (double)0.1f)) {
            target = this.getIdleTarget(laserEntity);
            isIdle = true;
        } else {
            target = ((LaserArmBlockEntity)laserEntity).getVisualTarget();
        }
        if (target == null || target == class_243.field_1353) {
            return;
        }
        class_2248 targetBlock = laserEntity.method_10997().method_8320(((LaserArmBlockEntity)laserEntity).getCurrentTarget()).method_26204();
        class_243 startPos = ((LaserArmBlockEntity)laserEntity).laserHead;
        if (((LaserArmBlockEntity)laserEntity).isTargetingAtomicForge(targetBlock)) {
            double moveX = 0.5;
            double moveZ = 0.5;
            if (startPos.field_1352 < target.field_1352) {
                moveX = -0.5;
            }
            if (startPos.field_1350 < target.field_1350) {
                moveZ = -0.5;
            }
            target = target.method_1031(moveX, 0.2, moveZ);
        } else if (!isIdle && ((LaserArmBlockEntity)laserEntity).isTargetingDeepdrill(laserEntity.method_10997().method_8320(((LaserArmBlockEntity)laserEntity).getCurrentTarget()).method_26204())) {
            long drillId = ((LaserArmBlockEntity)laserEntity).getCurrentTarget().method_10063();
            class_243 offset = this.getOffsetByDrillId(drillId, laserEntity);
            target = target.method_1019(offset);
        }
        class_243 ownPos = ((LaserArmBlockEntity)laserEntity).laserHead;
        class_2350 facing = (class_2350)laserEntity.method_11010().method_11654((class_2769)class_2741.field_12525);
        class_243 offset = Geometry.worldToOffsetPosition(facing, target, ownPos);
        Vector2f offsetY = new Vector2f((float)offset.method_10216(), (float)offset.method_10214());
        Vector2f forwardY = new Vector2f(0.0f, -1.0f);
        if (facing == class_2350.field_11043) {
            forwardY = new Vector2f(0.0f, 1.0f);
        }
        if (facing == class_2350.field_11039) {
            forwardY = new Vector2f(1.0f, 0.0f);
        }
        if (facing == class_2350.field_11034) {
            forwardY = new Vector2f(-1.0f, 0.0f);
        }
        float angleY = -offsetY.angle((Vector2fc)forwardY);
        float lengthY = offsetY.length();
        double heightDiff = offset.method_10215();
        Vector2f offsetX = new Vector2f(lengthY, (float)heightDiff);
        Vector2f forwardX = new Vector2f(0.0f, 1.0f);
        float detX = LaserArmModel.determinant(offsetX, forwardX);
        float dotX = offsetX.dot((Vector2fc)forwardX);
        double angleX = Math.atan2(detX, dotX);
        angleX -= 0.8290313882753253;
        ModelRenderData data = this.getById(instanceId);
        if (data.boneX != null) {
            float newRotY = LaserArmModel.lerp(data.angleY, angleY, 0.06f);
            float newRotX = LaserArmModel.lerp(data.angleX, (float)angleX, 0.06f);
            data.boneY.setRotY(newRotY);
            data.boneX.setRotX(newRotX);
            data.angleY = newRotY;
            data.angleX = newRotX;
        }
    }

    private class_243 getIdleTarget(T entity) {
        class_243 offsetA = new class_243(0.0, Math.pow(Math.sin((float)entity.method_10997().method_8510() / 40.0f), 3.0), 0.0);
        class_243 offsetB = new class_243(Math.pow(Math.sin((float)entity.method_10997().method_8510() / 40.0f + 1.3f), 3.0), 0.0, 0.0);
        if (entity.method_10997().method_8409().method_43057() > 0.9f) {
            this.lastActivePlayerPos = class_310.method_1551().field_1724.method_33571();
        }
        if (this.lastActivePlayerPos.equals((Object)class_243.field_1353)) {
            return class_243.field_1353;
        }
        return this.lastActivePlayerPos.method_1019(offsetA).method_1019(offsetB);
    }

    public static float lerp(float a, float b, float f) {
        if (Math.abs(b - a) > 6.108652f) {
            return b;
        }
        return a + f * (b - a);
    }

    public static float determinant(Vector2f a, Vector2f b) {
        return a.x * b.y - a.y * b.x;
    }

    private static class ModelRenderData {
        protected float angleY;
        protected float angleX;
        protected GeoBone boneX;
        protected GeoBone boneY;

        public ModelRenderData(float angleX, float angleY, GeoBone boneX, GeoBone boneY) {
            this.angleY = angleY;
            this.angleX = angleX;
            this.boneX = boneX;
            this.boneY = boneY;
        }
    }
}

