/*
 * Decompiled with CFR 0.152.
 */
package rearth.oritech.block.entity.interaction;

import dev.architectury.registry.menu.ExtendedMenuProvider;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.class_1262;
import net.minecraft.class_1263;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2487;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3419;
import net.minecraft.class_3917;
import net.minecraft.class_5558;
import net.minecraft.class_7225;
import org.jetbrains.annotations.Nullable;
import rearth.oritech.api.energy.EnergyApi;
import rearth.oritech.api.energy.containers.DynamicEnergyStorage;
import rearth.oritech.api.item.ItemApi;
import rearth.oritech.api.item.containers.SimpleInventoryStorage;
import rearth.oritech.api.networking.NetworkedBlockEntity;
import rearth.oritech.api.networking.SyncField;
import rearth.oritech.api.networking.SyncType;
import rearth.oritech.block.base.entity.MachineBlockEntity;
import rearth.oritech.client.init.ModScreens;
import rearth.oritech.client.ui.BasicMachineScreenHandler;
import rearth.oritech.init.BlockEntitiesContent;
import rearth.oritech.init.TagContent;
import rearth.oritech.util.AutoPlayingSoundKeyframeHandler;
import rearth.oritech.util.ColorableMachine;
import rearth.oritech.util.Geometry;
import rearth.oritech.util.InventoryInputMode;
import rearth.oritech.util.ScreenProvider;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoBlockEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;

public class TreefellerBlockEntity
extends NetworkedBlockEntity
implements class_5558<NetworkedBlockEntity>,
GeoBlockEntity,
EnergyApi.BlockProvider,
ColorableMachine,
ItemApi.BlockProvider,
ExtendedMenuProvider,
ScreenProvider {
    private static final int LOG_COST = 100;
    private static final int LEAF_COST = 10;
    private final Deque<class_2338> pendingBlocks = new ArrayDeque<class_2338>();
    protected final AnimatableInstanceCache animatableInstanceCache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private long lastWorkedAt = 0L;
    @SyncField(value={SyncType.GUI_TICK, SyncType.GUI_OPEN})
    protected final DynamicEnergyStorage energyStorage = new DynamicEnergyStorage(50000L, 4000L, 0L, this::method_5431);
    public final SimpleInventoryStorage inventory = new SimpleInventoryStorage(this, 6, this::method_5431){

        @Override
        public boolean supportsInsertion() {
            return false;
        }
    };
    @SyncField(value={SyncType.SPARSE_TICK, SyncType.INITIAL})
    public ColorableMachine.ColorVariant currentColor = this.getDefaultColor();

    public TreefellerBlockEntity(class_2338 pos, class_2680 state) {
        super(BlockEntitiesContent.TREEFELLER_BLOCK_ENTITY, pos, state);
    }

    @Override
    public void serverTick(class_1937 world, class_2338 pos, class_2680 state, NetworkedBlockEntity blockEntity) {
        if (this.energyStorage.amount >= 100L) {
            if (this.pendingBlocks.isEmpty() && world.method_8510() % 20L == 0L) {
                this.findTarget();
            }
            for (int i = 0; i < 6 && !this.pendingBlocks.isEmpty(); ++i) {
                class_1269 actionResult;
                int energyCost;
                class_2338 candidate = this.pendingBlocks.peekLast();
                class_2680 candidateState = world.method_8320(candidate);
                boolean isLog = candidateState.method_26164(TagContent.CUTTER_LOGS_MINEABLE);
                int n = energyCost = isLog ? 100 : 10;
                if ((long)energyCost > this.energyStorage.amount || (actionResult = this.breakTreeBlock(candidateState, candidate)) == class_1269.field_5814) break;
                this.pendingBlocks.pollLast();
                if (actionResult == class_1269.field_5811) continue;
                this.lastWorkedAt = world.method_8510();
                this.energyStorage.amount -= (long)energyCost;
                this.method_5431();
                if (isLog) break;
            }
        }
        if (world.method_8510() % 10L == 0L) {
            long idleTicks = world.method_8510() - this.lastWorkedAt;
            boolean isWorking = idleTicks < 20L;
            String animName = isWorking ? "work" : "idle";
            this.playWorkAnimation(animName);
        }
    }

    private class_1269 breakTreeBlock(class_2680 candidateState, class_2338 candidate) {
        if (!candidateState.method_26164(TagContent.CUTTER_LOGS_MINEABLE) && !candidateState.method_26164(TagContent.CUTTER_LEAVES_MINEABLE)) {
            return class_1269.field_5811;
        }
        List dropped = class_2248.method_9562((class_2680)candidateState, (class_3218)((class_3218)this.field_11863), (class_2338)candidate, null);
        if (dropped.stream().anyMatch(itemStack -> !itemStack.method_7960() && !this.canInsert((class_1799)itemStack))) {
            return class_1269.field_5814;
        }
        this.field_11863.method_31595(candidate, candidateState);
        if (this.field_11863.method_8510() % 2L == 0L) {
            this.field_11863.method_8396(null, candidate, candidateState.method_26231().method_10595(), class_3419.field_15245, 0.5f, 1.0f);
        }
        this.field_11863.method_8501(candidate, class_2246.field_10124.method_9564());
        dropped.forEach(stack -> this.inventory.insert((class_1799)stack, false));
        return class_1269.field_5812;
    }

    private boolean canInsert(class_1799 stack) {
        return this.inventory.heldStacks.stream().anyMatch(itemStack -> itemStack.method_7960() || class_1799.method_31577((class_1799)itemStack, (class_1799)stack) && itemStack.method_7947() + stack.method_7947() <= itemStack.method_7914());
    }

    public void findTarget() {
        class_2680 state = this.method_11010();
        class_2350 facing = (class_2350)state.method_11654((class_2769)class_2741.field_12481);
        class_2382 offset = Geometry.rotatePosition(new class_2382(1, 0, 0), facing);
        class_2338 frontBlock = this.field_11867.method_10081(offset);
        Deque<class_2338> res = TreefellerBlockEntity.getTreeBlocks(frontBlock, this.field_11863);
        this.pendingBlocks.addAll(res);
    }

    public static Deque<class_2338> getTreeBlocks(class_2338 startPos, class_1937 world) {
        class_2680 startState = world.method_8320(startPos);
        if (!startState.method_26164(TagContent.CUTTER_LOGS_MINEABLE)) {
            return new ArrayDeque<class_2338>();
        }
        HashSet<class_2338> checkedPositions = new HashSet<class_2338>();
        ArrayDeque<class_2338> foundPositions = new ArrayDeque<class_2338>();
        HashSet<class_2338> foundLogs = new HashSet<class_2338>();
        ArrayDeque<class_2338> pendingPositions = new ArrayDeque<class_2338>();
        checkedPositions.add(startPos);
        foundPositions.add(startPos);
        pendingPositions.addAll(TreefellerBlockEntity.getNeighbors(startPos));
        foundLogs.add(startPos);
        while (!pendingPositions.isEmpty() && checkedPositions.size() < 8000) {
            boolean isValidLeaf;
            class_2338 candidate = (class_2338)pendingPositions.pollFirst();
            if (candidate.method_10264() < startPos.method_10264() || checkedPositions.contains(candidate)) continue;
            class_2680 candidateState = world.method_8320(candidate);
            checkedPositions.add(candidate);
            boolean isLog = candidateState.method_26164(TagContent.CUTTER_LOGS_MINEABLE);
            boolean bl = isValidLeaf = candidateState.method_26164(TagContent.CUTTER_LEAVES_MINEABLE) && candidateState.method_28500((class_2769)class_2741.field_12514).orElse(false) == false;
            if (!isLog && !isValidLeaf) continue;
            boolean isValid = false;
            if (isLog) {
                isValid = TreefellerBlockEntity.isInLogRange(candidate, foundLogs, 3);
            } else {
                Integer range = candidateState.method_28500((class_2769)class_2741.field_12541).orElse(4);
                isValid = TreefellerBlockEntity.isInLogRange(candidate, foundLogs, range + 2);
            }
            if (!isValid) continue;
            if (isLog) {
                foundLogs.add(candidate);
            }
            foundPositions.add(candidate);
            pendingPositions.addAll(TreefellerBlockEntity.getNeighbors(candidate));
        }
        if (foundLogs.size() == foundPositions.size()) {
            return new ArrayDeque<class_2338>();
        }
        return foundPositions;
    }

    private static boolean isInLogRange(class_2338 pos, Set<class_2338> logs, int maxDist) {
        return logs.stream().anyMatch(elem -> elem.method_19455((class_2382)pos) <= maxDist);
    }

    private static List<class_2338> getNeighbors(class_2338 input) {
        ArrayList<class_2338> neighbors = new ArrayList<class_2338>();
        for (class_2338 pos : class_2338.method_25996((class_2338)input, (int)1, (int)1, (int)1)) {
            neighbors.add(pos.method_10062());
        }
        return neighbors;
    }

    protected void method_11007(class_2487 nbt, class_7225.class_7874 registryLookup) {
        super.method_11007(nbt, registryLookup);
        class_1262.method_5427((class_2487)nbt, this.inventory.heldStacks, (boolean)false, (class_7225.class_7874)registryLookup);
        nbt.method_10544("energy_stored", this.energyStorage.amount);
        this.addColorToNbt(nbt);
    }

    protected void method_11014(class_2487 nbt, class_7225.class_7874 registryLookup) {
        super.method_11014(nbt, registryLookup);
        class_1262.method_5429((class_2487)nbt, this.inventory.heldStacks, (class_7225.class_7874)registryLookup);
        this.energyStorage.amount = nbt.method_10537("energy_stored");
        this.loadColorFromNbt(nbt);
    }

    @Override
    public ColorableMachine.ColorVariant getCurrentColor() {
        return this.currentColor;
    }

    @Override
    public void assignColor(ColorableMachine.ColorVariant color) {
        this.currentColor = color;
        if (this.field_11863 != null && !this.field_11863.method_8608()) {
            this.setChanged(false);
            this.sendUpdate(SyncType.SPARSE_TICK);
        }
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController((GeoAnimatable)this, "machine", 5, state -> PlayState.CONTINUE).triggerableAnim("work", MachineBlockEntity.WORKING).triggerableAnim("idle", MachineBlockEntity.IDLE).setSoundKeyframeHandler(new AutoPlayingSoundKeyframeHandler()));
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.animatableInstanceCache;
    }

    @Override
    public EnergyApi.EnergyStorage getEnergyStorage(class_2350 direction) {
        return this.energyStorage;
    }

    @Override
    public ItemApi.InventoryStorage getInventoryStorage(class_2350 direction) {
        return this.inventory;
    }

    @Override
    public List<ScreenProvider.GuiSlot> getGuiSlots() {
        ArrayList<ScreenProvider.GuiSlot> list = new ArrayList<ScreenProvider.GuiSlot>();
        for (int i = 0; i < this.inventory.method_5439(); ++i) {
            list.add(new ScreenProvider.GuiSlot(i, 40 + i * 19, 25, true));
        }
        return list;
    }

    @Override
    public float getDisplayedEnergyUsage() {
        return 100.0f;
    }

    @Override
    public float getProgress() {
        return 0.0f;
    }

    @Override
    public InventoryInputMode getInventoryInputMode() {
        return InventoryInputMode.FILL_LEFT_TO_RIGHT;
    }

    @Override
    public boolean inputOptionsEnabled() {
        return false;
    }

    @Override
    public boolean showProgress() {
        return false;
    }

    @Override
    public class_1263 getDisplayedInventory() {
        return this.inventory;
    }

    @Override
    public class_3917<?> getScreenHandlerType() {
        return ModScreens.TREEFELLER_SCREEN;
    }

    public class_2561 method_5476() {
        return class_2561.method_30163((String)"");
    }

    @Nullable
    public class_1703 createMenu(int syncId, class_1661 playerInventory, class_1657 player) {
        return new BasicMachineScreenHandler(syncId, playerInventory, this);
    }

    public void playWorkAnimation(String animName) {
        this.triggerAnim("machine", animName);
    }

    public void saveExtraData(class_2540 buf) {
        this.sendUpdate(SyncType.GUI_OPEN);
        buf.method_10807(this.field_11867);
    }
}

