/*
 * Decompiled with CFR 0.152.
 */
package rearth.oritech.block.entity.interaction;

import dev.architectury.fluid.FluidStack;
import dev.architectury.hooks.fluid.FluidStackHooks;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Deque;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2394;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3610;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_5250;
import net.minecraft.class_7225;
import rearth.oritech.Oritech;
import rearth.oritech.api.energy.EnergyApi;
import rearth.oritech.api.energy.containers.SimpleEnergyStorage;
import rearth.oritech.api.fluid.FluidApi;
import rearth.oritech.api.fluid.containers.SimpleFluidStorage;
import rearth.oritech.api.networking.NetworkedBlockEntity;
import rearth.oritech.api.networking.SyncField;
import rearth.oritech.api.networking.SyncType;
import rearth.oritech.block.base.entity.MachineBlockEntity;
import rearth.oritech.init.BlockContent;
import rearth.oritech.init.BlockEntitiesContent;
import rearth.oritech.util.ColorableMachine;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoBlockEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.util.GeckoLibUtil;

public class PumpBlockEntity
extends NetworkedBlockEntity
implements FluidApi.BlockProvider,
EnergyApi.BlockProvider,
GeoBlockEntity,
ColorableMachine {
    private static final int MAX_SEARCH_COUNT = 100000;
    private static final int ENERGY_USAGE = 512;
    private static final int PUMP_RATE = 5;
    protected final AnimatableInstanceCache animatableInstanceCache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private final AnimationController<PumpBlockEntity> animationController = this.getAnimationController();
    private final SimpleFluidStorage fluidStorage = new SimpleFluidStorage(16L * FluidStackHooks.bucketAmount(), this::method_5431);
    private final SimpleEnergyStorage energyStorage = new SimpleEnergyStorage(1000L, 0L, 20000L);
    private boolean initialized = false;
    private boolean toolheadLowered = false;
    private boolean searchActive = false;
    private class_2338 toolheadPosition;
    private FloodFillSearch searchInstance;
    private Deque<class_2338> pendingLiquidPositions;
    @SyncField(value={SyncType.TICK})
    private long lastWorkTime;
    @SyncField(value={SyncType.SPARSE_TICK, SyncType.INITIAL})
    public ColorableMachine.ColorVariant currentColor = this.getDefaultColor();

    public PumpBlockEntity(class_2338 pos, class_2680 state) {
        super(BlockEntitiesContent.PUMP_BLOCK, pos, state);
    }

    protected void method_11007(class_2487 nbt, class_7225.class_7874 registryLookup) {
        super.method_11007(nbt, registryLookup);
        this.fluidStorage.writeNbt(nbt, "");
        nbt.method_10556("initialized", this.initialized);
        nbt.method_10544("energy", this.energyStorage.getAmount());
        this.addColorToNbt(nbt);
        if (this.pendingLiquidPositions != null) {
            nbt.method_10564("pendingTargets", this.pendingLiquidPositions.stream().mapToLong(class_2338::method_10063).toArray());
        }
    }

    protected void method_11014(class_2487 nbt, class_7225.class_7874 registryLookup) {
        super.method_11014(nbt, registryLookup);
        this.loadColorFromNbt(nbt);
        this.initialized = nbt.method_10577("initialized");
        this.fluidStorage.readNbt(nbt, "");
        this.energyStorage.setAmount(nbt.method_10537("energy"));
        this.pendingLiquidPositions = Arrays.stream(nbt.method_10565("pendingTargets")).mapToObj(class_2338::method_10092).collect(Collectors.toCollection(ArrayDeque::new));
    }

    @Override
    public void serverTick(class_1937 world, class_2338 pos, class_2680 state, NetworkedBlockEntity blockEntity) {
        if (this.initialized && this.pendingLiquidPositions.isEmpty() && world.method_8510() % 62L == 0L || !this.initialized && this.toolheadLowered && !this.searchActive && world.method_8510() % 62L == 0L) {
            this.initialized = false;
            this.toolheadLowered = false;
            this.searchActive = false;
            this.toolheadPosition = pos;
        }
        if (!this.initialized) {
            this.progressStartup();
            return;
        }
        if (world.method_8510() % 5L == 0L && this.hasEnoughEnergy() && world.method_49804(pos) <= 0) {
            if (this.pendingLiquidPositions.isEmpty() || this.tankIsFull()) {
                return;
            }
            class_2338 targetBlock = this.pendingLiquidPositions.peekLast();
            if (!world.method_8320(targetBlock).method_26227().method_15771()) {
                this.pendingLiquidPositions.pollLast();
                return;
            }
            class_3610 targetState = world.method_8316(targetBlock);
            if (!targetState.method_15772().method_15780((class_3611)class_3612.field_15910)) {
                this.drainSourceBlock(targetBlock);
                this.pendingLiquidPositions.pollLast();
            }
            this.addLiquidToTank(targetState);
            this.useEnergy();
            this.method_5431();
            this.lastWorkTime = world.method_8510();
            class_243 targetPos = pos.method_46558().method_49272(world.field_9229, 0.5f);
            class_2394 targetType = targetState.method_15766();
            if (targetType != null && world instanceof class_3218) {
                class_3218 serverWorld = (class_3218)world;
                serverWorld.method_14199(targetType, targetPos.method_10216(), targetPos.method_10214(), targetPos.method_10215(), 1, 0.0, 0.0, 0.0, 1.0);
            }
        }
    }

    private boolean isBusy() {
        return this.field_11863.method_8510() - this.lastWorkTime < 40L;
    }

    public void onUsed(class_1657 player) {
        class_5250 message = class_2561.method_43471((String)"message.oritech.pump.starting");
        if (!this.initialized) {
            message = !this.toolheadLowered ? class_2561.method_43471((String)"message.oritech.pump.extending") : (this.searchActive ? class_2561.method_43471((String)"message.oritech.pump.initializing") : class_2561.method_43471((String)"message.oritech.pump.no_fluids"));
        } else if (this.isBusy()) {
            message = class_2561.method_43471((String)"message.oritech.pump.busy");
        } else if (!this.hasEnoughEnergy()) {
            message = class_2561.method_43471((String)"message.oritech.pump.low_energy");
        } else if (this.pendingLiquidPositions.isEmpty()) {
            message = class_2561.method_43471((String)"message.oritech.pump.pump_finished");
        } else if (this.tankIsFull()) {
            message = class_2561.method_43471((String)"message.oritech.pump.full");
        }
        player.method_7353((class_2561)message, true);
    }

    private boolean hasEnoughEnergy() {
        return this.energyStorage.getAmount() >= 512L;
    }

    private void useEnergy() {
        this.energyStorage.extractIgnoringLimit(512L, false);
    }

    private boolean tankIsFull() {
        return this.fluidStorage.getAmount() > this.fluidStorage.getCapacity() - FluidStackHooks.bucketAmount();
    }

    private void addLiquidToTank(class_3610 targetState) {
        this.fluidStorage.insert(FluidStack.create((class_3611)targetState.method_15772(), (long)FluidStackHooks.bucketAmount()), false);
    }

    private void drainSourceBlock(class_2338 targetBlock) {
        this.field_11863.method_8501(targetBlock, class_2246.field_10124.method_9564());
    }

    private void progressStartup() {
        if (this.toolheadPosition == null) {
            this.toolheadPosition = this.field_11867;
        }
        if (!this.toolheadLowered) {
            if (this.field_11863.method_8510() % 10L != 0L) {
                this.moveToolheadDown();
            }
            return;
        }
        if (this.searchActive && this.searchInstance.nextGeneration()) {
            this.finishSearch();
            this.searchActive = false;
        }
    }

    private void moveToolheadDown() {
        this.toolheadLowered = this.checkToolheadEnd(this.toolheadPosition);
        if (this.toolheadLowered) {
            this.startLiquidSearch(this.toolheadPosition.method_10074());
            return;
        }
        this.toolheadPosition = this.toolheadPosition.method_10074();
        this.field_11863.method_8501(this.toolheadPosition, BlockContent.PUMP_TRUNK_BLOCK.method_9564());
    }

    private boolean checkToolheadEnd(class_2338 newPosition) {
        class_2338 posBelow = newPosition.method_10074();
        class_2680 stateBelow = this.field_11863.method_8320(posBelow);
        class_2248 blockBelow = stateBelow.method_26204();
        boolean isAirOrTrunk = stateBelow.method_45474() || blockBelow.equals(BlockContent.PUMP_TRUNK_BLOCK);
        boolean isFluid = !stateBelow.method_26227().method_15769();
        return isFluid || !isAirOrTrunk;
    }

    private void startLiquidSearch(class_2338 start) {
        class_3610 state = this.field_11863.method_8316(start);
        if (!state.method_15771()) {
            return;
        }
        this.searchInstance = new FloodFillSearch(start, this.field_11863, state.method_15772());
        this.searchActive = true;
        Oritech.LOGGER.debug("starting search at: " + String.valueOf(start) + " " + String.valueOf(state.method_15772()) + " " + state.method_15771());
    }

    private void finishSearch() {
        Oritech.LOGGER.debug("search finished, found: " + this.searchInstance.foundTargets.size());
        this.pendingLiquidPositions = this.searchInstance.foundTargets;
        this.initialized = true;
        this.searchInstance = null;
    }

    @Override
    public ColorableMachine.ColorVariant getCurrentColor() {
        return this.currentColor;
    }

    @Override
    public void assignColor(ColorableMachine.ColorVariant color) {
        this.currentColor = color;
        if (this.field_11863 != null && !this.field_11863.method_8608()) {
            this.setChanged(false);
            this.sendUpdate(SyncType.SPARSE_TICK);
        }
    }

    @Override
    public FluidApi.FluidStorage getFluidStorage(class_2350 direction) {
        return this.fluidStorage;
    }

    @Override
    public EnergyApi.EnergyStorage getEnergyStorage(class_2350 direction) {
        return this.energyStorage;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(this.animationController);
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.animatableInstanceCache;
    }

    private AnimationController<PumpBlockEntity> getAnimationController() {
        return new AnimationController((GeoAnimatable)this, state -> {
            if (this.isBusy()) {
                return state.setAndContinue(MachineBlockEntity.WORKING);
            }
            return state.setAndContinue(MachineBlockEntity.IDLE);
        });
    }

    private static class FloodFillSearch {
        final HashSet<class_2338> checkedPositions = new HashSet();
        final HashSet<class_2338> nextTargets = new HashSet();
        final Deque<class_2338> foundTargets = new ArrayDeque<class_2338>();
        final class_1937 world;
        final class_3611 fluidType;

        public FloodFillSearch(class_2338 startPosition, class_1937 world, class_3611 fluidType) {
            this.world = world;
            this.fluidType = fluidType;
            this.nextTargets.add(startPosition);
        }

        public boolean nextGeneration() {
            HashSet currentGeneration = (HashSet)this.nextTargets.clone();
            boolean earlyStop = false;
            for (class_2338 target : currentGeneration) {
                if (this.isValidTarget(target)) {
                    this.foundTargets.addLast(target);
                    this.addNeighborsToQueue(target);
                    if (this.checkForEarlyStop(target)) {
                        earlyStop = true;
                    }
                }
                this.checkedPositions.add(target);
                this.nextTargets.remove(target);
            }
            if (this.cutoffSearch() || earlyStop) {
                this.nextTargets.clear();
            }
            return this.nextTargets.isEmpty();
        }

        private boolean checkForEarlyStop(class_2338 target) {
            return this.world.method_8316(target).method_15772().method_15780((class_3611)class_3612.field_15910);
        }

        private boolean cutoffSearch() {
            return this.foundTargets.size() >= 100000;
        }

        private boolean isValidTarget(class_2338 target) {
            class_3610 state = this.world.method_8316(target);
            return !state.method_15769() && state.method_39360(this.fluidType);
        }

        private void addNeighborsToQueue(class_2338 self) {
            for (class_2338 neighbor : this.getNeighbors(self)) {
                if (this.checkedPositions.contains(neighbor)) continue;
                this.nextTargets.add(neighbor);
            }
        }

        private List<class_2338> getNeighbors(class_2338 pos) {
            return List.of(pos.method_10074(), pos.method_10095(), pos.method_10078(), pos.method_10072(), pos.method_10067());
        }
    }
}

