/*
 * Decompiled with CFR 0.152.
 */
package rearth.oritech.block.entity.interaction;

import com.mojang.authlib.GameProfile;
import dev.architectury.registry.menu.ExtendedMenuProvider;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import net.minecraft.class_1262;
import net.minecraft.class_1263;
import net.minecraft.class_1297;
import net.minecraft.class_1301;
import net.minecraft.class_1309;
import net.minecraft.class_1429;
import net.minecraft.class_1480;
import net.minecraft.class_1569;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1893;
import net.minecraft.class_1922;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2374;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3419;
import net.minecraft.class_3545;
import net.minecraft.class_3917;
import net.minecraft.class_3956;
import net.minecraft.class_6880;
import net.minecraft.class_7225;
import net.minecraft.class_7924;
import net.minecraft.class_8786;
import net.minecraft.class_9129;
import net.minecraft.class_9300;
import net.minecraft.class_9334;
import net.minecraft.class_9695;
import org.jetbrains.annotations.Nullable;
import rearth.oritech.Oritech;
import rearth.oritech.api.energy.EnergyApi;
import rearth.oritech.api.energy.containers.DynamicEnergyStorage;
import rearth.oritech.api.item.ItemApi;
import rearth.oritech.api.item.containers.SimpleInventoryStorage;
import rearth.oritech.api.networking.NetworkedBlockEntity;
import rearth.oritech.api.networking.SyncField;
import rearth.oritech.api.networking.SyncType;
import rearth.oritech.api.networking.WorldPacketCodec;
import rearth.oritech.block.base.block.MultiblockMachine;
import rearth.oritech.block.base.entity.MachineBlockEntity;
import rearth.oritech.block.behavior.LaserArmBlockBehavior;
import rearth.oritech.block.behavior.LaserArmEntityBehavior;
import rearth.oritech.block.blocks.interaction.LaserArmBlock;
import rearth.oritech.block.blocks.processing.MachineCoreBlock;
import rearth.oritech.block.entity.MachineCoreEntity;
import rearth.oritech.block.entity.addons.AddonBlockEntity;
import rearth.oritech.block.entity.addons.CombiAddonEntity;
import rearth.oritech.block.entity.addons.RedstoneAddonBlockEntity;
import rearth.oritech.block.entity.interaction.DestroyerBlockEntity;
import rearth.oritech.client.init.ModScreens;
import rearth.oritech.client.init.ParticleContent;
import rearth.oritech.client.ui.UpgradableMachineScreenHandler;
import rearth.oritech.init.BlockContent;
import rearth.oritech.init.BlockEntitiesContent;
import rearth.oritech.init.TagContent;
import rearth.oritech.init.recipes.OritechRecipe;
import rearth.oritech.init.recipes.RecipeContent;
import rearth.oritech.util.AutoPlayingSoundKeyframeHandler;
import rearth.oritech.util.ColorableMachine;
import rearth.oritech.util.FakeMachinePlayer;
import rearth.oritech.util.Geometry;
import rearth.oritech.util.InventoryInputMode;
import rearth.oritech.util.MachineAddonController;
import rearth.oritech.util.MultiblockMachineController;
import rearth.oritech.util.ScreenProvider;
import rearth.oritech.util.SimpleCraftingInventory;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoBlockEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.util.GeckoLibUtil;

public class LaserArmBlockEntity
extends NetworkedBlockEntity
implements GeoBlockEntity,
EnergyApi.BlockProvider,
ScreenProvider,
ExtendedMenuProvider,
MultiblockMachineController,
MachineAddonController,
ItemApi.BlockProvider,
RedstoneAddonBlockEntity.RedstoneControllable,
ColorableMachine {
    private static final String LASER_PLAYER_NAME = "oritech_laser";
    public static final int BLOCK_BREAK_ENERGY = Oritech.CONFIG.laserArmConfig.blockBreakEnergyBase();
    @SyncField(value={SyncType.GUI_OPEN, SyncType.GUI_TICK})
    protected final DynamicEnergyStorage energyStorage = new DynamicEnergyStorage(this.getDefaultCapacity(), this.getDefaultInsertRate(), 0L, this::method_5431);
    public final SimpleInventoryStorage inventory = new SimpleInventoryStorage(3, this::method_5431);
    protected final AnimatableInstanceCache animatableInstanceCache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private final AnimationController<LaserArmBlockEntity> animationController = this.getAnimationController();
    private final ArrayList<class_2338> coreBlocksConnected = new ArrayList();
    @SyncField(value={SyncType.GUI_OPEN})
    private final List<class_2338> connectedAddons = new ArrayList<class_2338>();
    @SyncField(value={SyncType.GUI_OPEN})
    private final List<class_2338> openSlots = new ArrayList<class_2338>();
    @SyncField(value={SyncType.GUI_OPEN})
    private float coreQuality = 1.0f;
    @SyncField(value={SyncType.GUI_OPEN})
    private MachineAddonController.BaseAddonData addonData = MachineAddonController.BaseAddonData.DEFAULT_ADDON_DATA;
    @SyncField(value={SyncType.GUI_OPEN})
    public int areaSize = 1;
    @SyncField(value={SyncType.GUI_OPEN})
    public int yieldAddons = 0;
    @SyncField(value={SyncType.GUI_OPEN})
    public int hunterAddons = 0;
    @SyncField(value={SyncType.GUI_OPEN})
    public boolean hasCropFilterAddon = false;
    @SyncField(value={SyncType.GUI_OPEN})
    public boolean hasSilkTouchAddon = false;
    @SyncField(value={SyncType.SPARSE_TICK, SyncType.INITIAL})
    public ColorableMachine.ColorVariant currentColor = ColorableMachine.ColorVariant.ORANGE;
    private final int range;
    public class_243 laserHead;
    private class_2338 targetDirection;
    @SyncField
    private class_2338 currentTarget;
    @SyncField
    public HunterTargetMode hunterTargetMode;
    @SyncField
    private class_1309 currentLivingTarget;
    @SyncField
    private long lastFiredAt;
    @SyncField(value={SyncType.GUI_OPEN, SyncType.GUI_TICK})
    private boolean redstonePowered;
    private int progress;
    private ArrayDeque<class_2338> pendingArea;
    private final ArrayDeque<class_1309> pendingLivingTargets;
    private int targetBlockEnergyNeeded;
    public class_243 lastRenderPosition;
    private class_1657 laserPlayerEntity;
    public static WorldPacketCodec<class_9129, class_1309> LASER_TARGET_PACKET_CODEC = new WorldPacketCodec<class_9129, class_1309>(){

        @Override
        public class_1309 decode(class_9129 buf, @Nullable class_1937 world) {
            class_1297 candidate;
            int id = buf.readInt();
            if (world != null && id >= 0 && (candidate = world.method_8469(id)) instanceof class_1309) {
                class_1309 livingEntity = (class_1309)candidate;
                return livingEntity;
            }
            return null;
        }

        @Override
        public void encode(class_9129 buf, class_1309 value, @Nullable class_1937 world) {
            int id = value != null ? value.method_5628() : -1;
            buf.method_53002(id);
        }
    };

    public LaserArmBlockEntity(class_2338 pos, class_2680 state) {
        super(BlockEntitiesContent.LASER_ARM_ENTITY, pos, state);
        this.range = Oritech.CONFIG.laserArmConfig.range();
        this.currentTarget = class_2338.field_10980;
        this.hunterTargetMode = HunterTargetMode.HOSTILE_ONLY;
        this.pendingLivingTargets = new ArrayDeque();
        this.targetBlockEnergyNeeded = BLOCK_BREAK_ENERGY;
        this.laserPlayerEntity = null;
        this.laserHead = this.getLaserHeadPosition().method_46558();
    }

    @Override
    public void serverTick(class_1937 world, class_2338 pos, class_2680 state, NetworkedBlockEntity blockEntity) {
        if (!this.isActive(state)) {
            return;
        }
        if (!this.redstonePowered && this.energyStorage.getAmount() >= (long)this.energyRequiredToFire()) {
            if (this.hunterAddons > 0) {
                this.fireAtLivingEntities(world, pos, state, this);
            } else if (this.currentTarget != null && !this.currentTarget.equals((Object)class_2338.field_10980)) {
                this.fireAtBlocks(world, pos, state, this);
            } else if (this.targetDirection != null && !this.targetDirection.equals((Object)class_2338.field_10980) && (world.method_8510() + (long)pos.method_10260()) % 40L == 0L) {
                this.findNextBlockBreakTarget();
            }
        }
    }

    private void fireAtBlocks(class_1937 world, class_2338 pos, class_2680 state, LaserArmBlockEntity blockEntity) {
        class_2338 targetBlockPos = this.currentTarget;
        class_2680 targetBlockState = world.method_8320(targetBlockPos);
        class_2248 targetBlock = targetBlockState.method_26204();
        class_2586 targetBlockEntity = world.method_8321(targetBlockPos);
        LaserArmBlockBehavior behavior = LaserArmBlock.getBehaviorForBlock(targetBlock);
        boolean fired = false;
        if (behavior.fireAtBlock(world, this, targetBlock, targetBlockPos, targetBlockState, targetBlockEntity)) {
            this.energyStorage.amount -= (long)this.energyRequiredToFire();
            this.lastFiredAt = world.method_8510();
        } else {
            this.findNextBlockBreakTarget();
        }
    }

    private void fireAtLivingEntities(class_1937 world, class_2338 pos, class_2680 state, LaserArmBlockEntity blockEntity) {
        if (this.currentLivingTarget != null && this.validTarget(this.currentLivingTarget)) {
            LaserArmEntityBehavior behavior = LaserArmBlock.getBehaviorForEntity(this.currentLivingTarget.method_5864());
            if (behavior.fireAtEntity(world, this, this.currentLivingTarget)) {
                this.energyStorage.amount -= (long)this.energyRequiredToFire();
                this.targetDirection = this.currentLivingTarget.method_24515();
                this.lastFiredAt = world.method_8510();
            } else {
                this.pendingLivingTargets.remove(this.currentLivingTarget);
                this.currentLivingTarget = null;
                this.currentTarget = class_2338.field_10980;
            }
        } else {
            this.loadNextLivingTarget();
        }
    }

    public void setRedstonePowered(boolean redstonePowered) {
        this.redstonePowered = redstonePowered;
    }

    public void addBlockBreakProgress(int progress) {
        this.progress += progress;
    }

    public int getBlockBreakProgress() {
        return this.progress;
    }

    public int getTargetBlockEnergyNeeded() {
        return this.targetBlockEnergyNeeded;
    }

    public void finishBlockBreaking(class_2338 targetPos, class_2680 targetBlockState) {
        this.progress -= this.targetBlockEnergyNeeded;
        class_2586 targetEntity = this.field_11863.method_8321(targetPos);
        List<class_1799> dropped = this.hasSilkTouchAddon ? DestroyerBlockEntity.getSilkTouchDrops(targetBlockState, (class_3218)this.field_11863, targetPos, targetEntity, this.getLaserPlayerEntity()) : (this.yieldAddons > 0 ? DestroyerBlockEntity.getLootDrops(targetBlockState, (class_3218)this.field_11863, targetPos, targetEntity, this.yieldAddons, this.getLaserPlayerEntity()) : class_2248.method_9609((class_2680)targetBlockState, (class_3218)((class_3218)this.field_11863), (class_2338)targetPos, (class_2586)targetEntity, (class_1297)this.getLaserPlayerEntity(), (class_1799)class_1799.field_8037));
        class_8786<OritechRecipe> blockRecipe = LaserArmBlockEntity.tryGetRecipeOfBlock(targetBlockState, this.field_11863);
        if (blockRecipe != null) {
            OritechRecipe recipe = (OritechRecipe)blockRecipe.comp_1933();
            int farmedCount = 1 + this.yieldAddons;
            dropped = List.of(new class_1799((class_1935)recipe.getResults().get(0).method_7909(), farmedCount));
            ParticleContent.CHARGING.spawn(this.field_11863, class_243.method_24954((class_2382)targetPos), (Object)1);
        }
        for (class_1799 stack : dropped) {
            this.inventory.insert(stack, false);
        }
        try {
            targetBlockState.method_26204().method_9576(this.field_11863, targetPos, targetBlockState, this.getLaserPlayerEntity());
        }
        catch (Exception exception) {
            Oritech.LOGGER.warn("Laser arm block break event failure when breaking " + String.valueOf(targetBlockState) + " at " + String.valueOf(targetPos) + ": " + exception.getLocalizedMessage());
        }
        this.field_11863.method_31595(targetPos, this.field_11863.method_8320(targetPos));
        this.field_11863.method_8396(null, targetPos, targetBlockState.method_26231().method_10595(), class_3419.field_15245, 1.0f, 1.0f);
        this.field_11863.method_22352(targetPos, false);
        this.findNextBlockBreakTarget();
    }

    public static class_8786<OritechRecipe> tryGetRecipeOfBlock(class_2680 destroyed, class_1937 world) {
        class_1792 inputItem = destroyed.method_26204().method_8389();
        SimpleCraftingInventory inputInv = new SimpleCraftingInventory(new class_1799((class_1935)inputItem));
        Optional candidate = world.method_8433().method_8132((class_3956)RecipeContent.LASER, (class_9695)inputInv, world);
        return candidate.orElse(null);
    }

    public class_1657 getLaserPlayerEntity() {
        if (!(this.field_11863 instanceof class_3218)) {
            return null;
        }
        if (this.laserPlayerEntity == null) {
            this.laserPlayerEntity = FakeMachinePlayer.create((class_3218)this.field_11863, new GameProfile(UUID.randomUUID(), LASER_PLAYER_NAME), this.inventory);
            this.laserPlayerEntity.method_33574(class_243.method_24954((class_2382)this.method_11016()));
        }
        if (this.hunterAddons > 0 && this.yieldAddons > 0) {
            class_1799 lootingSword = new class_1799((class_1935)class_1802.field_22022);
            lootingSword.method_57379(class_9334.field_49630, (Object)new class_9300(false));
            class_6880.class_6883 lootingEntry = (class_6880.class_6883)this.field_11863.method_30349().method_30530(class_7924.field_41265).method_40264(class_1893.field_9110).get();
            lootingSword.method_7978((class_6880)lootingEntry, Math.min(this.yieldAddons, 3));
            this.laserPlayerEntity.method_31548().field_7547.set(this.laserPlayerEntity.method_31548().field_7545, (Object)lootingSword);
        }
        return this.laserPlayerEntity;
    }

    private void findNextBlockBreakTarget() {
        while (this.pendingArea != null && !this.pendingArea.isEmpty()) {
            if (!this.trySetNewTarget(this.pendingArea.pop(), false)) continue;
            if (this.pendingArea.isEmpty()) {
                this.pendingArea = null;
            }
            return;
        }
        class_243 direction = class_243.method_24954((class_2382)this.targetDirection.method_10059((class_2382)this.getLaserHeadPosition())).method_1029();
        class_243 from = this.laserHead.method_1019(direction.method_1021(1.5));
        class_2338 nextBlock = this.basicRaycast(from, direction, this.range, 0.45f);
        if (nextBlock == null) {
            this.currentTarget = class_2338.field_10980;
            return;
        }
        int maxSize = (int)from.method_1022(nextBlock.method_46558()) - 1;
        int scanDist = Math.min(this.areaSize, maxSize);
        if (scanDist > 1) {
            this.pendingArea = this.findNextAreaBlockTarget(nextBlock, scanDist);
        }
        if (!this.trySetNewTarget(nextBlock, false)) {
            this.currentTarget = class_2338.field_10980;
        }
    }

    private double hunterRange() {
        return Math.pow(4.0, Math.min(this.hunterAddons, 3)) + 0.5;
    }

    private boolean canSee(class_1309 entity) {
        if (entity.method_37908() != this.method_10997() || entity.method_5767()) {
            return false;
        }
        class_243 target = entity.method_33571();
        class_243 direction = target.method_1020(this.laserHead).method_1029();
        if (this.laserHead.method_1022(target) > 128.0) {
            return false;
        }
        return this.basicRaycast(this.laserHead.method_1019(direction.method_1021(1.5)), direction, (int)(this.laserHead.method_1022(target) - 1.0), 0.2f) == null;
    }

    private boolean validTarget(class_1309 entity) {
        return entity.method_5805() && this.canSee(entity) && this.huntedTarget(entity) && entity.method_19538().method_24802((class_2374)this.getLaserHeadPosition().method_46558(), this.hunterRange());
    }

    private boolean huntedTarget(class_1309 entity) {
        if (entity instanceof class_1657) {
            return true;
        }
        return switch (this.hunterTargetMode.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> entity instanceof class_1569;
            case 1 -> {
                class_1429 animal;
                if (entity instanceof class_1429 && (animal = (class_1429)entity).method_6478() == null || entity instanceof class_1480) {
                    yield true;
                }
                yield entity instanceof class_1569;
            }
            case 2 -> true;
        };
    }

    private void loadNextLivingTarget() {
        if (this.pendingLivingTargets.isEmpty() && (this.field_11863.method_8510() + this.field_11867.method_10063()) % 10L == 0L) {
            this.updateEntityTargets();
        }
        while (!this.pendingLivingTargets.isEmpty()) {
            class_1309 candidate = this.pendingLivingTargets.pop();
            if (!this.validTarget(candidate)) continue;
            this.currentLivingTarget = candidate;
            this.currentTarget = candidate.method_24515();
            return;
        }
    }

    private void updateEntityTargets() {
        double entityRange = this.hunterRange();
        List targets = this.field_11863.method_8390(class_1309.class, new class_238(this.laserHead.field_1352 - entityRange, this.laserHead.field_1351 - entityRange, this.laserHead.field_1350 - entityRange, this.laserHead.field_1352 + entityRange, this.laserHead.field_1351 + entityRange, this.laserHead.field_1350 + entityRange), class_1301.field_6157.and(class_1301.field_6156));
        targets.sort(Comparator.comparingDouble(entity -> entity.method_5707(this.laserHead)));
        this.pendingLivingTargets.addAll(targets);
    }

    private ArrayDeque<class_2338> findNextAreaBlockTarget(class_2338 center, int scanDist) {
        ArrayList<class_2338> targets = new ArrayList<class_2338>();
        for (int x = -scanDist; x < scanDist; ++x) {
            for (int y = -scanDist; y < scanDist; ++y) {
                for (int z = -scanDist; z < scanDist; ++z) {
                    class_2338 pos = center.method_10069(x, y, z);
                    if (this.canPassThrough(this.field_11863.method_8320(pos), pos) || center.equals((Object)pos)) continue;
                    targets.add(pos);
                }
            }
        }
        targets.sort(Comparator.comparingInt(arg_0 -> ((class_2338)this.field_11867).method_19455(arg_0)));
        return new ArrayDeque<class_2338>(targets);
    }

    private class_2338 basicRaycast(class_243 from, class_243 direction, int range, float searchOffset) {
        for (float i = 0.0f; i < (float)range; i += 0.3f) {
            class_243 to = from.method_1019(direction.method_1021((double)i));
            class_2338 targetBlockPos = class_2338.method_49638((class_2374)to.method_1031(0.0, (double)searchOffset, 0.0));
            class_2680 targetState = this.field_11863.method_8320(targetBlockPos);
            if (this.isSearchTerminatorBlock(targetState)) {
                return null;
            }
            if (!this.canPassThrough(targetState, targetBlockPos)) {
                return targetBlockPos;
            }
            if (searchOffset == 0.0f) {
                return null;
            }
            class_243 offsetTop = to.method_1031(0.0, (double)(-searchOffset), 0.0);
            targetBlockPos = class_2338.method_49638((class_2374)offsetTop);
            targetState = this.field_11863.method_8320(targetBlockPos);
            if (this.isSearchTerminatorBlock(targetState)) {
                return null;
            }
            if (!this.canPassThrough(targetState, targetBlockPos)) {
                return targetBlockPos;
            }
            class_243 offsetLeft = to.method_1031((double)(-searchOffset), 0.0, 0.0);
            targetBlockPos = class_2338.method_49638((class_2374)offsetLeft);
            targetState = this.field_11863.method_8320(targetBlockPos);
            if (this.isSearchTerminatorBlock(targetState)) {
                return null;
            }
            if (!this.canPassThrough(targetState, targetBlockPos)) {
                return targetBlockPos;
            }
            class_243 offsetRight = to.method_1031((double)searchOffset, 0.0, 0.0);
            targetBlockPos = class_2338.method_49638((class_2374)offsetRight);
            targetState = this.field_11863.method_8320(targetBlockPos);
            if (this.isSearchTerminatorBlock(targetState)) {
                return null;
            }
            if (!this.canPassThrough(targetState, targetBlockPos)) {
                return targetBlockPos;
            }
            class_243 offsetFront = to.method_1031(0.0, 0.0, (double)searchOffset);
            targetBlockPos = class_2338.method_49638((class_2374)offsetFront);
            targetState = this.field_11863.method_8320(targetBlockPos);
            if (this.isSearchTerminatorBlock(targetState)) {
                return null;
            }
            if (!this.canPassThrough(targetState, targetBlockPos)) {
                return targetBlockPos;
            }
            class_243 offsetBack = to.method_1031(0.0, 0.0, (double)(-searchOffset));
            targetBlockPos = class_2338.method_49638((class_2374)offsetBack);
            targetState = this.field_11863.method_8320(targetBlockPos);
            if (this.isSearchTerminatorBlock(targetState)) {
                return null;
            }
            if (this.canPassThrough(targetState, targetBlockPos)) continue;
            return targetBlockPos;
        }
        return null;
    }

    private boolean isSearchTerminatorBlock(class_2680 state) {
        return state.method_26204().equals(class_2246.field_22422);
    }

    public boolean canPassThrough(class_2680 state, class_2338 blockPos) {
        return state.method_26215() || !state.method_26227().method_15769() || state.method_26164(TagContent.LASER_PASSTHROUGH) || this.hunterAddons > 0 && !state.method_26212((class_1922)this.field_11863, blockPos);
    }

    @Override
    public void gatherAddonStats(List<MachineAddonController.AddonBlock> addons) {
        this.areaSize = 1;
        this.yieldAddons = 0;
        this.hunterAddons = 0;
        this.hasCropFilterAddon = false;
        this.hasSilkTouchAddon = false;
        MachineAddonController.super.gatherAddonStats(addons);
        this.yieldAddons = Math.min(this.yieldAddons, 3);
    }

    @Override
    public void getAdditionalStatFromAddon(MachineAddonController.AddonBlock addonBlock) {
        AddonBlockEntity addonBlockEntity;
        MachineAddonController.super.getAdditionalStatFromAddon(addonBlock);
        if (addonBlock.state().method_26204().equals(BlockContent.QUARRY_ADDON)) {
            ++this.areaSize;
        }
        if (addonBlock.state().method_26204().equals(BlockContent.MACHINE_HUNTER_ADDON)) {
            ++this.hunterAddons;
        }
        if (addonBlock.state().method_26204().equals(BlockContent.MACHINE_YIELD_ADDON)) {
            ++this.yieldAddons;
        }
        if (addonBlock.state().method_26204().equals(BlockContent.CROP_FILTER_ADDON)) {
            this.hasCropFilterAddon = true;
        }
        if (addonBlock.state().method_26204().equals(BlockContent.MACHINE_SILK_TOUCH_ADDON)) {
            this.hasSilkTouchAddon = true;
        }
        if ((addonBlockEntity = addonBlock.addonEntity()) instanceof CombiAddonEntity) {
            CombiAddonEntity combi = (CombiAddonEntity)addonBlockEntity;
            this.areaSize = combi.getQuarryCount();
            this.yieldAddons = combi.getYieldCount();
            this.hasCropFilterAddon = combi.hasCropFilter();
            this.hasSilkTouchAddon = combi.hasSilk();
        }
    }

    public int energyRequiredToFire() {
        return (int)((float)Oritech.CONFIG.laserArmConfig.energyPerTick() * (1.0f / this.addonData.speed()));
    }

    public float getDamageTick() {
        return Oritech.CONFIG.laserArmConfig.damageTickBase() * (1.0f / this.addonData.speed());
    }

    public boolean setTargetFromDesignator(class_2338 targetPos) {
        boolean success = this.trySetNewTarget(targetPos, true);
        this.findNextBlockBreakTarget();
        return success;
    }

    public void cycleHunterTargetMode() {
        this.hunterTargetMode = this.hunterTargetMode.next();
    }

    private boolean trySetNewTarget(class_2338 targetPos, boolean alsoSetDirection) {
        MachineCoreEntity coreEntity;
        class_2338 controllerPos;
        class_2680 targetState = Objects.requireNonNull(this.field_11863).method_8320(targetPos);
        if (targetState.method_26204() instanceof MachineCoreBlock && ((Boolean)targetState.method_11654((class_2769)MachineCoreBlock.USED)).booleanValue() && (controllerPos = Objects.requireNonNull(coreEntity = (MachineCoreEntity)this.field_11863.method_8321(targetPos)).getControllerPos()) != null) {
            targetPos = controllerPos;
        }
        int distance = targetPos.method_19455((class_2382)this.field_11867);
        float blockHardness = targetState.method_26204().method_36555();
        if (distance > this.range || (double)blockHardness < 0.0 || targetState.method_26204().equals(class_2246.field_10124)) {
            return false;
        }
        this.targetBlockEnergyNeeded = (int)((double)BLOCK_BREAK_ENERGY * Math.pow(blockHardness, Oritech.CONFIG.blockBreakHardnessExponentialFactor()) * (double)this.addonData.efficiency());
        if (targetState.method_26164(TagContent.LASER_FAST_BREAKING)) {
            this.targetBlockEnergyNeeded /= 8;
        }
        this.currentTarget = targetPos;
        if (alsoSetDirection) {
            this.targetDirection = targetPos;
            this.pendingArea = null;
            this.method_5431();
        }
        this.method_5431();
        return true;
    }

    protected void method_11007(class_2487 nbt, class_7225.class_7874 registryLookup) {
        super.method_11007(nbt, registryLookup);
        class_1262.method_5427((class_2487)nbt, this.inventory.heldStacks, (boolean)false, (class_7225.class_7874)registryLookup);
        this.addMultiblockToNbt(nbt);
        this.writeAddonToNbt(nbt);
        this.addColorToNbt(nbt);
        nbt.method_10544("energy_stored", this.energyStorage.amount);
        nbt.method_10556("redstone", this.redstonePowered);
        nbt.method_10569("areaSize", this.areaSize);
        nbt.method_10569("yieldAddons", this.yieldAddons);
        nbt.method_10569("hunterAddons", this.hunterAddons);
        nbt.method_10556("cropAddon", this.hasCropFilterAddon);
        nbt.method_10556("silkAddon", this.hasSilkTouchAddon);
        nbt.method_10569("hunterTargetMode", this.hunterTargetMode.value);
        if (this.targetDirection != null && this.currentTarget != null) {
            nbt.method_10544("target_position", this.currentTarget.method_10063());
            nbt.method_10544("target_direction", this.targetDirection.method_10063());
        }
        if (this.pendingArea != null && !this.pendingArea.isEmpty()) {
            long[] positions = this.pendingArea.stream().mapToLong(class_2338::method_10063).toArray();
            nbt.method_10564("pendingPositions", positions);
        } else {
            nbt.method_10551("pendingPositions");
        }
    }

    protected void method_11014(class_2487 nbt, class_7225.class_7874 registryLookup) {
        super.method_11014(nbt, registryLookup);
        class_1262.method_5429((class_2487)nbt, this.inventory.heldStacks, (class_7225.class_7874)registryLookup);
        this.loadMultiblockNbtData(nbt);
        this.loadAddonNbtData(nbt);
        this.loadColorFromNbt(nbt);
        this.updateEnergyContainer();
        this.redstonePowered = nbt.method_10577("redstone");
        this.energyStorage.amount = nbt.method_10537("energy_stored");
        this.targetDirection = class_2338.method_10092((long)nbt.method_10537("target_direction"));
        this.currentTarget = class_2338.method_10092((long)nbt.method_10537("target_position"));
        this.areaSize = nbt.method_10550("areaSize");
        this.yieldAddons = nbt.method_10550("yieldAddons");
        this.hunterAddons = nbt.method_10550("hunterAddons");
        this.hunterTargetMode = HunterTargetMode.fromValue(nbt.method_10550("hunterTargetMode"));
        this.hasCropFilterAddon = nbt.method_10577("cropAddon");
        this.hasSilkTouchAddon = nbt.method_10577("silkAddon");
        if (nbt.method_10545("pendingPositions")) {
            this.pendingArea = Arrays.stream(nbt.method_10565("pendingPositions")).mapToObj(class_2338::method_10092).collect(Collectors.toCollection(ArrayDeque::new));
        }
    }

    @Override
    public ArrayList<class_2338> getConnectedCores() {
        return this.coreBlocksConnected;
    }

    @Override
    public class_2350 getFacingForMultiblock() {
        class_2680 state = this.method_11010();
        return ((class_2350)state.method_11654((class_2769)class_2741.field_12525)).method_10153();
    }

    @Override
    public class_2338 getPosForMultiblock() {
        return this.field_11867;
    }

    @Override
    public class_1937 getWorldForMultiblock() {
        return this.field_11863;
    }

    @Override
    public float getCoreQuality() {
        return this.coreQuality;
    }

    @Override
    public void setCoreQuality(float quality) {
        this.coreQuality = quality;
    }

    @Override
    public ItemApi.InventoryStorage getInventoryForMultiblock() {
        return this.inventory;
    }

    @Override
    public EnergyApi.EnergyStorage getEnergyStorageForMultiblock(class_2350 direction) {
        return this.energyStorage;
    }

    @Override
    public List<class_2382> getCorePositions() {
        return List.of(new class_2382(1, 0, 0));
    }

    @Override
    public EnergyApi.EnergyStorage getEnergyStorage(class_2350 direction) {
        return this.energyStorage;
    }

    @Override
    public List<class_2338> getConnectedAddons() {
        return this.connectedAddons;
    }

    @Override
    public List<class_2338> getOpenAddonSlots() {
        return this.openSlots;
    }

    @Override
    public class_2350 getFacingForAddon() {
        class_2680 state = this.method_11010();
        return ((class_2350)state.method_11654((class_2769)class_2741.field_12525)).method_10153();
    }

    @Override
    public DynamicEnergyStorage getStorageForAddon() {
        return this.energyStorage;
    }

    @Override
    public ItemApi.InventoryStorage getInventoryForAddon() {
        return this.inventory;
    }

    @Override
    public ScreenProvider getScreenProvider() {
        return null;
    }

    @Override
    public List<class_2382> getAddonSlots() {
        return List.of(new class_2382(-1, 0, 0));
    }

    @Override
    public MachineAddonController.BaseAddonData getBaseAddonData() {
        return this.addonData;
    }

    @Override
    public void setBaseAddonData(MachineAddonController.BaseAddonData data) {
        this.addonData = data;
    }

    @Override
    public long getDefaultCapacity() {
        return Oritech.CONFIG.laserArmConfig.energyCapacity();
    }

    @Override
    public long getDefaultInsertRate() {
        return Oritech.CONFIG.laserArmConfig.maxEnergyInsertion();
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(this.animationController);
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.animatableInstanceCache;
    }

    private AnimationController<LaserArmBlockEntity> getAnimationController() {
        return new AnimationController((GeoAnimatable)this, state -> {
            if (state.isCurrentAnimation(MachineBlockEntity.SETUP)) {
                if (state.getController().hasAnimationFinished()) {
                    state.setAndContinue(MachineBlockEntity.IDLE);
                } else {
                    return state.setAndContinue(MachineBlockEntity.SETUP);
                }
            }
            if (this.isActive(this.method_11010())) {
                if (this.isFiring()) {
                    return state.setAndContinue(MachineBlockEntity.WORKING);
                }
                return state.setAndContinue(MachineBlockEntity.IDLE);
            }
            return state.setAndContinue(MachineBlockEntity.PACKAGED);
        }).triggerableAnim("setup", MachineBlockEntity.SETUP).setSoundKeyframeHandler(new AutoPlayingSoundKeyframeHandler());
    }

    @Override
    public void triggerSetupAnimation() {
        this.triggerAnim("base_controller", "setup");
    }

    @Override
    public void sendUpdate(SyncType type, class_3222 player) {
        if (type.equals((Object)SyncType.GUI_TICK)) {
            super.sendUpdate(SyncType.GUI_OPEN, player);
            return;
        }
        super.sendUpdate(type, player);
    }

    public boolean isActive(class_2680 state) {
        return (Boolean)state.method_11654((class_2769)MultiblockMachine.ASSEMBLED);
    }

    @Override
    public ItemApi.InventoryStorage getInventoryStorage(class_2350 direction) {
        return this.inventory;
    }

    public class_2338 getCurrentTarget() {
        return this.currentTarget;
    }

    public class_243 getVisualTarget() {
        if (this.hunterAddons > 0 && this.currentLivingTarget != null) {
            return this.currentLivingTarget.method_33571().method_1023(0.5, 0.0, 0.5);
        }
        return this.getCurrentTarget().method_46558();
    }

    @Override
    public class_2338 getPosForAddon() {
        return this.method_11016();
    }

    @Override
    public class_1937 getWorldForAddon() {
        return this.method_10997();
    }

    public boolean isFiring() {
        long idleTime = this.field_11863.method_8510() - this.lastFiredAt;
        return idleTime < 5L;
    }

    @Override
    public int getTickUpdateInterval() {
        return 2;
    }

    public boolean isTargetingAtomicForge(class_2248 block) {
        return block.equals(BlockContent.ATOMIC_FORGE_BLOCK);
    }

    public boolean isTargetingDeepdrill(class_2248 block) {
        return block.equals(BlockContent.DEEP_DRILL_BLOCK);
    }

    public boolean isTargetingCatalyst(class_2248 block) {
        return block.equals(BlockContent.ENCHANTMENT_CATALYST_BLOCK);
    }

    public boolean isTargetingUnstableContainer(class_2248 block) {
        return block.equals(BlockContent.UNSTABLE_CONTAINER);
    }

    public boolean isTargetingEnergyContainer() {
        EnergyApi.EnergyStorage storageCandidate = EnergyApi.BLOCK.find(this.field_11863, this.currentTarget, null);
        class_2248 block = this.field_11863.method_8320(this.currentTarget).method_26204();
        return storageCandidate != null || this.isTargetingAtomicForge(block) || this.isTargetingDeepdrill(block) || this.isTargetingCatalyst(block) || this.isTargetingUnstableContainer(block);
    }

    public boolean isTargetingBuddingAmethyst() {
        return this.field_11863.method_8320(this.currentTarget).method_26164(TagContent.LASER_ACCELERATED);
    }

    @Override
    public List<class_3545<class_2561, class_2561>> getExtraExtensionLabels() {
        if (this.areaSize == 1 && this.yieldAddons == 0 && this.hunterAddons == 0 && !this.hasSilkTouchAddon) {
            return ScreenProvider.super.getExtraExtensionLabels();
        }
        if (this.hunterAddons > 0) {
            return List.of(new class_3545((Object)class_2561.method_43469((String)"title.oritech.machine.addon_range", (Object[])new Object[]{(int)this.hunterRange()}), (Object)class_2561.method_43471((String)"tooltip.oritech.laser_arm.addon_hunter_range")), new class_3545((Object)class_2561.method_43469((String)"title.oritech.laser_arm.addon_hunter_damage", (Object[])new Object[]{String.format("%.2f", Float.valueOf(this.getDamageTick()))}), (Object)class_2561.method_43471((String)"tooltip.oritech.laser_arm.addon_hunter_damage")), new class_3545((Object)class_2561.method_43469((String)"title.oritech.machine.addon_looting", (Object[])new Object[]{this.yieldAddons}), (Object)class_2561.method_43471((String)"tooltip.oritech.machine.addon_looting")));
        }
        if (this.hasSilkTouchAddon) {
            return List.of(new class_3545((Object)class_2561.method_43469((String)"title.oritech.machine.addon_range", (Object[])new Object[]{this.areaSize}), (Object)class_2561.method_43471((String)"tooltip.oritech.laser_arm.addon_range")), new class_3545((Object)class_2561.method_43471((String)"enchantment.minecraft.silk_touch"), (Object)class_2561.method_43471((String)"tooltip.oritech.machine.addon_silk_touch")));
        }
        return List.of(new class_3545((Object)class_2561.method_43469((String)"title.oritech.machine.addon_range", (Object[])new Object[]{this.areaSize}), (Object)class_2561.method_43471((String)"tooltip.oritech.laser_arm.addon_range")), new class_3545((Object)class_2561.method_43469((String)"title.oritech.machine.addon_fortune", (Object[])new Object[]{this.yieldAddons}), (Object)class_2561.method_43471((String)"tooltip.oritech.machine.addon_fortune")));
    }

    @Override
    public List<ScreenProvider.GuiSlot> getGuiSlots() {
        return List.of(new ScreenProvider.GuiSlot(0, 117, 20, true), new ScreenProvider.GuiSlot(1, 117, 38, true), new ScreenProvider.GuiSlot(2, 117, 56, true));
    }

    @Override
    public float getDisplayedEnergyUsage() {
        return this.energyRequiredToFire();
    }

    @Override
    public float getProgress() {
        return 0.0f;
    }

    @Override
    public boolean showProgress() {
        return false;
    }

    @Override
    public InventoryInputMode getInventoryInputMode() {
        return InventoryInputMode.FILL_LEFT_TO_RIGHT;
    }

    @Override
    public boolean inputOptionsEnabled() {
        return false;
    }

    @Override
    public class_1263 getDisplayedInventory() {
        return this.inventory;
    }

    @Override
    public float getDisplayedEnergyTransfer() {
        return this.energyStorage.maxInsert;
    }

    @Override
    public class_3917<?> getScreenHandlerType() {
        return ModScreens.LASER_SCREEN;
    }

    @Override
    public class_2769<class_2350> getBlockFacingProperty() {
        return class_2741.field_12525;
    }

    @Nullable
    public class_1703 createMenu(int syncId, class_1661 playerInventory, class_1657 player) {
        return new UpgradableMachineScreenHandler(syncId, playerInventory, this);
    }

    public void saveExtraData(class_2540 buf) {
        this.sendUpdate(SyncType.GUI_OPEN);
        buf.method_10807(this.field_11867);
    }

    public class_2561 method_5476() {
        return class_2561.method_43470((String)"");
    }

    @Override
    public int getComparatorEnergyAmount() {
        return (int)((float)this.energyStorage.amount / (float)this.energyStorage.capacity * 15.0f);
    }

    @Override
    public int getComparatorSlotAmount(int slot) {
        if (this.inventory.heldStacks.size() <= slot) {
            return 0;
        }
        class_1799 stack = this.inventory.method_5438(slot);
        if (stack.method_7960()) {
            return 0;
        }
        return (int)((float)stack.method_7947() / (float)stack.method_7914() * 15.0f);
    }

    @Override
    public int getComparatorProgress() {
        if (this.currentTarget == null || this.currentTarget.equals((Object)class_2338.field_10980)) {
            return 0;
        }
        return (int)(this.currentTarget.method_10262((class_2382)this.field_11867) / (double)this.range) * 15;
    }

    @Override
    public int getComparatorActiveState() {
        long idleTicks = this.field_11863.method_8510() - this.lastFiredAt;
        return idleTicks > 3L ? 15 : 0;
    }

    @Override
    public boolean hasRedstoneControlAvailable() {
        return true;
    }

    @Override
    public int receivedRedstoneSignal() {
        if (this.redstonePowered) {
            return 15;
        }
        return this.field_11863.method_49804(this.field_11867);
    }

    @Override
    public String currentRedstoneEffect() {
        if (this.redstonePowered) {
            return "tooltip.oritech.redstone_disabled";
        }
        return "tooltip.oritech.redstone_enabled_direct";
    }

    public class_2338 getLaserHeadPosition() {
        class_2680 state = this.method_11010();
        class_2350 facing = (class_2350)state.method_11654((class_2769)class_2741.field_12525);
        class_2382 offset = new class_2382(-1, 0, 0);
        return new class_2338(Geometry.offsetToWorldPosition(facing, offset, (class_2382)this.field_11867));
    }

    @Override
    public void onRedstoneEvent(boolean isPowered) {
        this.redstonePowered = isPowered;
    }

    @Override
    public ColorableMachine.ColorVariant getCurrentColor() {
        return this.currentColor;
    }

    @Override
    public void assignColor(ColorableMachine.ColorVariant color) {
        this.currentColor = color;
        if (this.field_11863 != null && !this.field_11863.method_8608()) {
            this.setChanged(false);
            this.sendUpdate(SyncType.SPARSE_TICK);
        }
    }

    public static enum HunterTargetMode {
        HOSTILE_ONLY(1, "message.oritech.target_designator.hunter_hostile"),
        HOSTILE_NEUTRAL(2, "message.oritech.target_designator.hunter_neutral"),
        ALL(3, "message.oritech.target_designator.hunter_all");

        public final int value;
        public final String message;
        private static final Map<Integer, HunterTargetMode> map;

        private HunterTargetMode(int value, String message) {
            this.value = value;
            this.message = message;
        }

        public static HunterTargetMode fromValue(int i) {
            return map.getOrDefault(i, HOSTILE_ONLY);
        }

        public HunterTargetMode next() {
            return HunterTargetMode.values()[(this.ordinal() + 1) % HunterTargetMode.values().length];
        }

        static {
            map = new HashMap<Integer, HunterTargetMode>();
            for (HunterTargetMode targetMode : HunterTargetMode.values()) {
                map.put(targetMode.value, targetMode);
            }
        }
    }
}

