/*
 * Decompiled with CFR 0.152.
 */
package rearth.oritech.block.entity.interaction;

import dev.architectury.fluid.FluidStack;
import dev.architectury.hooks.fluid.FluidStackHooks;
import java.util.List;
import java.util.Objects;
import net.minecraft.class_1799;
import net.minecraft.class_2248;
import net.minecraft.class_2256;
import net.minecraft.class_2302;
import net.minecraft.class_2338;
import net.minecraft.class_2344;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_3917;
import net.minecraft.class_4538;
import net.minecraft.class_7225;
import rearth.oritech.Oritech;
import rearth.oritech.api.fluid.FluidApi;
import rearth.oritech.api.fluid.containers.SimpleFluidStorage;
import rearth.oritech.api.networking.SyncField;
import rearth.oritech.api.networking.SyncType;
import rearth.oritech.block.base.entity.ItemEnergyFrameInteractionBlockEntity;
import rearth.oritech.client.init.ModScreens;
import rearth.oritech.client.init.ParticleContent;
import rearth.oritech.init.BlockContent;
import rearth.oritech.init.BlockEntitiesContent;
import rearth.oritech.init.FluidContent;
import rearth.oritech.init.TagContent;
import rearth.oritech.util.ScreenProvider;

public class FertilizerBlockEntity
extends ItemEnergyFrameInteractionBlockEntity
implements FluidApi.BlockProvider {
    public static final long FLUID_USAGE = (long)(Oritech.CONFIG.fertilizerConfig.liquidPerBlockUsage() * (float)FluidStackHooks.bucketAmount());
    @SyncField(value={SyncType.GUI_TICK})
    private final SimpleFluidStorage fluidStorage = new SimpleFluidStorage(this, 4L * FluidStackHooks.bucketAmount(), this::method_5431){

        @Override
        public long insert(FluidStack toInsert, boolean simulate) {
            class_3611 fluid = toInsert.getFluid();
            if (fluid.equals(FluidContent.STILL_MINERAL_SLURRY.get()) || fluid.equals(class_3612.field_15910)) {
                return super.insert(toInsert, simulate);
            }
            return 0L;
        }
    };

    @Override
    protected void method_11007(class_2487 nbt, class_7225.class_7874 registryLookup) {
        super.method_11007(nbt, registryLookup);
        this.fluidStorage.writeNbt(nbt, "");
    }

    @Override
    protected void method_11014(class_2487 nbt, class_7225.class_7874 registryLookup) {
        super.method_11014(nbt, registryLookup);
        this.fluidStorage.readNbt(nbt, "");
    }

    @Override
    public List<ScreenProvider.GuiSlot> getGuiSlots() {
        return List.of(new ScreenProvider.GuiSlot(0, 56, 38));
    }

    public FertilizerBlockEntity(class_2338 pos, class_2680 state) {
        super(BlockEntitiesContent.FERTILIZER_BLOCK_ENTITY, pos, state);
    }

    private long getWaterUsagePerTick() {
        return (long)((float)FLUID_USAGE / this.getWorkTime());
    }

    private boolean hasEnoughWater() {
        return this.fluidStorage.getAmount() >= this.getWaterUsagePerTick();
    }

    @Override
    protected boolean canProgress() {
        return this.hasEnoughWater() && super.canProgress();
    }

    @Override
    protected boolean hasWorkAvailable(class_2338 toolPosition) {
        class_2256 fertilizable;
        class_2338 targetPosition = toolPosition.method_10074();
        class_2680 targetState = Objects.requireNonNull(this.field_11863).method_8320(targetPosition);
        if (this.canFertilizeFarmland(toolPosition)) {
            return true;
        }
        class_2248 class_22482 = targetState.method_26204();
        return class_22482 instanceof class_2256 && (fertilizable = (class_2256)class_22482).method_9651((class_4538)this.field_11863, targetPosition, targetState);
    }

    private boolean canFertilizeFarmland(class_2338 toolPosition) {
        class_2338 targetPosition = toolPosition.method_10087(2);
        class_2680 targetState = Objects.requireNonNull(this.field_11863).method_8320(targetPosition);
        if (targetState.method_26204() instanceof class_2344) {
            Integer moistureStatus = (Integer)targetState.method_11654((class_2769)class_2741.field_12510);
            return moistureStatus != 7;
        }
        return false;
    }

    @Override
    public void finishBlockWork(class_2338 processed) {
        class_1799 inventoryStack = this.inventory.method_5438(0);
        boolean fertilizerInInventory = !inventoryStack.method_7960() && inventoryStack.method_31573(TagContent.CONVENTIONAL_FERTILIZER);
        boolean mineralSlurried = this.fluidStorage.getFluid().equals(FluidContent.STILL_MINERAL_SLURRY.get());
        int fertilizerStrength = fertilizerInInventory ? 2 : 1;
        fertilizerStrength *= mineralSlurried ? 2 : 1;
        boolean fertilized = false;
        class_2338 targetPosition = processed.method_10074();
        class_2680 targetState = Objects.requireNonNull(this.field_11863).method_8320(targetPosition);
        if (!this.hasWorkAvailable(processed)) {
            return;
        }
        class_2248 class_22482 = targetState.method_26204();
        if (class_22482 instanceof class_2302) {
            class_2302 cropBlock = (class_2302)class_22482;
            int newAge = cropBlock.method_9829(targetState) + fertilizerStrength;
            newAge = Math.min(newAge, cropBlock.method_9827());
            this.field_11863.method_8652(targetPosition, cropBlock.method_9828(newAge), 2);
            fertilized = true;
        } else {
            class_22482 = targetState.method_26204();
            if (class_22482 instanceof class_2256) {
                class_2256 fertilizable = (class_2256)class_22482;
                fertilizable.method_9652((class_3218)this.field_11863, this.field_11863.field_9229, targetPosition, targetState);
                if (fertilizerInInventory) {
                    fertilizable.method_9652((class_3218)this.field_11863, this.field_11863.field_9229, targetPosition, targetState);
                    fertilized = true;
                }
            }
        }
        class_2338 farmlandPosition = processed.method_10087(2);
        class_2680 farmlandState = this.field_11863.method_8320(farmlandPosition);
        if (farmlandState.method_26204() instanceof class_2344 && (Integer)farmlandState.method_11654((class_2769)class_2741.field_12510) != 7) {
            this.field_11863.method_8501(farmlandPosition, (class_2680)farmlandState.method_11657((class_2769)class_2741.field_12510, (Comparable)Integer.valueOf(7)));
        }
        if (fertilized) {
            if (fertilizerInInventory) {
                inventoryStack.method_7934(1);
                this.inventory.method_5447(0, inventoryStack);
            }
            super.finishBlockWork(processed);
            ParticleContent.FERTILIZER_EFFECT.spawn(this.field_11863, class_243.method_24954((class_2382)targetPosition), (Object)(fertilizerStrength * 3 + 2));
            this.field_11863.method_8396(null, targetPosition, class_3417.field_33433, class_3419.field_15245, 1.0f, 1.0f);
        }
    }

    @Override
    public class_2680 getMachineHead() {
        return BlockContent.BLOCK_FERTILIZER_HEAD.method_9564();
    }

    @Override
    public List<class_2382> getAddonSlots() {
        return List.of(new class_2382(0, -1, 0));
    }

    @Override
    protected void doProgress(boolean moving) {
        super.doProgress(moving);
        if (!moving && this.hasWorkAvailable(this.getCurrentTarget())) {
            this.fluidStorage.setAmount(this.fluidStorage.getAmount() - this.getWaterUsagePerTick());
            ParticleContent.WATERING_EFFECT.spawn(this.field_11863, class_243.method_24954((class_2382)this.getCurrentTarget().method_10074()), (Object)2);
        }
    }

    @Override
    public float getMoveTime() {
        return (float)Oritech.CONFIG.fertilizerConfig.moveDuration() * this.getSpeedMultiplier();
    }

    @Override
    public float getWorkTime() {
        return (float)Oritech.CONFIG.fertilizerConfig.workDuration() * this.getSpeedMultiplier();
    }

    @Override
    public int getMoveEnergyUsage() {
        return Oritech.CONFIG.fertilizerConfig.moveEnergyUsage();
    }

    @Override
    public int getOperationEnergyUsage() {
        return Oritech.CONFIG.fertilizerConfig.workEnergyUsage();
    }

    @Override
    public class_3917<?> getScreenHandlerType() {
        return ModScreens.DESTROYER_SCREEN;
    }

    @Override
    public FluidApi.FluidStorage getFluidStorage(class_2350 direction) {
        return this.fluidStorage;
    }
}

