/*
 * Decompiled with CFR 0.152.
 */
package rearth.oritech.block.entity.augmenter.api;

import com.mojang.serialization.Codec;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Stream;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2374;
import net.minecraft.class_238;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3730;
import net.minecraft.class_4174;
import net.minecraft.class_4208;
import net.minecraft.class_5321;
import net.minecraft.class_9139;
import net.minecraft.class_9334;
import rearth.oritech.Oritech;
import rearth.oritech.api.attachment.Attachment;
import rearth.oritech.api.attachment.AttachmentApi;
import rearth.oritech.block.entity.augmenter.api.Augment;
import rearth.oritech.client.other.OreFinderRenderer;
import rearth.oritech.init.EntitiesContent;
import rearth.oritech.init.TagContent;
import rearth.oritech.util.PortalEntity;

public class CustomAugmentsCollection {
    public static final Map<class_2960, Augment> CUSTOM_AUGMENTS = new HashMap<class_2960, Augment>();
    public static final Attachment<class_4208> PORTAL_TARGET_TYPE = new Attachment<class_4208>(){

        @Override
        public class_2960 identifier() {
            return Oritech.id("portal_target");
        }

        @Override
        public Codec<class_4208> persistenceCodec() {
            return class_4208.field_25066;
        }

        @Override
        public class_9139<ByteBuf, class_4208> networkCodec() {
            return class_4208.field_48451;
        }

        @Override
        public Supplier<class_4208> initializer() {
            return () -> class_4208.method_19443((class_5321)class_1937.field_25179, (class_2338)class_2338.field_10980);
        }
    };
    public static final Augment flight = new Augment(Oritech.id("augment/flight"), true){

        @Override
        public void activate(class_1657 player) {
            player.method_31549().field_7478 = true;
            player.method_7355();
        }

        @Override
        public void deactivate(class_1657 player) {
            player.method_31549().field_7478 = false;
            player.method_31549().field_7479 = false;
            player.method_7355();
        }

        @Override
        public void refreshServer(class_1657 player) {
            player.method_31549().field_7478 = true;
            player.method_7355();
        }

        @Override
        public int refreshInterval() {
            return 80;
        }
    };
    public static final Augment feeder = new Augment(Oritech.id("augment/autofeeder"), true){

        @Override
        public void activate(class_1657 player) {
        }

        @Override
        public void deactivate(class_1657 player) {
        }

        @Override
        public void refreshServer(class_1657 player) {
            int playerHungerCapacity = 20 - player.method_7344().method_7586();
            if (playerHungerCapacity < 2) {
                return;
            }
            Stream<class_1799> foodStackStream = player.method_31548().field_7547.stream().filter(item -> item.method_57826(class_9334.field_50075) && !item.method_31573(TagContent.FEEDER_BLACKLIST));
            Optional<class_1799> selectedFood = foodStackStream.reduce((a, b) -> Math.abs(((class_4174)a.method_57824(class_9334.field_50075)).comp_2491() - playerHungerCapacity) <= Math.abs(((class_4174)b.method_57824(class_9334.field_50075)).comp_2491() - playerHungerCapacity) ? a : b);
            selectedFood.ifPresent(food -> food.method_7910(player.method_37908(), (class_1309)player));
        }

        @Override
        public int refreshInterval() {
            return 10;
        }
    };
    public static final Augment magnet = new Augment(Oritech.id("augment/magnet"), true){

        @Override
        public void activate(class_1657 player) {
        }

        @Override
        public void deactivate(class_1657 player) {
        }

        @Override
        public void refreshServer(class_1657 player) {
            class_1937 world = player.method_37908();
            class_243 target = player.method_33571();
            int range = 8;
            double speed = 0.3;
            class_238 box = new class_238(target.field_1352 - (double)range, target.field_1351 - (double)range, target.field_1350 - (double)range, target.field_1352 + (double)range, target.field_1351 + (double)range, target.field_1350 + (double)range);
            List items = world.method_8390(class_1542.class, box, itemEntity -> !itemEntity.method_6977());
            for (class_1542 item : items) {
                class_243 direction = target.method_1020(item.method_19538()).method_1029().method_1021(speed);
                item.method_60491(direction);
            }
        }

        @Override
        public int refreshInterval() {
            return 4;
        }
    };
    public static final Augment oreFinder = new Augment(Oritech.id("augment/orefinder"), true){

        @Override
        public void activate(class_1657 player) {
        }

        @Override
        public void deactivate(class_1657 player) {
        }

        @Override
        public void refreshServer(class_1657 player) {
        }

        @Override
        public void refreshClient(class_1657 player) {
            class_1937 world = player.method_37908();
            class_2338 target = class_2338.method_49638((class_2374)player.method_33571());
            int range = 16;
            ArrayList<class_2338> highlightPositions = new ArrayList<class_2338>();
            class_2338.method_10094((int)(target.method_10263() - range), (int)(target.method_10264() - range), (int)(target.method_10260() - range), (int)(target.method_10263() + range), (int)(target.method_10264() + range), (int)(target.method_10260() + range)).forEach(pos -> {
                class_2680 state = world.method_8320(pos);
                boolean isOre = state.method_26164(TagContent.CONVENTIONAL_ORES);
                if (isOre) {
                    highlightPositions.add(pos.method_10062());
                }
            });
            if (!highlightPositions.isEmpty()) {
                OreFinderRenderer.receivedAt = player.method_37908().method_8510();
                OreFinderRenderer.renderedBlocks = highlightPositions;
            }
        }

        @Override
        public int refreshInterval() {
            return 6;
        }
    };
    public static final Augment portal = new Augment(Oritech.id("augment/portal"), true){

        @Override
        public void toggle(class_1657 player) {
            class_1937 world = player.method_37908();
            if (world.field_9236) {
                return;
            }
            class_239 hitResult = player.method_5745(6.0, 0.0f, false);
            class_243 spawnPos = hitResult.method_17784();
            class_243 spawnToPlayer = spawnPos.method_1020(player.method_19538()).method_1029().method_1021(0.3);
            spawnPos = spawnPos.method_1020(spawnToPlayer);
            class_4208 targetPos = AttachmentApi.getAttachmentValue((class_1309)player, PORTAL_TARGET_TYPE);
            if (targetPos == null) {
                return;
            }
            PortalEntity portalEntity = (PortalEntity)EntitiesContent.PORTAL_ENTITY.method_5888((class_3218)world, spawner -> {}, class_2338.method_49638((class_2374)spawnPos), class_3730.field_16467, false, false);
            if (portalEntity != null) {
                portalEntity.method_33574(spawnPos);
                portalEntity.method_36456(-player.method_36454() + 90.0f);
                world.method_8649((class_1297)portalEntity);
                portalEntity.target = targetPos;
                world.method_8396(null, class_2338.method_49638((class_2374)spawnPos), (class_3414)class_3417.field_14564.comp_349(), class_3419.field_15245, 2.0f, 1.2f);
            }
        }

        @Override
        public void activate(class_1657 player) {
            AttachmentApi.setAttachment((class_1309)player, PORTAL_TARGET_TYPE, class_4208.method_19443((class_5321)player.method_37908().method_27983(), (class_2338)player.method_24515()));
        }

        @Override
        public void deactivate(class_1657 player) {
            AttachmentApi.removeAttachment((class_1309)player, PORTAL_TARGET_TYPE);
        }

        @Override
        public void refreshServer(class_1657 player) {
        }

        @Override
        public int refreshInterval() {
            return Integer.MAX_VALUE;
        }
    };

    public static Augment getById(class_2960 id) {
        return CUSTOM_AUGMENTS.get(id);
    }

    static {
        CUSTOM_AUGMENTS.put(CustomAugmentsCollection.flight.id, flight);
        CUSTOM_AUGMENTS.put(CustomAugmentsCollection.feeder.id, feeder);
        CUSTOM_AUGMENTS.put(CustomAugmentsCollection.magnet.id, magnet);
        CUSTOM_AUGMENTS.put(CustomAugmentsCollection.oreFinder.id, oreFinder);
        CUSTOM_AUGMENTS.put(CustomAugmentsCollection.portal.id, portal);
    }
}

