package rearth.oritech.util;

import net.minecraft.class_2487;

public interface ColorableMachine {
    
    enum ColorVariant {
        ORANGE,
        DIAMOND,
        CAMO,
        FLUXITE,
        WHITE,
        INDUSTRIAL,
        NETHERITE,
        REDSTONE,
        SCULK
    }
    
    default boolean supportRecoloring() {
        return true;
    }
    
    ColorVariant getCurrentColor();
    
    void assignColor(ColorVariant color);
    
    default ColorVariant getDefaultColor() {
        return ColorVariant.ORANGE;
    }
    
    default void addColorToNbt(class_2487 tag) {
        tag.method_10575("color", (short) this.getCurrentColor().ordinal());
    }
    
    default void loadColorFromNbt(class_2487 tag) {
        if (tag.method_10545("color")) {
            var color = tag.method_10568("color");
            this.assignColor(ColorVariant.values()[color]);
        }
    }
}