package rearth.oritech.mixin.client;

import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_3532;
import net.minecraft.class_572;
import net.minecraft.class_630;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import rearth.oritech.client.cablesurfer.ClientZiplineHandler;

@Mixin(class_572.class)
public class HumanoidModelMixin<T extends class_1309> {
    
    @Shadow public class_630 rightArm;
    @Shadow public class_630 leftArm;
    @Shadow public class_630 rightLeg;
    @Shadow public class_630 leftLeg;
    @Shadow public class_630 head;
    @Shadow public class_630 body;
    
    @Inject(method = "setupAnim(Lnet/minecraft/world/entity/LivingEntity;FFFFF)V", at = @At("TAIL"))
    public void oritech$ziplineAnim(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch, CallbackInfo ci) {
        
        if (entity instanceof class_1657 player) {
            
            if (ClientZiplineHandler.isZiplining(player)) {
                
                // Raise arms overhead
                // -3.14 (PI) is straight up. We do -2.9 to angle slightly forward
                float armX = -2.9F;
                this.rightArm.field_3654 = armX;
                this.leftArm.field_3654 = armX;
                
                // Bring arms inward to touch hands
                // Right arm rotates CCW (-), Left arm CW (+)
                this.rightArm.field_3674 = 0.1F;
                this.leftArm.field_3674 = 0.05F;
                
                // Rotate arms inward on Y axis to align the Wrench handle horizontally
                this.rightArm.field_3675 = -0.3F + 2.1f;
                this.leftArm.field_3675 = 0.3F;
                
                // move slightly up because the default arms are too short
                this.rightArm.field_3656 -= 3.0F;
                this.leftArm.field_3656 -= 3.0F;
                
                this.rightArm.field_37939 = 1.15F;
                this.leftArm.field_37939 = 1.15F;
                
                
                // Apply a slight swing based on momentum/time
                // We use ageInTicks to create a gentle oscillation
                float legSwing = class_3532.method_15362(ageInTicks * 0.2F) * 0.25F;
                
                // Bend knees slightly back (positive X)
                float kneeBend = 0.4F;
                
                this.rightLeg.field_3654 = kneeBend + legSwing;
                this.leftLeg.field_3654 = kneeBend - legSwing;
                
                this.rightLeg.field_3675 = 0.0F;
                this.leftLeg.field_3675 = 0.0F;
                this.rightLeg.field_3674 = 0.0F;
                this.leftLeg.field_3674 = 0.0F;
                
                // Tilt body slightly forward to look dynamic
                this.body.field_3654 = 0.1F;
            }
        }
    }
}