package rearth.oritech.item.tools.armor;

import rearth.oritech.Oritech;
import rearth.oritech.api.energy.EnergyApi;
import rearth.oritech.api.energy.containers.SimpleEnergyItemStorage;
import rearth.oritech.item.tools.util.OritechEnergyItem;
import rearth.oritech.util.StackContext;
import rearth.oritech.util.TooltipHelper;

import java.util.List;
import net.minecraft.class_124;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1657;
import net.minecraft.class_1741;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_6880;

import static rearth.oritech.item.tools.harvesting.DrillItem.BAR_STEP_COUNT;


public class BackstorageExoArmorItem extends ExoArmorItem implements OritechEnergyItem {
    
    public BackstorageExoArmorItem(class_6880<class_1741> material, class_8051 type, class_1792.class_1793 settings) {
        super(material, type, settings);
    }
    
    @Override
    public void method_7888(class_1799 stack, class_1937 world, class_1297 entity, int slot, boolean selected) {
        if (world.field_9236) return;
        
        var tickPeriod = 10;
        if (world.method_8510() % tickPeriod != 0) return;
        
        var isPlayer = entity instanceof class_1657;
        var isEquipped = ((class_1657) entity).method_6118(class_1304.field_6174).equals(stack);
        
        if (isPlayer && isEquipped) {
            distributePower((class_1657) entity, stack, slot);
        }
    }
    
    private void distributePower(class_1657 player, class_1799 pack, int slot) {
        
        var packStorage = new SimpleEnergyItemStorage(getEnergyMaxInput(pack), getEnergyMaxOutput(pack), getEnergyCapacity(pack), pack);
        if (packStorage.getAmount() < 10) return;

        for (int i = 0; i < player.method_31548().method_5439(); i++) {
            var stack = player.method_31548().method_5438(i);
            if (stack.method_7960() || stack == pack || slot == i) continue;
            
            final int finalI = i;
            var stackRef = new StackContext(stack, updated -> player.method_31548().method_5447(finalI, updated));
            var stackStorage = EnergyApi.ITEM.find(stackRef);
            if (stackStorage == null || stackStorage.getAmount() >= stackStorage.getCapacity()) continue;
            
            EnergyApi.transfer(packStorage, stackStorage, Long.MAX_VALUE, false);
            
            // player.getInventory().setStack(i, stackContext.getStack());
        }
    }
    
    @Override
    public long getEnergyCapacity(class_1799 stack) {
        return Oritech.CONFIG.exoChestplate.energyCapacity();
    }
    
    @Override
    public long getEnergyMaxInput(class_1799 stack) {
        return Oritech.CONFIG.exoChestplate.chargeSpeed();
    }
    
    @Override
    public long getEnergyMaxOutput(class_1799 stack) {
        return Oritech.CONFIG.exoChestplate.energyUsage();
    }
    
    @Override
    public boolean method_31567(class_1799 stack) {
        return true;
    }
    
    @Override
    public int method_31571(class_1799 stack) {
        return 0xff7007;
    }
    
    public int method_31569(class_1799 stack) {
        return Math.round((getStoredEnergy(stack) * 100f / this.getEnergyCapacity(stack)) * BAR_STEP_COUNT) / 100;
    }
    
    @Override
    public void method_7851(class_1799 stack, class_9635 context, List<class_2561> tooltip, class_1836 type) {
        super.method_7851(stack, context, tooltip, type);
        var text = class_2561.method_43469("tooltip.oritech.energy_indicator", TooltipHelper.getEnergyText(this.getStoredEnergy(stack)), TooltipHelper.getEnergyText(this.getEnergyCapacity(stack)));
        tooltip.add(text.method_27692(class_124.field_1065));
    }
}
