package rearth.oritech.item.tools;

import org.jetbrains.annotations.NotNull;
import rearth.oritech.client.cablesurfer.ClientCableFinder;
import rearth.oritech.client.cablesurfer.ClientZiplineHandler;
import rearth.oritech.init.BlockContent;
import rearth.oritech.init.SoundContent;

import java.util.List;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1271;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_239;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_3222;
import net.minecraft.class_3419;
import net.minecraft.class_3959;
import net.minecraft.class_9424;

public class Wrench extends class_1792 {
    
    public static int ACTION_COOLDOWN = 8;
    
    public Wrench(class_1793 settings) {
        super(settings);
    }
    
    public static class_9424 createToolComponent() {
        return new class_9424(List.of(
          class_9424.class_9425.method_58431(List.of(
            BlockContent.ENERGY_PIPE,
            BlockContent.SUPERCONDUCTOR,
            BlockContent.FLUID_PIPE,
            BlockContent.ITEM_PIPE,
            BlockContent.TRANSPARENT_ITEM_PIPE,
            BlockContent.ENERGY_PIPE_CONNECTION,
            BlockContent.SUPERCONDUCTOR_CONNECTION,
            BlockContent.FLUID_PIPE_CONNECTION,
            BlockContent.ITEM_PIPE_CONNECTION,
            BlockContent.TRANSPARENT_ITEM_PIPE_CONNECTION,
            BlockContent.ENERGY_PIPE_DUCT_BLOCK,
            BlockContent.SUPERCONDUCTOR_DUCT_BLOCK,
            BlockContent.FLUID_PIPE_DUCT_BLOCK,
            BlockContent.ITEM_PIPE_DUCT_BLOCK,
            BlockContent.FRAMED_ENERGY_PIPE,
            BlockContent.FRAMED_SUPERCONDUCTOR,
            BlockContent.FRAMED_FLUID_PIPE,
            BlockContent.FRAMED_ITEM_PIPE,
            BlockContent.FRAMED_ENERGY_PIPE_CONNECTION,
            BlockContent.FRAMED_SUPERCONDUCTOR_CONNECTION,
            BlockContent.FRAMED_FLUID_PIPE_CONNECTION,
            BlockContent.FRAMED_ITEM_PIPE_CONNECTION,
            BlockContent.MACHINE_FRAME_BLOCK
          ), 25f)
        ), 1.f, 1);
    }
    
    @Override
    public @NotNull class_1271<class_1799> method_7836(class_1937 world, class_1657 user, class_1268 hand) {
        
        var stack = user.method_5998(hand);
        
        if (world.method_8608()) {
            var hit = ClientCableFinder.findLookedAtCable(user, 6f);
            if (hit != null) {
                ClientZiplineHandler.start(hit.selectedStart(), hit.selectedEnd(), hit.parallelStart(), hit.parallelEnd(), user.method_6029() * 3);
                return class_1271.method_22427(stack);
            }
        }
        
        return useWrench(stack, user, hand) ? class_1271.method_22427(stack) : class_1271.method_22431(stack);
    }
    
    /**
     * Attempts to use the wrench on a block
     *
     * @param item   The wrench item
     * @param player The player using the wrench
     */
    protected boolean useWrench(class_1799 item, class_1657 player, class_1268 hand) {
        if (player.method_7357().method_7904(this)) return false;
        player.method_7357().method_7906(this, ACTION_COOLDOWN);
        
        if (!(player instanceof class_3222)) return false;
        
        var world = player.method_37908();
        var result = method_7872(world, player, class_3959.class_242.field_1348);
        if (result.method_17783() != class_239.class_240.field_1332) return false;
        
        var blockPos = result.method_17777();
        var blockState = world.method_8320(blockPos);
        if (blockState.method_26204() instanceof Wrenchable wrenchable) {
            // Wrench used on a wrenchable block
            var resultAction = wrenchable.onWrenchUse(blockState, world, blockPos, player, hand);
            if (resultAction == class_1269.field_5812) {
                onUsed(item, player, hand);
                return true;
            }
        } else {
            // Wrench used on block
            var direction = result.method_17780();
            var neighborPos = blockPos.method_10093(direction);
            var neighborState = world.method_8320(neighborPos);
            
            // If the neighbor block is wrenchable, call the onWrenchUseNeighbor method
            if (neighborState.method_26204() instanceof Wrenchable wrenchable) {
                var resultAction = wrenchable.onWrenchUseNeighbor(neighborState, blockState, world, neighborPos, blockPos, direction, player, hand);
                if (resultAction == class_1269.field_5812) {
                    onUsed(item, player, hand);
                    return true;
                }
            }
        }
        
        return false;
    }
    
    @Override
    public void method_7851(class_1799 stack, class_9635 context, List<class_2561> tooltipComponents, class_1836 tooltipFlag) {
        super.method_7851(stack, context, tooltipComponents, tooltipFlag);
        tooltipComponents.add(class_2561.method_43471("tooltip.oritech.wrench"));
    }
    
    protected void onUsed(class_1799 item, class_1657 player, class_1268 hand) {
        playSound(player.method_37908(), player);
    }
    
    protected void playSound(class_1937 world, class_1657 player) {
        world.method_8396(null, player.method_24515(), SoundContent.WRENCH_TURN, class_3419.field_15248, 1.0f, 1.0f);
    }
    
    /**
     * Interface for blocks that be interacted with by a wrench
     */
    public interface Wrenchable {
        /**
         * Called when a wrench is used on the block
         *
         * @param state  the block state
         * @param world  the world
         * @param pos    the block position
         * @param player the player using the wrench
         * @return the result of the wrench use
         */
        class_1269 onWrenchUse(class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_1268 hand);
        
        /**
         * Called when a wrench is used on a neighbor block
         *
         * @param state         The wrenchable block state
         * @param neighborState The neighbor block state
         * @param world         The world
         * @param pos           The wrenchable block position
         * @param neighborPos   The neighbor block position
         * @param neighborFace  The face of the neighbor block that was clicked
         * @param player        The player using the wrench
         * @param hand          The hand the wrench is being used in
         * @return the result of the wrench use
         */
        class_1269 onWrenchUseNeighbor(class_2680 state, class_2680 neighborState, class_1937 world, class_2338 pos, class_2338 neighborPos, class_2350 neighborFace, class_1657 player, class_1268 hand);
    }
}
