package rearth.oritech.init.world.features.uranium;

import com.mojang.serialization.Codec;
import org.joml.Vector2d;
import rearth.oritech.Oritech;
import rearth.oritech.init.BlockContent;
import rearth.oritech.util.Geometry;

import java.util.List;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2680;
import net.minecraft.class_3031;
import net.minecraft.class_3481;
import net.minecraft.class_5281;
import net.minecraft.class_5542;
import net.minecraft.class_5819;
import net.minecraft.class_5821;
import net.minecraft.class_7923;

public class UraniumPatchFeature extends class_3031<UraniumPatchFeatureConfig> {
    public UraniumPatchFeature(Codec<UraniumPatchFeatureConfig> configCodec) {
        super(configCodec);
    }
    
    private static boolean isAirOrWater(class_2680 state) {
        return state.method_26215() || state.method_27852(class_2246.field_10382);
    }
    
    @Override
    public boolean method_13151(class_5821<UraniumPatchFeatureConfig> context) {
        
        var world = context.method_33652();
        var origin = context.method_33655();
        
        if (world.method_8608()) return false;
        
        var testPos = new class_2338(origin.method_10087(3));
        if (isAirOrWater(world.method_8320(testPos)))
            placeStructure(testPos, context);
        
        return false;
    }
    
    private void placeStructure(class_2338 pos, class_5821<UraniumPatchFeatureConfig> context) {
        
        var random = context.method_33654();
        var config = context.method_33656();
        var state = class_7923.field_41175.method_10223(config.blockId()).method_9564();
        var crystalBlock = class_7923.field_41175.method_10223(config.crystalId());
        var world = context.method_33652();
        
        var range = config.number();
        var closestWall = pos;
        
        // find closest wall
        for (var candidate : class_2338.method_25996(pos, range, range, range)) {
            var candidateState = world.method_8320(candidate);
            if (isAirOrWater(candidateState)) continue;
            closestWall = candidate;
            break;
        }
        
        if (closestWall.equals(pos)) return;
        
        var closestWallDir = closestWall.method_10059(pos);
        var forward = getBiggestDirection(closestWallDir);
        var facing = class_2350.method_50026(forward.method_10263(), forward.method_10264(), forward.method_10260());
        
        if (facing == null) return;
        
        var right = Geometry.getRight(facing);
        var up = Geometry.getUp(facing);
        
        var veinCount = 3;
        for (int i = 0; i < veinCount; i++) {
            var randomDir = new Vector2d(random.method_43057() * 2 - 1, random.method_43057() * 2 - 1).normalize();
            var veinLength = random.method_39332(5, 9);
            
            // move along vein
            for (int j = 0; j < veinLength; j++) {
                var test = pos.method_10081(right.method_35862((int) (randomDir.x * j))).method_10081(up.method_35862((int) (randomDir.y * j)));
                var test2 = pos.method_10081(right.method_35862((int) (randomDir.x * j + 0.5))).method_10081(up.method_35862((int) (randomDir.y * j + 0.5)));
                
                // project onto first non-air block in forward direction
                for (int k = 0; k < 5; k++) {
                    var projected = test.method_10081(forward.method_35862(k));
                    var projected2 = test2.method_10081(forward.method_35862(k));
                    var testState = world.method_8320(projected);
                    var testState2 = world.method_8320(projected2);
                    if (isValidReplacementBloc(testState)) {
                        createCrystals(projected, world, random, crystalBlock);
                        world.method_30092(projected, state, class_2248.field_31028, 0);
                        break;
                    }
                    if (isValidReplacementBloc(testState2)) {
                        world.method_30092(projected2, state, class_2248.field_31028, 0);
                        break;
                    }
                    
                }
                
                randomDir = randomDir.add(random.method_43057() * 0.2, random.method_43057() * 0.2).normalize();
            }
            
        }
    }
    
    private boolean isValidReplacementBloc(class_2680 state) {
        return state.method_26164(class_3481.field_28993) || state.method_26164(class_3481.field_28992);
    }
    
    private void createCrystals(class_2338 pos, class_5281 world, class_5819 random, class_2248 crystal) {
        for (var neighborPos : getNeighbors(pos)) {
            var neighborState = world.method_8320(neighborPos);
            
            var isValid = neighborState.method_26215() || neighborState.method_27852(class_2246.field_10382);
            if (!isValid || random.method_43057() < 0.7) continue;
            
            var waterLogged = neighborState.method_27852(class_2246.field_10382);
            var facing = Geometry.fromVector(neighborPos.method_10059(pos));
            if (facing == null) continue;
            var targetState = crystal.method_9564()
                                .method_11657(class_5542.field_27086, waterLogged)
                                .method_11657(class_5542.field_27087, facing);
            world.method_30092(neighborPos, targetState, class_2248.field_31028, 0);
        }
    }
    
    private List<class_2338> getNeighbors(class_2338 pos) {
        return List.of(pos.method_10074(), pos.method_10084(), pos.method_10095(), pos.method_10078(), pos.method_10072(), pos.method_10067());
    }
    
    private class_2382 getBiggestDirection(class_2382 source) {
        var x = Math.abs(source.method_10263());
        var y = Math.abs(source.method_10264());
        var z = Math.abs(source.method_10260());
        
        if (x > y && x > z) {
            return new class_2382(Math.clamp(source.method_10263(), -1, 1), 0, 0);
        } else if (y > x && y > z) {
            return new class_2382(0, Math.clamp(source.method_10264(), -1, 1), 0);
        } else {
            return new class_2382(0, 0, Math.clamp(source.method_10260(), -1, 1));
        }
        
    }
}
