package rearth.oritech.client.cablesurfer;

import rearth.oritech.block.entity.interaction.PowerPoleEntity;

import java.util.ArrayList;
import net.minecraft.class_1657;
import net.minecraft.class_2338;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_310;
import net.minecraft.class_3532;

// yeah the raycast code is mostly from gemini
public class ClientCableFinder {
    
    private static final boolean DEBUG_DRAW = false;
    private static final int POLE_SEARCH_RADIUS = 196;
    
    /**
     * @param poleA Origin Pole
     * @param poleB Target Pole
     * @param selectedStart The specific Vec3 start point of the cable hit (Left or Right cable)
     * @param selectedEnd The specific Vec3 end point of the cable hit
     */
    public record CableHit(class_2338 poleA, class_2338 poleB, class_243 selectedStart, class_243 selectedEnd, class_243 parallelStart, class_243 parallelEnd) {}
    
    public static CableHit findLookedAtCable(class_1657 player, float reachDistance) {
        var level = class_310.method_1551().field_1687;
        if (level == null) return null;
        
        var eyePos = player.method_5836(1.0f);
        var lookDir = player.method_5828(1.0f).method_1029();
        
        var minPos = class_2338.method_49638(eyePos.method_1031(-POLE_SEARCH_RADIUS, -POLE_SEARCH_RADIUS, -POLE_SEARCH_RADIUS));
        var maxPos = class_2338.method_49638(eyePos.method_1031(POLE_SEARCH_RADIUS, POLE_SEARCH_RADIUS, POLE_SEARCH_RADIUS));
        var nearbyPoles = new ArrayList<PowerPoleEntity>();
        
        for (var cx = (minPos.method_10263() >> 4); cx <= (maxPos.method_10263() >> 4); cx++) {
            for (var cz = (minPos.method_10260() >> 4); cz <= (maxPos.method_10260() >> 4); cz++) {
                if (level.method_8393(cx, cz)) {
                    for (var be : level.method_8497(cx, cz).method_12214().values()) {
                        if (be instanceof PowerPoleEntity pole &&
                              player.method_5707(class_243.method_24953(pole.method_11016())) < POLE_SEARCH_RADIUS * POLE_SEARCH_RADIUS) {
                            nearbyPoles.add(pole);
                        }
                    }
                }
            }
        }
        
        var bestDistSq = Double.MAX_VALUE;
        CableHit bestHit = null;
        
        // Visual variables for debug
        class_243 debugHitPos = null;
        
        for (var startPole : nearbyPoles) {
            var startPos = startPole.method_11016();
            var startCenter = class_243.method_24953(startPos);
            // Replicate Renderer Geometry: Get offset vector
            var startFacing = startPole.getFacingForMultiblock();
            var startSideVec = class_243.method_24954(startFacing.method_10163()); // Assuming Geometry.getForward maps to this
            
            for (var target : startPole.getConnections()) {
                var endPos = target.pos();
                
                var endCenter = class_243.method_24953(endPos);
                var endFacing = target.facing();
                var endSideVec = class_243.method_24954(endFacing.method_10163());
                
                if (!isPlayerNearCableBounds(player, startCenter, endCenter, reachDistance)) {
                    continue;
                }
                
                // crossing logic, needs to match renderer
                var startWorldA = startCenter.method_1019(startSideVec);
                var startWorldB = startCenter.method_1020(startSideVec);
                
                var targetWorldA = endCenter.method_1019(endSideVec);
                var targetWorldB = endCenter.method_1020(endSideVec);
                
                // calculate Cross vs Direct distance
                var distDirect = startWorldA.method_1025(targetWorldA) + startWorldB.method_1025(targetWorldB);
                var distCross = startWorldA.method_1025(targetWorldB) + startWorldB.method_1025(targetWorldA);
                
                // Define the two pairs of cables
                class_243 cable1Start, cable1End;
                class_243 cable2Start, cable2End;
                
                if (distDirect < distCross) {
                    // direct Connection
                    cable1Start = startWorldA; cable1End = targetWorldA;
                    cable2Start = startWorldB; cable2End = targetWorldB;
                } else {
                    // crossed Connection
                    cable1Start = startWorldA; cable1End = targetWorldB;
                    cable2Start = startWorldB; cable2End = targetWorldA;
                }
                
                
                // Check Cable 1
                var result1 = raycastCable(cable1Start, cable1End, eyePos, lookDir, reachDistance, level);
                if (result1 != null && result1.distSq < bestDistSq) {
                    bestDistSq = result1.distSq;
                    bestHit = new CableHit(startPos, endPos, cable1Start, cable1End, cable2Start, cable2End);
                    debugHitPos = result1.hitPos;
                }
                
                // Check Cable 2
                var result2 = raycastCable(cable2Start, cable2End, eyePos, lookDir, reachDistance, level);
                if (result2 != null && result2.distSq < bestDistSq) {
                    bestDistSq = result2.distSq;
                    bestHit = new CableHit(startPos, endPos, cable2Start, cable2End, cable1Start, cable1End);
                    debugHitPos = result2.hitPos;
                }
            }
        }
        
        if (DEBUG_DRAW && debugHitPos != null) {
            level.method_8406(class_2398.field_11211, debugHitPos.field_1352, debugHitPos.field_1351, debugHitPos.field_1350, 0, 0, 0);
        }
        
        return bestHit;
    }
    
    private static boolean isPlayerNearCableBounds(class_1657 player, class_243 start, class_243 end, float reach) {
        double minX = Math.min(start.field_1352, end.field_1352) - reach;
        double minY = Math.min(start.field_1351, end.field_1351) - reach - 10.0; // Extra Y buffer for Sag
        double minZ = Math.min(start.field_1350, end.field_1350) - reach;
        
        double maxX = Math.max(start.field_1352, end.field_1352) + reach;
        double maxY = Math.max(start.field_1351, end.field_1351) + reach;
        double maxZ = Math.max(start.field_1350, end.field_1350) + reach;
        
        class_243 p = player.method_19538();
        return p.field_1352 >= minX && p.field_1352 <= maxX &&
                 p.field_1351 >= minY && p.field_1351 <= maxY &&
                 p.field_1350 >= minZ && p.field_1350 <= maxZ;
    }
    
    private record RayResult(double distSq, class_243 hitPos) {}
    
    private static RayResult raycastCable(class_243 p1, class_243 p2, class_243 eyePos, class_243 lookDir, float reach, net.minecraft.class_1937 level) {
        double cableLength = p1.method_1022(p2);
        int segments = class_3532.method_15340((int)(cableLength), 8, 128);
        
        double hitRadius = 1.5;
        double hitRadiusSq = hitRadius * hitRadius;
        double reachSq = reach * reach;
        
        var prevPoint = CableMath.getAt(p1, p2, 0);
        
        RayResult bestLocal = null;
        double bestLocalDist = Double.MAX_VALUE;
        
        for (int i = 1; i <= segments; i++) {
            float t = (float) i / segments;
            var nextPoint = CableMath.getAt(p1, p2, t);
            
            // Debug: Draw the segments being calculated
            if (DEBUG_DRAW) {
                // Draw a flame every few ticks or segments to reduce lag,
                // or just draw points.
                    level.method_8406(class_2398.field_11240, nextPoint.field_1352, nextPoint.field_1351, nextPoint.field_1350, 0, 0, 0);
            }
            
            // Math: Closest point on this segment to the view ray
            var closestOnSeg = getClosestPointOnSegment(prevPoint, nextPoint, eyePos, lookDir);
            
            // 1. Line-Line distance check (Ray vs Segment)
            if (distSqPointToRay(closestOnSeg, eyePos, lookDir) < hitRadiusSq) {
                
                // 2. Reach check
                double distToPlayer = eyePos.method_1025(closestOnSeg);
                if (distToPlayer < reachSq) {
                    if (distToPlayer < bestLocalDist) {
                        bestLocalDist = distToPlayer;
                        bestLocal = new RayResult(distToPlayer, closestOnSeg);
                    }
                }
            }
            prevPoint = nextPoint;
        }
        return bestLocal;
    }
    
    private static class_243 getClosestPointOnSegment(class_243 segA, class_243 segB, class_243 rayOrigin, class_243 rayDir) {
        var u = rayDir;
        var v = segB.method_1020(segA);
        var w = rayOrigin.method_1020(segA);
        var a = u.method_1026(u);
        var b = u.method_1026(v);
        var c = v.method_1026(v);
        var d = u.method_1026(w);
        var e = v.method_1026(w);
        var D = a * c - b * b;
        double tc;
        if (D < 1e-8) tc = (b > c ? d / b : e / c);
        else tc = (a * e - b * d) / D;
        return segA.method_1019(v.method_1021(class_3532.method_15350(tc, 0.0, 1.0)));
    }
    
    private static double distSqPointToRay(class_243 point, class_243 rayOrigin, class_243 rayDir) {
        var w = point.method_1020(rayOrigin);
        var proj = w.method_1026(rayDir);
        if (proj < 0) proj = 0;
        return point.method_1025(rayOrigin.method_1019(rayDir.method_1021(proj)));
    }
}