package rearth.oritech.block.entity.generators;

import rearth.oritech.Oritech;
import rearth.oritech.block.base.entity.FluidMultiblockGeneratorBlockEntity;
import rearth.oritech.client.init.ModScreens;
import rearth.oritech.init.BlockEntitiesContent;
import rearth.oritech.init.recipes.OritechRecipeType;
import rearth.oritech.init.recipes.RecipeContent;
import rearth.oritech.util.Geometry;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2680;
import net.minecraft.class_3545;
import net.minecraft.class_3917;

public class FuelGeneratorEntity extends FluidMultiblockGeneratorBlockEntity {
    public FuelGeneratorEntity(class_2338 pos, class_2680 state) {
        super(BlockEntitiesContent.FUEL_GENERATOR_ENTITY, pos, state, Oritech.CONFIG.generators.fuelGeneratorData.energyPerTick());
    }
    
    @Override
    protected Set<class_3545<class_2338, class_2350>> getOutputTargets(class_2338 pos, class_1937 world) {
        
        // because facing blocks make rotations and relative offsets a nightmare...
        var posA = new class_2382(1, 0, -1);
        var corePosA = new class_2382(0, 0, -1);
        var posB = new class_2382(1, 0, 1);
        var facing = getFacingForAddon();
        var worldPosA = (class_2338) Geometry.offsetToWorldPosition(facing, posA, pos);
        var coreWorldPosA = (class_2338) Geometry.offsetToWorldPosition(facing, corePosA, pos);
        var worldPosB = (class_2338) Geometry.offsetToWorldPosition(facing, posB, pos);
        var offset = worldPosA.method_10059(coreWorldPosA);
        
        var direction = class_2350.method_50026(offset.method_10263(), offset.method_10264(), offset.method_10260());
        
        var res = new HashSet<class_3545<class_2338, class_2350>>();
        
        res.add(new class_3545<>(worldPosA, direction));
        res.add(new class_3545<>(worldPosB, direction));
        
        return res;
        
    }
    
    @Override
    protected OritechRecipeType getOwnRecipeType() {
        return RecipeContent.FUEL_GENERATOR;
    }
    
    @Override
    public class_3917<?> getScreenHandlerType() {
        return ModScreens.FUEL_GENERATOR_SCREEN;
    }
    
    @Override
    public long getDefaultExtractionRate() {
        return Oritech.CONFIG.generators.fuelGeneratorData.maxEnergyExtraction();
    }
    
    @Override
    public long getDefaultCapacity() {
        return Oritech.CONFIG.generators.fuelGeneratorData.energyCapacity();
    }
    
    @Override
    protected float getAnimationSpeed() {
        return super.getAnimationSpeed() / 3;
    }
    
    @Override
    public List<class_2382> getAddonSlots() {
        
        return List.of(
          new class_2382(1, 0, 0),
          new class_2382(-3, 0, 0)
        );
    }
    
    @Override
    public List<class_2382> getCorePositions() {
        return List.of(
          new class_2382(0, 0, 1),
          new class_2382(0, 0, -1),
          new class_2382(-1, 0, 1),
          new class_2382(-1, 0, 0),
          new class_2382(-1, 0, -1),
          new class_2382(-2, 0, 1),
          new class_2382(-2, 0, 0),
          new class_2382(-2, 0, -1),
          new class_2382(0, 1, 1),
          new class_2382(0, 1, 0),
          new class_2382(0, 1, -1),
          new class_2382(-1, 1, 1),
          new class_2382(-1, 1, 0),
          new class_2382(-1, 1, -1),
          new class_2382(-2, 1, 1),
          new class_2382(-2, 1, 0),
          new class_2382(-2, 1, -1)
        );
    }
}
