package rearth.oritech.block.blocks.reactor;

import net.minecraft.class_1922;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_3726;
import rearth.oritech.init.BlockContent;

public class ReactorRodBlock extends BaseReactorBlock {
    
    private final int rodCount;
    private final int internalPulseCount;
    
    private static final class_265 SOLO_SHAPE = class_2248.method_9541(5, 0, 5, 11, 16, 11);
    private static final class_265 DUO_SHAPE = class_2248.method_9541(2, 0, 2, 14, 16, 14);
    private static final class_265 QUAD_SHAPE = class_2248.method_9541(1, 0, 1, 15, 16, 15);
    
    public ReactorRodBlock(class_2251 settings, int rodCount, int internalPulseCount) {
        super(settings);
        this.rodCount = rodCount;
        this.internalPulseCount = internalPulseCount;
        this.method_9590(method_9564().method_11657(class_2741.field_12548, false));
    }
    
    @Override
    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        super.method_9515(builder);
        builder.method_11667(class_2741.field_12548);
    }
    
    @Override
    protected class_265 method_9530(class_2680 state, class_1922 world, class_2338 pos, class_3726 context) {
        return switch (rodCount) {
            case 1 -> SOLO_SHAPE;
            case 2 -> DUO_SHAPE;
            case 4 -> QUAD_SHAPE;
            default -> SOLO_SHAPE;
        };
    }
    
    public int getRodCount() {
        return rodCount;
    }
    
    public int getInternalPulseCount() {
        return internalPulseCount;
    }
    
    @Override
    public class_2248 requiredStackCeiling() {
        return BlockContent.REACTOR_FUEL_PORT;
    }
}
