package rearth.oritech.block.blocks.reactor;

import dev.architectury.registry.menu.ExtendedMenuProvider;
import dev.architectury.registry.menu.MenuRegistry;
import net.minecraft.class_1269;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2343;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_3222;
import net.minecraft.class_3965;
import org.jetbrains.annotations.Nullable;
import rearth.oritech.block.entity.interaction.TreefellerBlockEntity;
import rearth.oritech.block.entity.reactor.ReactorAbsorberPortEntity;

public class ReactorAbsorberPortBlock extends BaseReactorBlock implements class_2343 {
    public ReactorAbsorberPortBlock(class_2251 settings) {
        super(settings);
    }
    
    @Nullable
    @Override
    public class_2586 method_10123(class_2338 pos, class_2680 state) {
        return new ReactorAbsorberPortEntity(pos, state);
    }
    
    @Override
    public boolean validForWalls() {
        return true;
    }
    
    @Override
    public class_1269 method_55766(class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_3965 hit) {
        
        if (!world.field_9236 && world.method_8321(pos) instanceof ReactorAbsorberPortEntity) {
            var handler = (ExtendedMenuProvider) world.method_8321(pos);
                MenuRegistry.openExtendedMenu((class_3222) player, handler);
        }
        
        return class_1269.field_5812;
    }
    
    @Override
    public class_2680 method_9576(class_1937 world, class_2338 pos, class_2680 state, class_1657 player) {
        
        if (!world.field_9236) {
            var entity = (ReactorAbsorberPortEntity) world.method_8321(pos);
            var stacks = entity.inventory.heldStacks;
            for (var stack : stacks) {
                if (!stack.method_7960()) {
                    var itemEntity = new class_1542(world, pos.method_10263(), pos.method_10264(), pos.method_10260(), stack);
                    world.method_8649(itemEntity);
                }
            }
            
            entity.inventory.heldStacks.clear();
            entity.inventory.method_5431();
        }
        
        return super.method_9576(world, pos, state, player);
    }
}
