package rearth.oritech.block.behavior;

import net.minecraft.class_1282;
import net.minecraft.class_1299;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1429;
import net.minecraft.class_1548;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_7924;
import net.minecraft.class_8111;
import rearth.oritech.api.energy.EnergyApi;
import rearth.oritech.block.blocks.interaction.LaserArmBlock;
import rearth.oritech.block.entity.interaction.LaserArmBlockEntity;
import rearth.oritech.util.StackContext;

public class LaserArmEntityBehavior {
    static private LaserArmEntityBehavior transferPowerBehavior;
    static private LaserArmEntityBehavior chargeEntityBehavior;
    
    // possible improvement - the target designator could be used to set up scoreboard teams,
    // and the laser could respect the attackable TargetPredicate to avoid attacking "friendly" mobs or to attack players
    // instead of trying to charge their energy storage chestplates
    
    public boolean fireAtEntity(class_1937 world, LaserArmBlockEntity laserEntity, class_1309 entity) {
        // Don't kill baby animals if the crop filter addon is applied
        if (laserEntity.hasCropFilterAddon && entity instanceof class_1429 && entity.method_6109()) {
            return false;
        }
        
        if (world.method_8510() % 10 != 0) return true; // entities can only be damaged twice per second?
        
        entity.method_5643(
          new class_1282(world.method_30349().method_30530(class_7924.field_42534).method_40290(class_8111.field_42336), laserEntity.getLaserPlayerEntity()),
          laserEntity.getDamageTick());
        
        
        return true;
    }
    
    public static void registerDefaults() {
        transferPowerBehavior = new LaserArmEntityBehavior() {
            @Override
            public boolean fireAtEntity(class_1937 world, LaserArmBlockEntity laserEntity, class_1309 entity) {
                if (!(entity instanceof class_1657 player))
                    return false;
                
                var stackRef = new StackContext(player.method_6118(class_1304.field_6174), updated -> player.method_31548().field_7548.set(class_1304.field_6174.method_5927(), updated));
                var candidate = EnergyApi.ITEM.find(stackRef);
                if (candidate != null) {
                    var amount = candidate.insert(laserEntity.energyRequiredToFire(), false);
                    if (amount > 0) candidate.update();
                    return amount > 0;
                }
                
                return false;
            }
        };
        LaserArmBlock.registerEntityBehavior(class_1299.field_6097, transferPowerBehavior);
        
        chargeEntityBehavior = new LaserArmEntityBehavior() {
            @Override
            public boolean fireAtEntity(class_1937 world, LaserArmBlockEntity laserEntity, class_1309 entity) {
                entity.method_5841().method_12778(class_1548.field_7224, true);
                
                // still do the default mob behavior after setting the creeper to charged
                return super.fireAtEntity(world, laserEntity, entity);
            }
        };
        LaserArmBlock.registerEntityBehavior(class_1299.field_6046, chargeEntityBehavior);
    }
}
