/*
 * Decompiled with CFR 0.152.
 */
package rearth.oritech.util;

import java.lang.ref.WeakReference;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import org.jetbrains.annotations.Nullable;

public class ApiLookupCache<T> {
    private WeakReference<class_2586> cachedEntity;
    private WeakReference<T> cachedTarget;
    private class_2680 lastBlockState;
    private final class_2338 targetPos;
    private final class_2350 direction;
    private final class_1937 world;
    private final LookupFunction<T> lookupFunction;

    private ApiLookupCache(class_2586 cachedEntity, T cachedTarget, class_2338 targetPos, class_2350 direction, class_1937 world, LookupFunction<T> lookupFunction) {
        this.cachedEntity = new WeakReference<class_2586>(cachedEntity);
        this.cachedTarget = new WeakReference<T>(cachedTarget);
        this.targetPos = targetPos;
        this.direction = direction;
        this.world = world;
        this.lookupFunction = lookupFunction;
        this.lastBlockState = world.method_8320(targetPos);
    }

    public static <T> ApiLookupCache<T> create(class_2338 targetPos, class_2350 direction, class_1937 world, LookupFunction<T> lookupFunction) {
        class_2680 state = world.method_8320(targetPos);
        class_2586 entity = world.method_8321(targetPos);
        T target = lookupFunction.invoke(world, targetPos, state, entity, direction);
        return new ApiLookupCache<T>(entity, target, targetPos, direction, world, lookupFunction);
    }

    public T lookup() {
        if (this.isCacheValid()) {
            return this.cachedTarget.get();
        }
        this.cachedTarget = new WeakReference<Object>(null);
        this.cachedEntity = new WeakReference<Object>(null);
        this.refresh();
        return this.cachedTarget.get();
    }

    private void refresh() {
        class_2680 currentState = this.world.method_8320(this.targetPos);
        if (currentState.equals(this.lastBlockState)) {
            return;
        }
        class_2586 entity = this.world.method_8321(this.targetPos);
        Object target = null;
        if (entity != null) {
            target = this.lookupFunction.invoke(this.world, this.targetPos, currentState, entity, this.direction);
        }
        this.cachedTarget = new WeakReference<Object>(target);
        this.cachedEntity = new WeakReference<class_2586>(entity);
        this.lastBlockState = currentState;
    }

    private boolean isCacheValid() {
        class_2586 entity = (class_2586)this.cachedEntity.get();
        Object target = this.cachedTarget.get();
        if (entity == null || entity.method_11015()) {
            return false;
        }
        return target != null;
    }

    @FunctionalInterface
    public static interface LookupFunction<T> {
        public T invoke(class_1937 var1, class_2338 var2, class_2680 var3, @Nullable class_2586 var4, @Nullable class_2350 var5);
    }
}

