/*
 * Decompiled with CFR 0.152.
 */
package rearth.oritech.block.entity.reactor;

import dev.architectury.registry.menu.ExtendedMenuProvider;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_1262;
import net.minecraft.class_1263;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1799;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2371;
import net.minecraft.class_2487;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_3419;
import net.minecraft.class_3917;
import net.minecraft.class_3956;
import net.minecraft.class_7225;
import net.minecraft.class_7923;
import net.minecraft.class_8786;
import net.minecraft.class_9129;
import net.minecraft.class_9695;
import org.jetbrains.annotations.Nullable;
import rearth.oritech.api.item.ItemApi;
import rearth.oritech.api.item.containers.InOutInventoryStorage;
import rearth.oritech.api.networking.NetworkManager;
import rearth.oritech.api.networking.SyncField;
import rearth.oritech.api.networking.SyncType;
import rearth.oritech.client.init.ModScreens;
import rearth.oritech.client.ui.BasicMachineScreenHandler;
import rearth.oritech.init.BlockEntitiesContent;
import rearth.oritech.init.SoundContent;
import rearth.oritech.init.recipes.OritechRecipe;
import rearth.oritech.init.recipes.RecipeContent;
import rearth.oritech.util.InventoryInputMode;
import rearth.oritech.util.InventorySlotAssignment;
import rearth.oritech.util.ScreenProvider;
import rearth.oritech.util.SimpleCraftingInventory;

public class ReactorFuelPortEntity
extends class_2586
implements ExtendedMenuProvider,
ScreenProvider,
ItemApi.BlockProvider {
    private final InOutInventoryStorage inventory = new InOutInventoryStorage(1, () -> ((ReactorFuelPortEntity)this).method_5431(), new InventorySlotAssignment(0, 1, 1, 0)){

        @Override
        public int insertToSlot(class_1799 addedStack, int slot, boolean simulate) {
            SimpleCraftingInventory craftingInv = new SimpleCraftingInventory(addedStack);
            Optional recipeCandidate = ReactorFuelPortEntity.this.field_11863.method_8433().method_8132((class_3956)RecipeContent.REACTOR, (class_9695)craftingInv, ReactorFuelPortEntity.this.field_11863);
            if (recipeCandidate.isEmpty()) {
                return 0;
            }
            return super.insertToSlot(addedStack, slot, simulate);
        }
    };
    @SyncField(value={SyncType.GUI_TICK})
    public int availableFuel;
    @SyncField(value={SyncType.GUI_TICK})
    public int currentFuelOriginalCapacity;

    public ReactorFuelPortEntity(class_2338 pos, class_2680 state) {
        super(BlockEntitiesContent.REACTOR_FUEL_PORT_BLOCK_ENTITY, pos, state);
    }

    protected void method_11007(class_2487 nbt, class_7225.class_7874 registryLookup) {
        super.method_11007(nbt, registryLookup);
        nbt.method_10569("available", this.availableFuel);
        nbt.method_10569("capacity", this.currentFuelOriginalCapacity);
        class_1262.method_5427((class_2487)nbt, (class_2371)this.inventory.heldStacks, (boolean)false, (class_7225.class_7874)registryLookup);
    }

    protected void method_11014(class_2487 nbt, class_7225.class_7874 registryLookup) {
        super.method_11014(nbt, registryLookup);
        this.availableFuel = nbt.method_10550("available");
        this.currentFuelOriginalCapacity = nbt.method_10550("capacity");
        class_1262.method_5429((class_2487)nbt, (class_2371)this.inventory.heldStacks, (class_7225.class_7874)registryLookup);
    }

    public boolean tryConsumeFuel(int amount, boolean disabled) {
        int capacity;
        if (this.availableFuel >= amount) {
            this.availableFuel -= amount;
            return true;
        }
        if (disabled) {
            return false;
        }
        class_1799 inputStack = this.inventory.method_5438(0);
        if (inputStack.method_7960()) {
            return false;
        }
        SimpleCraftingInventory craftingInv = new SimpleCraftingInventory(inputStack);
        Optional recipeCandidate = this.field_11863.method_8433().method_8132((class_3956)RecipeContent.REACTOR, (class_9695)craftingInv, this.field_11863);
        if (recipeCandidate.isEmpty()) {
            return false;
        }
        this.currentFuelOriginalCapacity = capacity = ((OritechRecipe)((class_8786)recipeCandidate.get()).comp_1933()).getTime();
        this.availableFuel = capacity - amount;
        inputStack.method_7934(1);
        this.playLoadingSound();
        return true;
    }

    private void playLoadingSound() {
        float variation = this.field_11863.field_9229.method_43057() * 0.6f - 0.2f;
        this.field_11863.method_8396(null, this.field_11867, SoundContent.REACTOR_LOADING, class_3419.field_15245, 0.5f, 0.8f + variation);
    }

    public void updateNetwork() {
        class_9129 usedBuf = new class_9129(Unpooled.buffer(), this.field_11863.method_30349());
        int fieldCount = NetworkManager.encodeFields(this, SyncType.GUI_TICK, (ByteBuf)usedBuf, this.field_11863);
        if (fieldCount == 0) {
            return;
        }
        NetworkManager.sendBlockHandle(this, new NetworkManager.MessagePayload(this.field_11867, class_7923.field_41181.method_10221((Object)this.method_11017()), SyncType.GUI_TICK, usedBuf.array()));
    }

    public void saveExtraData(class_2540 buf) {
        buf.method_10807(this.field_11867);
    }

    public class_2561 method_5476() {
        return class_2561.method_30163((String)"");
    }

    @Nullable
    public class_1703 createMenu(int syncId, class_1661 playerInventory, class_1657 player) {
        return new BasicMachineScreenHandler(syncId, playerInventory, this);
    }

    @Override
    public List<ScreenProvider.GuiSlot> getGuiSlots() {
        return List.of(new ScreenProvider.GuiSlot(0, 55, 35));
    }

    @Override
    public boolean showEnergy() {
        return false;
    }

    @Override
    public float getDisplayedEnergyUsage() {
        return 0.0f;
    }

    @Override
    public float getProgress() {
        return 0.0f;
    }

    @Override
    public boolean showProgress() {
        return false;
    }

    @Override
    public InventoryInputMode getInventoryInputMode() {
        return InventoryInputMode.FILL_LEFT_TO_RIGHT;
    }

    @Override
    public class_1263 getDisplayedInventory() {
        return this.inventory;
    }

    @Override
    public class_3917<?> getScreenHandlerType() {
        return ModScreens.FUEL_PORT_SCREEN;
    }

    @Override
    public boolean inputOptionsEnabled() {
        return false;
    }

    @Override
    public boolean showExpansionPanel() {
        return false;
    }

    @Override
    public ItemApi.InventoryStorage getInventoryStorage(class_2350 direction) {
        return this.inventory;
    }
}

