/*
 * Decompiled with CFR 0.152.
 */
package rearth.oritech.block.entity.interaction;

import dev.architectury.registry.menu.ExtendedMenuProvider;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import net.minecraft.class_1263;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_18;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3419;
import net.minecraft.class_3545;
import net.minecraft.class_3917;
import net.minecraft.class_7225;
import net.minecraft.class_9135;
import net.minecraft.class_9139;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import rearth.oritech.Oritech;
import rearth.oritech.api.energy.EnergyApi;
import rearth.oritech.api.energy.containers.DelegatingEnergyStorage;
import rearth.oritech.api.energy.containers.DynamicStatisticEnergyStorage;
import rearth.oritech.api.item.ItemApi;
import rearth.oritech.api.item.containers.SimpleInventoryStorage;
import rearth.oritech.api.networking.NetworkedBlockEntity;
import rearth.oritech.api.networking.SyncField;
import rearth.oritech.api.networking.SyncType;
import rearth.oritech.api.networking.UpdatableField;
import rearth.oritech.block.base.entity.ExpandableEnergyStorageBlockEntity;
import rearth.oritech.block.blocks.processing.MachineCoreBlock;
import rearth.oritech.client.init.ModScreens;
import rearth.oritech.client.ui.UpgradableMachineScreenHandler;
import rearth.oritech.init.BlockEntitiesContent;
import rearth.oritech.init.SoundContent;
import rearth.oritech.util.InventoryInputMode;
import rearth.oritech.util.MultiblockMachineController;
import rearth.oritech.util.ScreenProvider;

public class PowerPoleEntity
extends NetworkedBlockEntity
implements MultiblockMachineController,
ExtendedMenuProvider,
ScreenProvider,
EnergyApi.BlockProvider {
    public static final HashMap<class_2960, PoleNetworkData> POLE_NETWORK_DATA = new HashMap();
    private final ArrayList<class_2338> coreBlocksConnected = new ArrayList();
    @SyncField(value={SyncType.GUI_OPEN})
    private float coreQuality = 1.0f;
    @SyncField(value={SyncType.INITIAL, SyncType.CUSTOM})
    private final Set<ConnectionTarget> connections = new HashSet<ConnectionTarget>();
    private PoleNetworkData netDataRef = null;
    @SyncField(value={SyncType.GUI_TICK})
    public DynamicStatisticEnergyStorage.EnergyStatistics currentStats = DynamicStatisticEnergyStorage.EnergyStatistics.EMPTY;
    @SyncField(value={SyncType.GUI_OPEN, SyncType.GUI_TICK})
    protected final PowerPoleEnergyStorage energyStorage = new PowerPoleEnergyStorage();
    private final EnergyApi.EnergyStorage outputStorage = new DelegatingEnergyStorage(this, this.energyStorage, null){

        @Override
        public boolean supportsInsertion() {
            return false;
        }

        @Override
        public long insert(long amount, boolean simulate) {
            return 0L;
        }
    };
    private final SimpleInventoryStorage basicInv = new SimpleInventoryStorage(0, this::method_5431);

    public PowerPoleEntity(class_2338 pos, class_2680 state) {
        super(BlockEntitiesContent.POWER_POLE_ENTITY, pos, state);
    }

    @Override
    public void serverTick(class_1937 world, class_2338 pos, class_2680 state, NetworkedBlockEntity blockEntity) {
        DynamicStatisticEnergyStorage.EnergyStatistics stats;
        long moved;
        this.outputEnergy();
        this.energyStorage.tick(world.method_8510());
        if (world.field_9229.method_43057() > 0.95f && (moved = (stats = this.energyStorage.getCurrentStatistics(world.method_8510())).insertedLastTickTotal() + stats.extractedLastTickTotal()) > 10L && world instanceof class_3218) {
            class_3218 serverLevel = (class_3218)world;
            class_243 at = this.field_11867.method_46558().method_1031((double)world.field_9229.method_43057() * 0.4, (double)world.field_9229.method_43057() * 0.4, (double)world.field_9229.method_43057() * 0.4);
            serverLevel.method_14199((class_2394)class_2398.field_29644, at.field_1352, at.field_1351, at.field_1350, 2, (double)world.field_9229.method_43057(), (double)world.field_9229.method_43057(), (double)world.field_9229.method_43057(), (double)0.15f);
        }
    }

    @Override
    public void preNetworkUpdate(SyncType type) {
        super.preNetworkUpdate(type);
        this.currentStats = this.energyStorage.getCurrentStatistics(this.field_11863.method_8510());
    }

    private void outputEnergy() {
        if (!this.isConnected() || this.energyStorage.getAmount() <= 0L) {
            return;
        }
        class_3545<class_2350, class_2338> target = ExpandableEnergyStorageBlockEntity.getOutputPosition(this.field_11867, this.getFacingForMultiblock().method_10160());
        EnergyApi.EnergyStorage candidate = EnergyApi.BLOCK.find(this.field_11863, (class_2338)target.method_15441(), ((class_2350)target.method_15442()).method_10153());
        if (candidate != null && candidate.supportsInsertion()) {
            EnergyApi.transfer(this.energyStorage, candidate, Long.MAX_VALUE, false);
        }
    }

    public void assignNewTarget(class_2338 target, class_1657 player) {
        Oritech.LOGGER.info("Assigning new power pole target");
        class_2680 targetState = this.field_11863.method_8320(target);
        if (targetState.method_26204() instanceof MachineCoreBlock && ((Boolean)targetState.method_11654((class_2769)MachineCoreBlock.USED)).booleanValue()) {
            target = MachineCoreBlock.getControllerPos((class_1936)this.field_11863, target);
        }
        float pitch = 0.85f + this.field_11863.field_9229.method_43057() * 0.3f;
        this.field_11863.method_8396(null, this.field_11867, SoundContent.ELECTRIC_SHOCK, class_3419.field_15248, 0.7f, pitch);
        int dist = target.method_19455((class_2382)this.field_11867);
        if (dist < Oritech.CONFIG.poleConfig.minRange() || dist > Oritech.CONFIG.poleConfig.maxRange()) {
            player.method_43496((class_2561)class_2561.method_43469((String)"message.oritech.target_designator.pole_dist_invalid", (Object[])new Object[]{Oritech.CONFIG.poleConfig.minRange(), Oritech.CONFIG.poleConfig.maxRange(), dist}));
            return;
        }
        Optional targetEntityCandidate = this.field_11863.method_35230(target, BlockEntitiesContent.POWER_POLE_ENTITY);
        if (targetEntityCandidate.isEmpty() || target.equals((Object)this.field_11867)) {
            player.method_43496((class_2561)class_2561.method_43471((String)"message.oritech.target_designator.pole_position_invalid"));
            return;
        }
        PowerPoleEntity targetEntity = (PowerPoleEntity)targetEntityCandidate.get();
        if (this.connections.stream().anyMatch(elem -> elem.pos().equals((Object)targetEntity.field_11867))) {
            this.removeIncomingConnection(target);
            targetEntity.removeIncomingConnection(this.field_11867);
            PoleNetworkData netData = this.getCachedNetData();
            PoleNetwork net = netData.getNetwork(this.field_11867);
            this.updateConnectionsInState(net);
            targetEntity.updateConnectionsInState(net);
            netData.updateNetworkSplit(Set.of(this.field_11867, target), this.getNetwork());
            player.method_43496((class_2561)class_2561.method_43471((String)"message.oritech.target_designator.removing_pole_connection"));
            return;
        }
        this.connections.add(targetEntity.getConnectionData());
        targetEntity.assignIncomingConnection(this);
        PoleNetworkData allNetworks = this.getCachedNetData();
        PoleNetwork ownNet = this.getNetwork();
        boolean isConnected = this.isConnected();
        PoleNetwork targetNet = targetEntity.getNetwork();
        boolean targetConnected = targetEntity.isConnected();
        if (!isConnected && targetConnected) {
            this.joinNetwork(targetNet, allNetworks);
        } else if (isConnected && !targetConnected) {
            targetEntity.joinNetwork(ownNet, allNetworks);
        } else if (!isConnected && !targetConnected) {
            PoleNetwork newNet = this.createNetwork(allNetworks);
            this.joinNetwork(newNet, allNetworks);
            targetEntity.joinNetwork(newNet, allNetworks);
        } else if (isConnected && targetConnected) {
            if (targetNet != ownNet) {
                allNetworks.mergeNetworks(ownNet, targetNet);
            }
        } else {
            throw new IllegalStateException("This should never happen");
        }
        allNetworks.method_80();
        this.updateConnectionsInState(Objects.requireNonNull(this.getNetwork()));
        targetEntity.updateConnectionsInState(this.getNetwork());
        this.setChanged(false);
        this.sendUpdate(SyncType.CUSTOM);
        player.method_43496((class_2561)class_2561.method_43471((String)"message.oritech.target_designator.connected_poles"));
    }

    private void joinNetwork(PoleNetwork target, PoleNetworkData data) {
        data.activeNetworks.put(this.field_11867, target);
    }

    private void updateConnectionsInState(PoleNetwork network) {
        network.setPole(this.field_11867, this.connections);
    }

    private PoleNetwork createNetwork(PoleNetworkData data) {
        return new PoleNetwork();
    }

    public void assignIncomingConnection(PowerPoleEntity from) {
        this.connections.add(from.getConnectionData());
        this.setChanged(false);
        this.sendUpdate(SyncType.CUSTOM);
    }

    public void removeIncomingConnection(class_2338 source) {
        List<ConnectionTarget> removed = this.connections.stream().filter(elem -> elem.pos().equals((Object)source)).toList();
        removed.forEach(this.connections::remove);
        this.setChanged(false);
        this.sendUpdate(SyncType.CUSTOM);
    }

    public ConnectionTarget getConnectionData() {
        return new ConnectionTarget(this.field_11867, this.getFacingForMultiblock());
    }

    public Set<ConnectionTarget> getConnections() {
        return this.connections;
    }

    public PoleNetworkData getCachedNetData() {
        if (this.netDataRef == null) {
            this.netDataRef = POLE_NETWORK_DATA.computeIfAbsent(this.field_11863.method_27983().method_29177(), data -> new PoleNetworkData());
        }
        return this.netDataRef;
    }

    public void onRemoved() {
        for (ConnectionTarget target : this.connections) {
            class_2586 class_25862 = this.field_11863.method_8321(target.pos);
            if (!(class_25862 instanceof PowerPoleEntity)) continue;
            PowerPoleEntity powerPole = (PowerPoleEntity)class_25862;
            powerPole.removeIncomingConnection(this.field_11867);
        }
        PoleNetworkData allNetworks = this.getCachedNetData();
        allNetworks.removePole(this.field_11867);
        allNetworks.method_80();
        this.setChanged(false);
    }

    @Override
    public void setChanged(boolean updateComparator) {
        super.setChanged(updateComparator);
        this.getCachedNetData().method_80();
    }

    private boolean isConnected() {
        return this.getNetwork() != null;
    }

    private PoleNetwork getNetwork() {
        return this.getCachedNetData().getNetwork(this.field_11867);
    }

    protected void method_11007(@NotNull class_2487 tag, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull class_7225.class_7874 registries) {
        super.method_11007(tag, registries);
        this.addMultiblockToNbt(tag);
        class_2499 connectionList = new class_2499();
        for (ConnectionTarget connection : this.connections) {
            class_2487 compound = new class_2487();
            compound.method_10544("p", connection.pos().method_10063());
            compound.method_10569("d", connection.facing.ordinal());
            connectionList.add((Object)compound);
        }
        tag.method_10566("connectionData", (class_2520)connectionList);
    }

    protected void method_11014(@NotNull class_2487 tag, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull class_7225.class_7874 registries) {
        super.method_11014(tag, registries);
        this.loadMultiblockNbtData(tag);
        if (tag.method_10545("connectionData")) {
            this.connections.clear();
            class_2499 nbtList = tag.method_10554("connectionData", 10);
            for (class_2520 nbtElem : nbtList) {
                class_2487 elem = (class_2487)nbtElem;
                class_2338 pos = class_2338.method_10092((long)elem.method_10537("p"));
                class_2350 dir = class_2350.values()[elem.method_10550("d")];
                this.connections.add(new ConnectionTarget(pos, dir));
            }
        }
    }

    public void saveExtraData(class_2540 buf) {
        this.sendUpdate(SyncType.GUI_OPEN);
        buf.method_10807(this.field_11867);
    }

    @NotNull
    public class_2561 method_5476() {
        return class_2561.method_43473();
    }

    @Nullable
    public class_1703 createMenu(int containerId, @NotNull class_1661 playerInventory, @NotNull class_1657 player) {
        return new UpgradableMachineScreenHandler(containerId, playerInventory, this);
    }

    @Override
    public EnergyApi.EnergyStorage getEnergyStorage(class_2350 direction) {
        if (direction != null && direction.equals((Object)this.getFacingForMultiblock().method_10160())) {
            return this.outputStorage;
        }
        return this.energyStorage;
    }

    @Override
    public List<class_2382> getCorePositions() {
        return List.of(new class_2382(1, 0, 0), new class_2382(-1, 0, 0));
    }

    @Override
    public class_2350 getFacingForMultiblock() {
        return ((class_2350)this.method_11010().method_11654((class_2769)class_2741.field_12481)).method_10153();
    }

    @Override
    public class_2338 getPosForMultiblock() {
        return this.field_11867;
    }

    @Override
    public class_1937 getWorldForMultiblock() {
        return this.field_11863;
    }

    @Override
    public ArrayList<class_2338> getConnectedCores() {
        return this.coreBlocksConnected;
    }

    @Override
    public void setCoreQuality(float quality) {
        this.coreQuality = quality;
    }

    @Override
    public float getCoreQuality() {
        return this.coreQuality;
    }

    @Override
    public ItemApi.InventoryStorage getInventoryForMultiblock() {
        return null;
    }

    @Override
    public EnergyApi.EnergyStorage getEnergyStorageForMultiblock(class_2350 direction) {
        return this.energyStorage;
    }

    @Override
    public void triggerSetupAnimation() {
    }

    @Override
    public List<ScreenProvider.GuiSlot> getGuiSlots() {
        return List.of();
    }

    @Override
    public float getDisplayedEnergyUsage() {
        return 0.0f;
    }

    @Override
    public float getDisplayedEnergyTransfer() {
        return Oritech.CONFIG.poleConfig.energyCapacity();
    }

    @Override
    public ScreenProvider.BarConfiguration getEnergyConfiguration() {
        return new ScreenProvider.BarConfiguration(7, 6, 18, 72);
    }

    @Override
    public float getProgress() {
        return 0.0f;
    }

    @Override
    public boolean showProgress() {
        return false;
    }

    @Override
    public boolean showExpansionPanel() {
        return false;
    }

    @Override
    public InventoryInputMode getInventoryInputMode() {
        return InventoryInputMode.FILL_LEFT_TO_RIGHT;
    }

    @Override
    public class_1263 getDisplayedInventory() {
        return this.basicInv;
    }

    @Override
    public class_3917<?> getScreenHandlerType() {
        return ModScreens.POWER_POLE_SCREEN;
    }

    public static class PoleNetworkData
    extends class_18 {
        private final Map<class_2338, PoleNetwork> activeNetworks = new HashMap<class_2338, PoleNetwork>();
        public static class_18.class_8645<PoleNetworkData> TYPE = new class_18.class_8645(PoleNetworkData::new, PoleNetworkData::fromNbt, null);

        @NotNull
        public PoleNetwork getNetwork(class_2338 pos) {
            return this.activeNetworks.computeIfAbsent(pos, elem -> {
                HashMap<class_2338, Set<class_2338>> data = new HashMap<class_2338, Set<class_2338>>();
                data.put((class_2338)elem, Set.of());
                return new PoleNetwork(data, 0L);
            });
        }

        @NotNull
        public class_2487 method_75(@NotNull class_2487 tag, @NotNull class_7225.class_7874 registryLookup) {
            class_2499 networksList = new class_2499();
            HashSet<PoleNetwork> uniqueNetworks = new HashSet<PoleNetwork>(this.activeNetworks.values());
            for (PoleNetwork network : uniqueNetworks) {
                class_2487 networkCompound = new class_2487();
                networkCompound.method_10544("energy", network.storedEnergy);
                class_2499 poleList = new class_2499();
                for (Map.Entry<class_2338, Set<class_2338>> polePair : network.poles.entrySet()) {
                    class_2487 data = new class_2487();
                    data.method_10544("pos", polePair.getKey().method_10063());
                    data.method_10564("cons", polePair.getValue().stream().mapToLong(class_2338::method_10063).toArray());
                    poleList.add((Object)data);
                }
                networkCompound.method_10566("poles", (class_2520)poleList);
                networksList.add((Object)networkCompound);
            }
            tag.method_10566("networks", (class_2520)networksList);
            return tag;
        }

        public static PoleNetworkData fromNbt(class_2487 nbt, class_7225.class_7874 registryLookup) {
            PoleNetworkData data = new PoleNetworkData();
            if (!nbt.method_10545("networks")) {
                return data;
            }
            class_2499 networksList = nbt.method_10554("networks", 10);
            for (class_2520 networkTag : networksList) {
                class_2487 tag = (class_2487)networkTag;
                long energy = tag.method_10537("energy");
                HashMap<class_2338, Set<class_2338>> poles = new HashMap<class_2338, Set<class_2338>>();
                class_2499 poleDataList = tag.method_10554("poles", 10);
                for (class_2520 poleDataTag : poleDataList) {
                    class_2487 poleData = (class_2487)poleDataTag;
                    class_2338 polePos = class_2338.method_10092((long)poleData.method_10537("pos"));
                    HashSet<class_2338> poleConnections = new HashSet<class_2338>(Arrays.stream(poleData.method_10565("cons")).mapToObj(class_2338::method_10092).toList());
                    poles.put(polePos, poleConnections);
                }
                PoleNetwork network = new PoleNetwork(poles, energy);
                for (class_2338 polePos : network.getPoles()) {
                    data.activeNetworks.put(polePos, network);
                }
            }
            return data;
        }

        protected void mergeNetworks(PoleNetwork netA, PoleNetwork netB) {
            netA.storedEnergy = Math.min(Oritech.CONFIG.poleConfig.energyCapacity(), netA.storedEnergy + netB.storedEnergy);
            netA.poles.putAll(netB.poles);
            for (class_2338 polePos : netB.getPoles()) {
                this.activeNetworks.put(polePos, netA);
            }
        }

        public void updateNetworkSplit(Set<class_2338> removedConnections, PoleNetwork existingNet) {
            HashSet<Map<class_2338, Set<class_2338>>> newNets = new HashSet<Map<class_2338, Set<class_2338>>>();
            for (class_2338 deletedConnection : removedConnections) {
                Map<class_2338, Set<class_2338>> newConnectionNet = PoleNetworkData.FloodFillNetwork(existingNet, deletedConnection);
                newNets.add(newConnectionNet);
            }
            if (newNets.size() == 1) {
                return;
            }
            int newNetCount = newNets.size();
            long newNetPower = existingNet.storedEnergy / (long)newNetCount;
            for (Map map : newNets) {
                PoleNetwork newNet = new PoleNetwork(map, newNetPower);
                for (class_2338 polePos : newNet.getPoles()) {
                    this.activeNetworks.put(polePos, newNet);
                }
            }
        }

        public void removePole(class_2338 removeAt) {
            PoleNetwork existingNet = this.activeNetworks.get(removeAt);
            if (existingNet == null) {
                return;
            }
            this.activeNetworks.remove(removeAt);
            Set<class_2338> removedPoleConnections = existingNet.poles.remove(removeAt);
            if (removedPoleConnections.size() <= 1) {
                return;
            }
            this.updateNetworkSplit(removedPoleConnections, existingNet);
        }

        private static Map<class_2338, Set<class_2338>> FloodFillNetwork(PoleNetwork existing, class_2338 startAt) {
            int maxIterations = 200;
            HashMap<class_2338, Set<class_2338>> result = new HashMap<class_2338, Set<class_2338>>();
            Set<class_2338> openChecks = Set.of(startAt);
            for (int i = 0; i < maxIterations; ++i) {
                HashSet<class_2338> next = new HashSet<class_2338>();
                for (class_2338 openPole : openChecks) {
                    Set<class_2338> connections = existing.getConnections(openPole);
                    if (connections == null) continue;
                    result.put(openPole, connections);
                    next.addAll(connections.stream().filter(elem -> !result.containsKey(elem)).toList());
                }
                if (next.isEmpty()) break;
                openChecks = next;
            }
            return result;
        }
    }

    protected class PowerPoleEnergyStorage
    extends EnergyApi.EnergyStorage
    implements UpdatableField<PowerPoleEnergyStorage, Long> {
        private long clientShownEnergy;

        protected PowerPoleEnergyStorage() {
        }

        private boolean isValid() {
            return PowerPoleEntity.this.field_11863 != null && PowerPoleEntity.this.isConnected();
        }

        @Override
        public long insert(long maxAmount, boolean simulate) {
            if (!this.isValid()) {
                return 0L;
            }
            long insertAmount = Math.min(maxAmount, this.getCapacity() - this.getAmount());
            if (insertAmount > 0L && !simulate) {
                long newAmount = this.getAmount() + insertAmount;
                this.setAmount(newAmount);
                PowerPoleEntity.this.getNetwork().inserted.add(insertAmount);
            }
            return insertAmount;
        }

        @Override
        public long extract(long maxAmount, boolean simulate) {
            if (!this.isValid()) {
                return 0L;
            }
            long extractAmount = Math.min(maxAmount, this.getAmount());
            if (extractAmount > 0L && !simulate) {
                long newAmount = this.getAmount() - extractAmount;
                this.setAmount(newAmount);
                PowerPoleEntity.this.getNetwork().extracted.add(extractAmount);
            }
            return extractAmount;
        }

        @Override
        public void setAmount(long amount) {
            if (!this.isValid()) {
                return;
            }
            if (amount > this.getCapacity() || amount < 0L) {
                Oritech.LOGGER.error("tried setting invalid amount for pole network: " + amount);
                return;
            }
            PoleNetwork network = PowerPoleEntity.this.getNetwork();
            if (network == null) {
                Oritech.LOGGER.error("Invalid set network state for power pole entity at: {}", (Object)PowerPoleEntity.this.field_11867);
                return;
            }
            network.storedEnergy = amount;
        }

        @Override
        public long getAmount() {
            if (PowerPoleEntity.this.field_11863.method_8608()) {
                return this.clientShownEnergy;
            }
            if (!this.isValid()) {
                return 0L;
            }
            PoleNetwork network = PowerPoleEntity.this.getNetwork();
            if (network == null) {
                Oritech.LOGGER.error("Invalid get network state for power pole entity at: {}", (Object)PowerPoleEntity.this.field_11867);
                return 0L;
            }
            return network.storedEnergy;
        }

        @Override
        public long getCapacity() {
            return Oritech.CONFIG.poleConfig.energyCapacity();
        }

        @Override
        public void update() {
            if (!this.isValid()) {
                return;
            }
            PowerPoleEntity.this.setChanged(false);
        }

        public void tick(long worldTicks) {
            PoleNetwork net = PowerPoleEntity.this.getNetwork();
            if (worldTicks <= net.lastTickedAt) {
                return;
            }
            int index = (int)(worldTicks % 20L);
            net.historicInsert[index] = net.inserted.stream().mapToLong(Long::longValue).sum();
            net.historicExtract[index] = net.extracted.stream().mapToLong(Long::longValue).sum();
            net.currentInsertSources = net.inserted.size();
            net.inserted.clear();
            net.extracted.clear();
            net.lastTickedAt = worldTicks;
        }

        public DynamicStatisticEnergyStorage.EnergyStatistics getCurrentStatistics(long worldTicks) {
            int index = (int)(worldTicks % 20L);
            PoleNetwork net = PowerPoleEntity.this.getNetwork();
            return new DynamicStatisticEnergyStorage.EnergyStatistics((float)Arrays.stream(net.historicInsert).mapToLong(Long::longValue).average().orElse(0.0), (float)Arrays.stream(net.historicExtract).mapToLong(Long::longValue).average().orElse(0.0), net.historicInsert[index], net.historicExtract[index], net.currentInsertSources, Arrays.stream(net.historicInsert).mapToLong(Long::longValue).max().orElse(0L), Arrays.stream(net.historicExtract).mapToLong(Long::longValue).max().orElse(0L));
        }

        @Override
        public Long getDeltaData() {
            return this.getAmount();
        }

        @Override
        public PowerPoleEnergyStorage getFullData() {
            return this;
        }

        @Override
        public class_9139<? extends ByteBuf, Long> getDeltaCodec() {
            return class_9135.field_48551;
        }

        @Override
        public class_9139<? extends ByteBuf, PowerPoleEnergyStorage> getFullCodec() {
            return null;
        }

        @Override
        public boolean useDeltaOnly(SyncType type) {
            return true;
        }

        @Override
        public void handleFullUpdate(PowerPoleEnergyStorage updatedData) {
        }

        @Override
        public void handleDeltaUpdate(Long updatedData) {
            this.clientShownEnergy = updatedData;
        }
    }

    public static class PoleNetwork {
        private final Map<class_2338, Set<class_2338>> poles;
        public long storedEnergy = 0L;
        private final List<Long> inserted = new ArrayList<Long>();
        private final List<Long> extracted = new ArrayList<Long>();
        private final Long[] historicInsert = new Long[20];
        private final Long[] historicExtract = new Long[20];
        private int currentInsertSources = 0;
        private long lastTickedAt = 0L;

        private PoleNetwork(Map<class_2338, Set<class_2338>> loadedPoles, long storedEnergy) {
            this.poles = new HashMap<class_2338, Set<class_2338>>(loadedPoles);
            this.storedEnergy = storedEnergy;
            Arrays.fill((Object[])this.historicInsert, (Object)0L);
            Arrays.fill((Object[])this.historicExtract, (Object)0L);
        }

        public PoleNetwork() {
            this.poles = new HashMap<class_2338, Set<class_2338>>();
            Arrays.fill((Object[])this.historicInsert, (Object)0L);
            Arrays.fill((Object[])this.historicExtract, (Object)0L);
        }

        public Set<class_2338> getPoles() {
            return this.poles.keySet();
        }

        public Set<class_2338> getConnections(class_2338 polePos) {
            return this.poles.get(polePos);
        }

        public void setPole(class_2338 pole, Set<ConnectionTarget> connections) {
            this.poles.put(pole, new HashSet<class_2338>(connections.stream().map(elem -> elem.pos()).toList()));
        }
    }

    public record ConnectionTarget(class_2338 pos, class_2350 facing) {
    }
}

