/*
 * Decompiled with CFR 0.152.
 */
package rearth.oritech.block.entity.accelerator;

import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_5558;
import rearth.oritech.block.entity.accelerator.AcceleratorParticleLogic;
import rearth.oritech.init.BlockEntitiesContent;
import rearth.oritech.util.ComparatorOutputProvider;

public class AcceleratorSensorBlockEntity
extends class_2586
implements class_5558<AcceleratorSensorBlockEntity>,
ComparatorOutputProvider {
    private float measuredSpeed;
    private long measuredTime;
    private boolean dirty = false;

    public AcceleratorSensorBlockEntity(class_2338 pos, class_2680 state) {
        super(BlockEntitiesContent.ACCELERATOR_SENSOR_BLOCK_ENTITY, pos, state);
    }

    public void tick(class_1937 world, class_2338 pos, class_2680 state, AcceleratorSensorBlockEntity blockEntity) {
        long age;
        if (world.field_9236) {
            return;
        }
        if (this.measuredSpeed != 0.0f && (age = world.method_8510() - this.measuredTime) > 8L) {
            this.measuredSpeed = 0.0f;
            this.dirty = true;
        }
        if (this.dirty) {
            this.dirty = false;
            world.method_8455(pos, this.method_11010().method_26204());
        }
    }

    public void measureParticle(AcceleratorParticleLogic.ActiveParticle particle) {
        this.measuredSpeed = particle.velocity;
        this.measuredTime = this.field_11863.method_8510();
        this.dirty = true;
    }

    @Override
    public int getComparatorOutput() {
        if (this.measuredSpeed <= 0.0f) {
            return 0;
        }
        if (this.measuredSpeed <= 10.0f) {
            return 1;
        }
        if (this.measuredSpeed <= 50.0f) {
            return 2;
        }
        if (this.measuredSpeed <= 75.0f) {
            return 3;
        }
        if (this.measuredSpeed <= 100.0f) {
            return 4;
        }
        if (this.measuredSpeed <= 150.0f) {
            return 5;
        }
        if (this.measuredSpeed <= 250.0f) {
            return 6;
        }
        if (this.measuredSpeed <= 500.0f) {
            return 7;
        }
        if (this.measuredSpeed <= 750.0f) {
            return 8;
        }
        if (this.measuredSpeed <= 1000.0f) {
            return 9;
        }
        if (this.measuredSpeed <= 2500.0f) {
            return 10;
        }
        if (this.measuredSpeed <= 5000.0f) {
            return 11;
        }
        if (this.measuredSpeed <= 7500.0f) {
            return 12;
        }
        if (this.measuredSpeed <= 10000.0f) {
            return 13;
        }
        if (this.measuredSpeed <= 15000.0f) {
            return 14;
        }
        return 15;
    }
}

