package rearth.oritech.client.ui;

import rearth.oritech.Oritech;
import rearth.oritech.block.entity.interaction.DronePortEntity;
import rearth.oritech.item.tools.LaserTargetDesignator;

import java.util.Objects;
import net.minecraft.class_1277;
import net.minecraft.class_1661;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_2540;
import net.minecraft.class_2586;

public class DroneScreenHandler extends UpgradableMachineScreenHandler {
    
    private final class_1277 cardInventory;
    
    public DroneScreenHandler(int syncId, class_1661 inventory, class_2540 buf) {
        this(syncId, inventory, Objects.requireNonNull(inventory.field_7546.method_37908().method_8321(buf.method_10811())));
    }
    
    public DroneScreenHandler(int syncId, class_1661 playerInventory, class_2586 blockEntity) {
        super(syncId, playerInventory, blockEntity);

        if (!(blockEntity instanceof DronePortEntity dronePortEntity)) {
            cardInventory = null;
            Oritech.LOGGER.error("Opened drone screen on non-drone block, this should never happen");
            return;
        }
        
        cardInventory = dronePortEntity.getCardInventory();
        cardInventory.method_5435(playerInventory.field_7546);
        addCardSlots();
    }
    
    private void addCardSlots() {
        method_7621(new class_1735(cardInventory, 0, 130, 26));
        method_7621(new class_1735(cardInventory, 1, 130, 62));
    }
    
    // card slots are appended at end, so order is: machine inv - player inv - bucket inv
    @Override
    public int getPlayerInvEndSlot(class_1799 stack) {
        return super.getPlayerInvEndSlot(stack) - 2;
    }
    
    @Override
    public int getMachineInvStartSlot(class_1799 stack) {
        
        if (stack.method_7909() instanceof LaserTargetDesignator)
            return this.field_7761.size() - 2;
        
        return super.getMachineInvStartSlot(stack);
    }
    
    @Override
    public int getMachineInvEndSlot(class_1799 stack) {
        
        if (stack.method_7909() instanceof LaserTargetDesignator)
            return this.field_7761.size();
        
        return super.getMachineInvEndSlot(stack);
    }
}
