package rearth.oritech.client.renderers;

import dev.architectury.fluid.FluidStack;
import dev.architectury.hooks.fluid.FluidStackHooks;
import io.wispforest.owo.ui.core.Color;
import net.minecraft.class_1087;
import net.minecraft.class_1091;
import net.minecraft.class_1799;
import net.minecraft.class_1921;
import net.minecraft.class_2350;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_811;
import rearth.oritech.Oritech;
import rearth.oritech.api.fluid.FluidApi;

public class SmallTankItemRenderer {
    
    private class_1087 tankVisualModel;
    private final class_2960 TANK_VISUAL_MODEL_ID;
    
    public SmallTankItemRenderer(class_2960 tankVisualModelId) {
        TANK_VISUAL_MODEL_ID = tankVisualModelId;
    }
    
    public void loadModels() {
        if (tankVisualModel == null) {
            this.tankVisualModel = class_310.method_1551().method_1554().method_4742(new class_1091(TANK_VISUAL_MODEL_ID, ""));
            if (this.tankVisualModel == class_310.method_1551().method_1554().method_4744()) {
                this.tankVisualModel = null; // Ensure it's null if missing
                Oritech.LOGGER.warn("Unable to load model for portable tank renderer: {}. Model not found.", TANK_VISUAL_MODEL_ID);
            }
        }
    }
    
    public void render(class_1799 stack, class_811 mode, class_4587 matrices, class_4597 vertexConsumers, int light, int overlay) {
        
        matrices.method_22903();
        matrices.method_22904(0, 0.25, 0);
        matrices.method_22905(0.84f, 0.84f, 0.84f);
        
        matrices.method_22903();
        matrices.method_22904(0.5, 0.5, 0.5);
        matrices.method_22905(0.9f, 0.9f, 0.9f);
        
        if (tankVisualModel == null || tankVisualModel == class_310.method_1551().method_1554().method_4744()) {
            loadModels();
        }
        
        // render the original tank model
        if (this.tankVisualModel != null && this.tankVisualModel != class_310.method_1551().method_1554().method_4744()) {
            class_310.method_1551().method_1480().method_23179(
              stack,
              class_811.field_4315,
              false,
              matrices,
              vertexConsumers,
              light,
              overlay,
              this.tankVisualModel
            );
        }
        
        matrices.method_22909();
        
        var storage = stack.method_57825(FluidApi.ITEM.getFluidComponent(), FluidStack.empty());
        if (storage.isEmpty()) {
            matrices.method_22909();
            return;
        }
        
        var fluid = storage.getFluid();
        var fill = storage.getAmount() / (float) (Oritech.CONFIG.portableTankCapacityBuckets() * FluidStackHooks.bucketAmount());
        
        var sprite = FluidStackHooks.getStillTexture(fluid);
        var spriteColor = FluidStackHooks.getColor(fluid);
        var consumer = vertexConsumers.getBuffer(class_1921.method_23583());
        
        var parsedColor = Color.ofArgb(spriteColor);
        var opaqueColor = new Color(parsedColor.red(), parsedColor.green(), parsedColor.blue(), 1f);
        spriteColor = opaqueColor.argb();
        
        matrices.method_22903();
        matrices.method_22904(0.126, 0.126, 0.126);
        matrices.method_22905(0.745f, 0.745f * fill, 0.745f);
        
        var entry = matrices.method_23760();
        var modelMatrix = entry.method_23761();
        
        // Draw the cube using quads
        for (class_2350 direction : class_2350.values()) {
            if (direction.equals(class_2350.field_11033)) continue; // skip bottom, as it's never visible
            SmallTankRenderer.drawQuad(direction, consumer, modelMatrix, entry, sprite, spriteColor, light, overlay);
        }
        
        matrices.method_22909();
        matrices.method_22909();
    }
}
