package rearth.oritech.client.renderers;

import net.minecraft.class_1921;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_2960;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4668;
import net.minecraft.class_5617;
import net.minecraft.class_7833;
import net.minecraft.class_840;
import rearth.oritech.util.PortalEntity;
import software.bernie.geckolib.cache.object.GeoBone;
import software.bernie.geckolib.renderer.GeoEntityRenderer;
import software.bernie.geckolib.renderer.GeoRenderer;
import software.bernie.geckolib.renderer.layer.GeoRenderLayer;

public class PortalEntityRenderer extends GeoEntityRenderer<PortalEntity> {
    public PortalEntityRenderer(class_5617.class_5618 renderManager) {
        super(renderManager, new PortalEntityModel());
        
        addRenderLayer(new PortalRenderLayer(this));
        
    }
    
    @Override
    protected void applyRotations(PortalEntity animatable, class_4587 poseStack, float ageInTicks, float rotationYaw, float partialTick, float nativeScale) {
        super.applyRotations(animatable, poseStack, ageInTicks, rotationYaw, partialTick, nativeScale);
        poseStack.method_22907(class_7833.field_40716.rotationDegrees(animatable.method_36454()));
    }
    
    public static class PortalRenderLayer extends GeoRenderLayer<PortalEntity> {
        
        public PortalRenderLayer(GeoRenderer<PortalEntity> entityRendererIn) {
            super(entityRendererIn);
        }
        
        @Override
        public void renderForBone(class_4587 poseStack, PortalEntity animatable, GeoBone bone, class_1921 renderType, class_4597 bufferSource, class_4588 buffer, float partialTick, int packedLight, int packedOverlay) {
            super.renderForBone(poseStack, animatable, bone, renderType, bufferSource, buffer, partialTick, packedLight, packedOverlay);
            
            if (!bone.getName().equals("portal")) return;
            
            var layer = class_1921.method_24049("portal_swirl", class_290.field_1592, class_293.class_5596.field_27382, 1536, false, false, class_1921.class_4688.method_23598().method_34578(class_4668.field_29432).method_34577(class_4668.class_5940.method_34560().method_34563(class_840.field_4406, false, false).method_34563(class_2960.method_60656("textures/environment/moon_phases.png"), false, false).method_34562()).method_23617(false));
            
            var consumer = bufferSource.getBuffer(layer);
            
            consumer.method_22918(poseStack.method_23760().method_23761(), 0, 0, 0.55f);
            consumer.method_22918(poseStack.method_23760().method_23761(), 0, 1.95f, 0.55f);
            consumer.method_22918(poseStack.method_23760().method_23761(), 0, 1.95f, -0.55f);
            consumer.method_22918(poseStack.method_23760().method_23761(), 0, 0, -0.55f);
            
        }
    }
    
}
