package rearth.oritech.client.renderers;

import rearth.oritech.block.entity.accelerator.AcceleratorControllerBlockEntity;
import rearth.oritech.client.init.ParticleContent;
import rearth.oritech.client.renderers.util.BeamRenderer;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.class_1921;
import net.minecraft.class_243;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_765;
import net.minecraft.class_827;


public class AcceleratorControllerRenderer implements class_827<AcceleratorControllerBlockEntity> {
    
    private record RenderedLine(float startedAt, List<class_243> positions) {
    }
    
    private final Map<Long, RenderedLine> activeLines = new HashMap<>();
    
    @Override
    public int method_33893() {
        return 128;
    }
    
    @Override
    public boolean shouldRenderOffScreen(AcceleratorControllerBlockEntity blockEntity) {
        return true;
    }
    @Override
    public void render(AcceleratorControllerBlockEntity entity, float tickDelta, class_4587 matrices, class_4597 vertexConsumers, int light, int overlay) {
        
        if (entity.displayTrail == null) {
            activeLines.remove(entity.method_11016().method_10063());
            return;
        }
        
        var time = entity.method_10997().method_8510() + tickDelta;
        
        // try adding new tail to lines
        var displayTrail = entity.displayTrail;
        if (!activeLines.containsKey(entity.method_11016().method_10063()) || !activeLines.get(entity.method_11016().method_10063()).positions.equals(displayTrail)) {
            activeLines.put(entity.method_11016().method_10063(), new RenderedLine(time, displayTrail));
            ParticleContent.PARTICLE_MOVING.spawn(entity.method_10997(), displayTrail.getLast());
        }
        
        var activeLine = activeLines.get(entity.method_11016().method_10063());
        var line = activeLine.positions;
        var age = time - activeLine.startedAt;
        if (age >= 60) {
            if (entity.displayTrail.equals(activeLine.positions)) entity.displayTrail = null;
        }
        
        var bePos = class_243.method_24954(entity.method_11016());
        var baseThickness = 0.07f;
        var beamConsumer = vertexConsumers.getBuffer(class_1921.method_23026(LaserArmRenderer.BEAM_TEXTURE));
        
        for (int i = 0; i < line.size() - 1; i++) {
            var pointCurrent = line.get(i);
            var pointNext = line.get(i + 1);
            
            // to local space
            var startLocal = pointCurrent.method_1020(bePos);
            var endLocal = pointNext.method_1020(bePos);
            
            class_243 delta = endLocal.method_1020(startLocal);
            
            BeamRenderer.renderStraightBeam(
              matrices, beamConsumer, startLocal, delta,
              baseThickness * 0.3f,
              class_765.field_32767,
              LaserArmRenderer.CORE_COLOR_START,
              LaserArmRenderer.CORE_COLOR_START
            );
            
            // render glow
            BeamRenderer.renderStraightBeam(
              matrices, beamConsumer, startLocal, delta,
              baseThickness,
              class_765.field_32767,
              LaserArmRenderer.GLOW_COLOR_START,
              LaserArmRenderer.GLOW_COLOR_START
            );
        }
        
    }
}
