package rearth.oritech.block.entity.reactor;

import com.mojang.authlib.GameProfile;
import dev.architectury.platform.Platform;
import dev.ftb.mods.ftblibrary.math.ChunkDimPos;
import rearth.oritech.OritechPlatform;
import rearth.oritech.api.item.containers.SimpleInventoryStorage;
import rearth.oritech.block.blocks.reactor.NuclearExplosionBlock;
import rearth.oritech.init.BlockEntitiesContent;
import rearth.oritech.init.SoundContent;

import java.util.*;
import net.minecraft.class_1282;
import net.minecraft.class_1301;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3419;
import net.minecraft.class_3481;
import net.minecraft.class_5558;
import net.minecraft.class_7924;
import net.minecraft.class_8111;
import rearth.oritech.util.FakeMachinePlayer;

public class NuclearExplosionEntity extends class_2586 implements class_5558<NuclearExplosionEntity> {

    private long startTime = -1;
    private final Set<class_2338> removedBlocks = new HashSet<>();
    private final Set<class_2338> borderBlocks = new HashSet<>();
    private final Set<DirectionExplosionWave> waves = new HashSet<>();
    private final int size;
    
    private class_3222 nukePlayerEntity = null;

    public NuclearExplosionEntity(class_2338 pos, class_2680 state, int size) {
        super(BlockEntitiesContent.REACTOR_EXPLOSION_ENTITY, pos, state);
        this.size = size;
    }

    public NuclearExplosionEntity(class_2338 pos, class_2680 state) {
        super(BlockEntitiesContent.REACTOR_EXPLOSION_ENTITY, pos, state);
        this.size = 9;
    }

    @Override
    public void tick(class_1937 world, class_2338 pos, class_2680 state, NuclearExplosionEntity blockEntity) {
        if (world.field_9236) return;

        var initialRadius = size;

        if (startTime == -1) {
            startTime = world.method_8510();
            explosionSphere(initialRadius + 7, 200, pos);
            world.method_8396(null, pos, SoundContent.NUKE_EXPLOSION, class_3419.field_15245, 30f, 1f);
        }

        var age = world.method_8510() - startTime;

        if (age == 1) {
            createExplosionWaves(initialRadius);
        }

        if (age > 1) {
            waves.forEach(DirectionExplosionWave::nextGeneration);
            processBorderBlocks(initialRadius * initialRadius);
        }

        if (age > initialRadius * 2) {
            // done
            world.method_8501(pos, class_2246.field_10124.method_9564());
        }

    }

    private void createExplosionWaves(int initialRadius) {

        var rayCount = initialRadius / 2 + 3;
        var directions = getRandomRayDirections(rayCount);
        for (var direction : directions) {
            var data = new DirectionExplosionWave(initialRadius, addRandomOffset(direction, 0.15f), field_11867.method_10069(0, field_11863.field_9229.method_39332(-initialRadius / 2, initialRadius / 2), 0).method_10062());
            waves.add(data);
        }
    }

    private void processBorderBlocks(int maxDist) {

        borderBlocks.forEach(target -> {
            if (removedBlocks.contains(target)) return;
            var distSq = target.method_10262(field_11867);
            var targetBlock = field_11863.method_8320(target);
            var percentageDist = distSq / (maxDist * maxDist) * 8;
            var percentageVaried = percentageDist * (field_11863.field_9229.method_43057() * 0.6 - 0.3 + 1);
            
            if (!OritechPlatform.INSTANCE.canPlayerBreakBlock(field_11863, target, targetBlock, getNukePlayerEntity())) return;
            
            var replaced = false;
            var replacementState = class_2246.field_10124.method_9564();

            if (targetBlock.method_26164(class_3481.field_15475)) {
                replaced = true;
                replacementState = field_11863.field_9229.method_43057() < 0.8 ? class_2246.field_22091.method_9564() : class_2246.field_10092.method_9564();
                if (percentageVaried < 0.4f) replacementState = class_2246.field_10124.method_9564();
            } else if (targetBlock.method_26164(class_3481.field_15503)) {
                replaced = true;
                replacementState = field_11863.field_9229.method_43057() > 0.4 ? class_2246.field_37546.method_9564() : class_2246.field_10124.method_9564();
                if (percentageVaried < 0.6f) replacementState = class_2246.field_10124.method_9564();
            } else if (targetBlock.method_26164(class_3481.field_15462) || targetBlock.method_27852(class_2246.field_10479)) {
                replaced = true;
                replacementState = field_11863.field_9229.method_43057() > 0.4 ? class_2246.field_10428.method_9564() : class_2246.field_10124.method_9564();
                if (percentageVaried < 0.5f) replacementState = class_2246.field_10124.method_9564();
            } else if (targetBlock.method_27852(class_2246.field_10219)) {
                replaced = true;
                if (percentageVaried < 0.05) {
                    replacementState = field_11863.field_9229.method_43057() > 0.5 ? class_2246.field_27165.method_9564() : class_2246.field_10092.method_9564();
                } else if (percentageVaried < 0.3) {
                    replacementState = field_11863.field_9229.method_43057() > 0.2 ? class_2246.field_27165.method_9564() : class_2246.field_10092.method_9564();
                } else if (percentageVaried < 0.55) {
                    replacementState = field_11863.field_9229.method_43057() > 0.1 ? class_2246.field_10253.method_9564() : class_2246.field_10092.method_9564();
                } else {
                    replacementState = class_2246.field_10566.method_9564();
                }

                if (field_11863.field_9229.method_43057() > 0.7) replaced = false;
            } else if (targetBlock.method_27852(class_2246.field_10566)) {
                replaced = true;
                if (percentageVaried < 0.15) {
                    replacementState = field_11863.field_9229.method_43057() > 0.6 ? class_2246.field_10253.method_9564() : class_2246.field_10092.method_9564();
                } else if (percentageVaried < 0.3) {
                    replacementState = field_11863.field_9229.method_43057() > 0.3 ? class_2246.field_27165.method_9564() : class_2246.field_10253.method_9564();
                } else if (percentageVaried < 0.65) {
                    replacementState = field_11863.field_9229.method_43057() > 0.2 ? class_2246.field_10253.method_9564() : class_2246.field_27165.method_9564();
                } else {
                    replaced = false;
                }

                if (field_11863.field_9229.method_43057() > 0.1) replaced = false;
            } else if (targetBlock.method_26164(class_3481.field_25806)) {
                replaced = true;
                if (percentageVaried < 0.3) {
                    replacementState = field_11863.field_9229.method_43057() > 0.5 ? class_2246.field_28888.method_9564() : class_2246.field_10092.method_9564();
                } else if (percentageVaried < 0.5) {
                    replacementState = field_11863.field_9229.method_43057() > 0.3 ? class_2246.field_10340.method_9564() : class_2246.field_10092.method_9564();
                } else if (percentageVaried < 0.7) {
                    replacementState = field_11863.field_9229.method_43057() > 0.2 ? class_2246.field_10474.method_9564() : class_2246.field_10092.method_9564();
                } else {
                    replaced = false;
                }
            } else if (targetBlock.method_26164(class_3481.field_15466) || targetBlock.method_27852(class_2246.field_9979)) {
                replaced = true;
                if (percentageVaried < 0.2) {
                    replacementState = field_11863.field_9229.method_43057() > 0.7 ? class_2246.field_9979.method_9564() : class_2246.field_10092.method_9564();
                } else {
                    replacementState = class_2246.field_10033.method_9564();
                }

                if (percentageVaried > 0.8) replaced = false;
            }

            if (replaced) {
                field_11863.method_30092(target, replacementState, class_2248.field_31032 | class_2248.field_31028, 1);

                // random fire chance
                if (field_11863.method_8320(target.method_10084()).method_45474() && field_11863.field_9229.method_43057() > 0.97) {
                    field_11863.method_30092(target.method_10084(), class_2246.field_10036.method_9564(), class_2248.field_31032 | class_2248.field_31028, 0);
                }
            }
        });

        borderBlocks.clear();
    }

    private void collectExtraEdgeBlocks(class_2338 center) {
        class_2338.method_10097(center.method_10069(-8, -8, -8), center.method_10069(8, 8, 8)).forEach(target -> {
            if (removedBlocks.contains(target)) return;
            var targetState = field_11863.method_8320(target);
            if (targetState.method_26215()) return;
            borderBlocks.add(target.method_10062());
        });
    }

    // remove all blocks in X radius below hardness 'power', return amount of hardness used in total
    // also damage entities
    private int explosionSphere(int radius, int power, class_2338 pos) {

        var radiusSq = radius * radius;
        var radiusSqExtra = (radius + 3) * (radius + 3);
        var usedPower = 0;
        var hardBusters = radius;

        for (var target : class_2338.method_25996(pos, radius + 3, radius + 3, radius + 3)) {
            if (removedBlocks.contains(target)) continue;
            var distSq = target.method_10262(pos);

            if (distSq > radiusSq) {
                if (distSq <= (radiusSqExtra)) {
                    // border block, was almost destroyed
                    borderBlocks.add(target.method_10062());
                }
                continue;
            }

            // if less than half dist, 100%, then slowly ramp up to 0%
            var removalPercentage = (distSq - radiusSq / 2f) / radiusSq;
            if (field_11863.field_9229.method_43057() < removalPercentage - 0.2) {
                borderBlocks.add(target.method_10062());
                continue;
            }

            var targetState = field_11863.method_8320(target);
            var targetBlock = targetState.method_26204();
            var targetHardness = targetBlock.method_9520();

            if (targetBlock instanceof NuclearExplosionBlock || targetState.method_26215() || targetState.method_26214(field_11863, target) < 0)
                continue;

            // skip too hard blocks (except for the first few)
            if (targetHardness > power && hardBusters-- < 0) continue;

            usedPower += targetHardness;
            
            if (!OritechPlatform.INSTANCE.canPlayerBreakBlock(field_11863, target, targetState, getNukePlayerEntity())) return 1000;
            
            targetBlock.method_9585(field_11863, pos, targetState);
            field_11863.method_30092(target, class_2246.field_10124.method_9564(), class_2248.field_31032 | class_2248.field_31028, 0);
            removedBlocks.add(target.method_10062());
            borderBlocks.remove(target.method_10062());

            // damages all entities in radius based on distance
            var entityCandidates = field_11863.method_8390(
                    class_1309.class,
                    new class_238(pos.method_10059(new class_2382(radius, radius, radius)).method_46558(), pos.method_10081(new class_2382(radius, radius, radius)).method_46558()),
                    class_1301.field_6157.and(class_1301.field_6156));

            entityCandidates.forEach(entity -> {
                var entityDist = entity.method_5707(pos.method_46558());
                var distPercentage = entityDist / radiusSq;
                var damage = radiusSq / distPercentage; // closer entities take much more damage
                System.out.println(entityDist + ":" + damage);
                entity.method_5643(new class_1282(field_11863.method_30349().method_30530(class_7924.field_42534).method_40290(class_8111.field_42331)), (float) damage);
            });

        }

        return usedPower;
    }

    private List<class_243> getRandomRayDirections(int count) {
        List<class_243> rayDirections = new ArrayList<>(count);

        // Divide the circle into 12 equal parts
        var angleIncrement = 2 * Math.PI / count; // 360 degrees / 12

        for (int i = 0; i < count; i++) {
            // Calculate the base angle for this ray
            var baseAngle = i * angleIncrement;

            // Add a small random perturbation to the angle
            var randomPerturbation = (field_11863.field_9229.method_43057() - 0.5) * (angleIncrement / 2);

            // Final angle with randomness
            var angle = baseAngle + randomPerturbation;

            // Calculate the direction vector
            var x = Math.cos(angle);
            var z = Math.sin(angle);

            rayDirections.add(new class_243(x, 0, z)); // Horizontal direction
        }

        return rayDirections;
    }

    private class_243 addRandomOffset(class_243 direction, float amount) {
        return direction.method_1031(field_11863.field_9229.method_43057() * amount - amount / 2, field_11863.field_9229.method_43057() * amount - amount / 2, field_11863.field_9229.method_43057() * amount - amount / 2);
    }
    
    private class_1657 getNukePlayerEntity() {
        if (nukePlayerEntity == null && field_11863 instanceof class_3218 serverWorld) {
            nukePlayerEntity = FakeMachinePlayer.create(serverWorld, new GameProfile(UUID.randomUUID(), "oritech_nuke"), new SimpleInventoryStorage(2, () -> {}));
        }
        
        return nukePlayerEntity;
    }

    private class DirectionExplosionWave {

        private final class_243 direction;

        private int lastRadius;
        private class_2338 lastPosition;
        private int lastRadiusReduction;

        private DirectionExplosionWave(int initialRadius, class_243 direction, class_2338 pos) {
            this.direction = direction;
            this.lastRadius = initialRadius;
            this.lastPosition = pos;
            this.lastRadiusReduction = 1;
        }

        private void nextGeneration() {
            var currentRadius = lastRadius - lastRadiusReduction;
            if (currentRadius <= 1) return;
            var rayOffset = direction.method_1021(currentRadius);
            var target = lastPosition.method_10081(class_2338.method_49638(rayOffset));
            var power = currentRadius * 3;
            lastRadius = currentRadius;
            lastPosition = target;

            var usedPower = explosionSphere(currentRadius, power, target);
            var expectedPower = currentRadius * currentRadius * currentRadius * 3;
            if (usedPower > expectedPower) {
                lastRadiusReduction = 2;
            }

            var isLastGeneration = currentRadius - lastRadiusReduction <= 1;
            if (isLastGeneration)
                collectExtraEdgeBlocks(target.method_10081(class_2338.method_49638(rayOffset.method_1021(3))));

        }
    }
}
