package rearth.oritech.api.networking;

import io.netty.buffer.Unpooled;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_3222;
import net.minecraft.class_5558;
import net.minecraft.class_7225;
import net.minecraft.class_7923;
import net.minecraft.class_9129;
import rearth.oritech.Oritech;

// important: when implementing this class and the block has a GUI, make sure to call `this.sendUpdate(SyncType.GUI_OPEN);` in the `saveExtraData()` method.
// also ensure the `gui_tick` event type is sent from the screenhandler `sendContentUpdates` call, e.g. `blockEntity.sendUpdate(SyncType.GUI_TICK);`
public abstract class NetworkedBlockEntity extends class_2586 implements class_5558<NetworkedBlockEntity> {
    
    private boolean networkDirty = false;
    private boolean needsInitialUpdate = false;
    private long lastSentTickUpdate = 0;
    
    public NetworkedBlockEntity(class_2591<?> type, class_2338 pos, class_2680 state) {
        super(type, pos, state);
    }
    
    // this should never be used in child classes, always use serverTick / clientTick
    @Override
    public void tick(class_1937 world, class_2338 pos, class_2680 state, NetworkedBlockEntity blockEntity) {
        if (world.field_9236) {
            clientTick(world, pos, state, blockEntity);
            return;
        }
        
        serverTick(world, pos, state, blockEntity);
        
        var time = world.method_8510();
        
        if ((time + this.field_11867.method_10063()) % getSparseUpdateInterval() == 0)
            sendUpdate(SyncType.SPARSE_TICK);
        
        if (networkDirty && time >= lastSentTickUpdate + getTickUpdateInterval()) {
            networkDirty = false;
            sendUpdate(SyncType.TICK);
            lastSentTickUpdate = time;
        }
        if (needsInitialUpdate) {
            needsInitialUpdate = false;
            sendUpdate(SyncType.INITIAL);
        }
    }
    
    public abstract void serverTick(class_1937 world, class_2338 pos, class_2680 state, NetworkedBlockEntity blockEntity);
    public void clientTick(class_1937 world, class_2338 pos, class_2680 state, NetworkedBlockEntity blockEntity) {};
    
    public int getSparseUpdateInterval() {return 100;}
    
    public int getTickUpdateInterval() {return 4;}
    
    @Override
    public void method_5431() {
        setChanged(false);
    }
    
    public void setChanged(boolean updateComparator) {
        if (this.field_11863 != null) {
            method_31663(this.field_11863, this.field_11867, this.method_11010());
            if (updateComparator)
                field_11863.method_8455(field_11867, method_11010().method_26204());
        }
        
        networkDirty = true;
    }
    
    public void preNetworkUpdate(SyncType type) {}
    
    public void sendUpdate(SyncType type) {
        if (field_11863 == null) {
            Oritech.LOGGER.warn("unable to send update: World is null.");
            return;
        }
        
        preNetworkUpdate(type);
        
        var usedBuf = new class_9129(Unpooled.buffer(), field_11863.method_30349());
        var fieldCount = NetworkManager.encodeFields(this, type, usedBuf, field_11863);
        if (fieldCount == 0) return;
        
        NetworkManager.sendBlockHandle(this, new NetworkManager.MessagePayload(field_11867, class_7923.field_41181.method_10221(method_11017()), type, usedBuf.array()));
    }
    
    public void sendUpdate(SyncType type, class_3222 player) {
        if (field_11863 == null) {
            Oritech.LOGGER.warn("unable to send player update: World is null.");
            return;
        }
        
        preNetworkUpdate(type);
        
        var usedBuf = new class_9129(Unpooled.buffer(), field_11863.method_30349());
        var fieldCount = NetworkManager.encodeFields(this, type, usedBuf, field_11863);
        if (fieldCount == 0) return;
        
        NetworkManager.sendPlayerHandle(new NetworkManager.MessagePayload(field_11867, class_7923.field_41181.method_10221(method_11017()), type, usedBuf.array()), player);
    }
    
    @Override
    public class_2487 method_16887(class_7225.class_7874 registryLookup) {
        needsInitialUpdate = true;
        return super.method_16887(registryLookup);
    }
}
