package rearth.oritech;

import blue.endless.jankson.annotation.Nullable;
import com.mojang.authlib.GameProfile;
import org.apache.logging.log4j.util.TriConsumer;
import org.jetbrains.annotations.NotNull;
import rearth.oritech.api.attachment.Attachment;
import rearth.oritech.api.item.containers.SimpleInventoryStorage;

import java.util.ServiceLoader;
import net.minecraft.class_1282;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_5455;
import net.minecraft.class_8710;
import net.minecraft.class_9129;
import net.minecraft.class_9139;

public interface OritechPlatform {
    
    OritechPlatform INSTANCE = ServiceLoader.load(OritechPlatform.class)
        .findFirst()
        .orElseThrow(() -> new IllegalStateException("Failed to load platform service."));

    // Network
    void sendBlockHandle(class_2586 blockEntity, class_8710 message);

    void sendPlayerHandle(class_8710 message, class_3222 player);

    void sendToServer(class_8710 message);

    <T extends class_8710> void registerToClient(class_8710.class_9154<T> id, class_9139<class_9129, T> packetCodec, TriConsumer<T, class_1937, class_5455> consumer);

    <T extends class_8710> void registerToServer(class_8710.class_9154<T> id, class_9139<class_9129, T> packetCodec, TriConsumer<T, class_1657, class_5455> consumer);
    
    // Attachment
    <T> void register(Attachment<T> attachment);

    <T> boolean hasAttachment(class_1309 entity, Attachment<T> attachment);

    <T> T getAttachmentValue(class_1309 entity, Attachment<T> attachment);

    <T> void setAttachment(class_1309 entity, Attachment<T> attachment, T value);

    <T> void removeAttachment(class_1309 entity, Attachment<T> attachment);

    // FakeMachinePlayer
    class_3222 create(class_3218 world, GameProfile profile, SimpleInventoryStorage inventory);
    
    void resetCapabilities(class_3218 world, class_2338 pos);
    
    /**
     * Fires a BlockEvent.BreakEvent/PlayerBlockBreakEvents.BEFORE and returns whether it was allowed (not cancelled).
     *
     * @param level  The level
     * @param pos    The block position
     * @param state  The current block state
     * @param player The player (can be null for non-player breaks)
     * @return true if the player can break the target block
     */
    boolean canPlayerBreakBlock(class_1937 level, class_2338 pos, class_2680 state, @NotNull class_1657 player);
    
    /**
     * Fires a LivingDamageEvent.Pre or fabric equivalent and returns whether it was allowed (not cancelled).
     *
     */
    boolean canAttackBeDone(class_1937 level, class_1309 target, float amount, class_1282 damageSource);
}
