/*
 * Decompiled with CFR 0.152.
 */
package rearth.oritech.item.tools.harvesting;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import dev.architectury.event.EventResult;
import dev.architectury.utils.value.IntValue;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1271;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1322;
import net.minecraft.class_1657;
import net.minecraft.class_1766;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1832;
import net.minecraft.class_1836;
import net.minecraft.class_1890;
import net.minecraft.class_1893;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_239;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_3222;
import net.minecraft.class_3902;
import net.minecraft.class_3965;
import net.minecraft.class_5134;
import net.minecraft.class_638;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_756;
import net.minecraft.class_7924;
import net.minecraft.class_9274;
import net.minecraft.class_9285;
import net.minecraft.class_9304;
import net.minecraft.class_9331;
import net.minecraft.class_9334;
import org.jetbrains.annotations.Nullable;
import rearth.oritech.Oritech;
import rearth.oritech.client.renderers.PromethiumToolRenderer;
import rearth.oritech.init.ComponentContent;
import rearth.oritech.init.TagContent;
import rearth.oritech.init.ToolsContent;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoItem;
import software.bernie.geckolib.animatable.SingletonGeoAnimatable;
import software.bernie.geckolib.animatable.client.GeoRenderProvider;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.util.GeckoLibUtil;

public class PromethiumPickaxeItem
extends class_1766
implements GeoItem {
    private static final RawAnimation AREA_ANIM = RawAnimation.begin().thenLoop("area");
    private static final RawAnimation SILK_ANIM = RawAnimation.begin().thenLoop("silk_touch");
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);

    public PromethiumPickaxeItem(class_1832 toolMaterial, class_6862<class_2248> effectiveBlocks, class_1792.class_1793 settings) {
        super(toolMaterial, effectiveBlocks, settings);
        SingletonGeoAnimatable.registerSyncedAnimatable((GeoAnimatable)this);
    }

    public boolean method_7878(class_1799 stack, class_1799 ingredient) {
        return false;
    }

    public boolean method_7870(class_1799 stack) {
        return true;
    }

    public boolean method_7879(class_1799 stack, class_1937 world, class_2680 state, class_2338 pos, class_1309 miner) {
        if (!world.field_9236 && stack.method_57826(class_9334.field_49642)) {
            class_9304 enchantments = stack.method_58657();
            class_9304.class_9305 builder = new class_9304.class_9305(enchantments);
            builder.method_57548(elem -> elem.method_40225(class_1893.field_9099));
            stack.method_57379(class_9334.field_49633, (Object)builder.method_57549());
            stack.method_57381(class_9334.field_49642);
        }
        return true;
    }

    private static boolean isAreaEnabled(class_1799 stack) {
        return (Boolean)stack.method_57825((class_9331)ComponentContent.IS_AOE_ACTIVE.get(), (Object)false);
    }

    private static void setAreaEnabled(class_1799 stack, boolean enabled) {
        stack.method_57379((class_9331)ComponentContent.IS_AOE_ACTIVE.get(), (Object)enabled);
    }

    public class_1271<class_1799> method_7836(class_1937 world, class_1657 user, class_1268 hand) {
        if (!world.field_9236 && user.method_5715()) {
            class_1799 stack = user.method_5998(hand);
            boolean wasArea = PromethiumPickaxeItem.isAreaEnabled(stack);
            boolean isArea = !wasArea;
            PromethiumPickaxeItem.setAreaEnabled(stack, isArea);
            user.method_43496((class_2561)(isArea ? class_2561.method_43471((String)"message.oritech.tool_mode.area_effect") : class_2561.method_43471((String)"message.oritech.tool_mode.silk_touch")));
        }
        return super.method_7836(world, user, hand);
    }

    public static List<class_2338> getOffsetBlocks(class_1937 world, class_1657 player, class_2338 pos) {
        class_1799 handStack = player.method_6047();
        if (handStack == null || !handStack.method_31574(ToolsContent.PROMETHIUM_PICKAXE)) {
            return List.of();
        }
        if (PromethiumPickaxeItem.isAreaEnabled(handStack) && !player.method_5715()) {
            ArrayList<class_2338> breakBlocks = new ArrayList<class_2338>();
            class_239 playerHit = player.method_5745(player.method_55754(), 0.0f, false);
            if (playerHit instanceof class_3965) {
                class_3965 blockHit = (class_3965)playerHit;
                class_2350 blockSide = blockHit.method_17780();
                class_2350 perpA = class_2350.field_11034;
                class_2350 perpB = class_2350.field_11043;
                if (blockSide.equals((Object)class_2350.field_11043) || blockSide.equals((Object)class_2350.field_11035)) {
                    perpA = class_2350.field_11036;
                    perpB = class_2350.field_11034;
                } else if (blockSide.equals((Object)class_2350.field_11034) || blockSide.equals((Object)class_2350.field_11039)) {
                    perpA = class_2350.field_11036;
                    perpB = class_2350.field_11043;
                }
                for (int x = -1; x <= 1; ++x) {
                    for (int z = -1; z <= 1; ++z) {
                        if (x == 0 && z == 0) continue;
                        class_2338 neighborPos = pos.method_10081(perpA.method_10163().method_35862(x)).method_10081(perpB.method_10163().method_35862(z));
                        breakBlocks.add(neighborPos);
                    }
                }
                return ImmutableList.copyOf((Iterable)Iterables.filter(breakBlocks, p -> world.method_8320(p).method_26164(TagContent.DRILL_MINEABLE)));
            }
        }
        return List.of();
    }

    public static EventResult preMine(class_1937 world, class_2338 pos, class_2680 state, class_3222 player, @Nullable IntValue xp) {
        class_1799 handStack = player.method_6047();
        if (handStack == null || !handStack.method_31574(ToolsContent.PROMETHIUM_PICKAXE)) {
            return EventResult.pass();
        }
        if (PromethiumPickaxeItem.isAreaEnabled(handStack)) {
            for (class_2338 offsetPos : PromethiumPickaxeItem.getOffsetBlocks(world, (class_1657)player, pos)) {
                class_2680 offsetState = world.method_8320(offsetPos);
                class_2586 offsetEntity = world.method_8321(offsetPos);
                class_2248.method_9511((class_2680)offsetState, (class_1937)world, (class_2338)offsetPos, (class_2586)offsetEntity, (class_1297)player, (class_1799)handStack);
                offsetState.method_26204().method_9576(world, offsetPos, offsetState, (class_1657)player);
                world.method_8651(offsetPos, false, (class_1297)player);
            }
        } else {
            boolean hasExistingSilkTouch = class_1890.method_57532((class_1799)handStack).method_57534().stream().anyMatch(elem -> elem.method_40225(class_1893.field_9099));
            if (!hasExistingSilkTouch) {
                class_6880.class_6883 registryEntry = (class_6880.class_6883)world.method_30349().method_30530(class_7924.field_41265).method_40264(class_1893.field_9099).get();
                handStack.method_7978((class_6880)registryEntry, 1);
                handStack.method_57379(class_9334.field_49642, (Object)class_3902.field_17274);
            }
        }
        return EventResult.pass();
    }

    public static class_9285 createPromethiumAttributes(class_1832 tier, float attackDamage, float attackSpeed, float range) {
        return class_9285.method_57480().method_57487(class_5134.field_23721, new class_1322(field_8006, (double)(attackDamage + tier.method_8028()), class_1322.class_1323.field_6328), class_9274.field_49217).method_57487(class_5134.field_23723, new class_1322(field_8001, (double)attackSpeed, class_1322.class_1323.field_6328), class_9274.field_49217).method_57487(class_5134.field_47758, new class_1322(Oritech.id("pick_block_range"), (double)range, class_1322.class_1323.field_6328), class_9274.field_49217).method_57487(class_5134.field_47759, new class_1322(Oritech.id("pick_entity_range"), (double)range, class_1322.class_1323.field_6328), class_9274.field_49217).method_57486();
    }

    public void method_7851(class_1799 stack, class_1792.class_9635 context, List<class_2561> tooltip, class_1836 type) {
        super.method_7851(stack, context, tooltip, type);
        boolean area = PromethiumPickaxeItem.isAreaEnabled(stack);
        tooltip.add((class_2561)(area ? class_2561.method_43471((String)"tooltip.oritech.tool_mode.area_range.area") : class_2561.method_43471((String)"tooltip.oritech.tool_mode.area_range.single")).method_27692(class_124.field_1065));
        tooltip.add((class_2561)class_2561.method_43471((String)"tooltip.oritech.promethium_pick").method_27692(class_124.field_1063));
    }

    public void createGeoRenderer(Consumer<GeoRenderProvider> consumer) {
        consumer.accept(new GeoRenderProvider(this){
            private PromethiumToolRenderer renderer;

            @Nullable
            public class_756 getGeoItemRenderer() {
                if (this.renderer == null) {
                    this.renderer = new PromethiumToolRenderer("promethium_pickaxe");
                }
                return this.renderer;
            }
        });
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController((GeoAnimatable)this, "Pickaxe", 5, state -> PlayState.CONTINUE).triggerableAnim("silk", SILK_ANIM).triggerableAnim("area", AREA_ANIM));
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public void onHeldTick(class_1799 stack, class_1657 player, class_638 world) {
        if (world.method_8510() % 20L != 0L) {
            return;
        }
        boolean area = PromethiumPickaxeItem.isAreaEnabled(stack);
        this.triggerAnim((class_1297)player, GeoItem.getId((class_1799)stack), "Pickaxe", area ? "area" : "silk");
    }
}

