/*
 * Decompiled with CFR 0.152.
 */
package rearth.oritech.block.entity.processing;

import dev.architectury.fluid.FluidStack;
import dev.architectury.hooks.fluid.FluidStackHooks;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_3545;
import net.minecraft.class_3917;
import net.minecraft.class_3956;
import net.minecraft.class_7225;
import net.minecraft.class_8786;
import org.jetbrains.annotations.Nullable;
import rearth.oritech.Oritech;
import rearth.oritech.api.fluid.FluidApi;
import rearth.oritech.api.fluid.containers.SimpleFluidStorage;
import rearth.oritech.api.fluid.containers.SimpleInOutFluidStorage;
import rearth.oritech.api.networking.NetworkedBlockEntity;
import rearth.oritech.api.networking.SyncField;
import rearth.oritech.api.networking.SyncType;
import rearth.oritech.block.base.entity.MultiblockMachineEntity;
import rearth.oritech.block.entity.processing.CentrifugeBlockEntity;
import rearth.oritech.block.entity.processing.RefineryModuleBlockEntity;
import rearth.oritech.client.init.ModScreens;
import rearth.oritech.client.init.ParticleContent;
import rearth.oritech.client.ui.RefineryScreenHandler;
import rearth.oritech.init.BlockEntitiesContent;
import rearth.oritech.init.recipes.OritechRecipe;
import rearth.oritech.init.recipes.OritechRecipeType;
import rearth.oritech.init.recipes.RecipeContent;
import rearth.oritech.util.ColorableMachine;
import rearth.oritech.util.Geometry;
import rearth.oritech.util.InventorySlotAssignment;
import rearth.oritech.util.ScreenProvider;

public class RefineryBlockEntity
extends MultiblockMachineEntity
implements FluidApi.BlockProvider {
    @SyncField(value={SyncType.GUI_TICK, SyncType.SPARSE_TICK, SyncType.INITIAL})
    public final SimpleInOutFluidStorage ownStorage = new SimpleInOutFluidStorage(64L * FluidStackHooks.bucketAmount(), this::method_5431);
    @SyncField(value={SyncType.GUI_TICK, SyncType.SPARSE_TICK, SyncType.INITIAL})
    public final SimpleFluidStorage nodeA = new SimpleFluidStorage(4L * FluidStackHooks.bucketAmount(), this::method_5431);
    @SyncField(value={SyncType.GUI_TICK, SyncType.SPARSE_TICK, SyncType.INITIAL})
    public final SimpleFluidStorage nodeB = new SimpleFluidStorage(4L * FluidStackHooks.bucketAmount(), this::method_5431);
    @SyncField(value={SyncType.GUI_OPEN})
    private int moduleCount;

    public RefineryBlockEntity(class_2338 pos, class_2680 state) {
        super(BlockEntitiesContent.REFINERY_ENTITY, pos, state, Oritech.CONFIG.processingMachines.refineryData.energyPerTick());
    }

    @Override
    public void serverTick(class_1937 world, class_2338 pos, class_2680 state, NetworkedBlockEntity blockEntity) {
        super.serverTick(world, pos, state, blockEntity);
        if (world.method_8510() % 25L == 0L) {
            this.refreshModules();
        }
    }

    @Override
    protected void method_11007(class_2487 nbt, class_7225.class_7874 registryLookup) {
        super.method_11007(nbt, registryLookup);
        this.ownStorage.writeNbt(nbt, "main");
        this.nodeA.writeNbt(nbt, "a");
        this.nodeB.writeNbt(nbt, "b");
    }

    @Override
    protected void method_11014(class_2487 nbt, class_7225.class_7874 registryLookup) {
        super.method_11014(nbt, registryLookup);
        this.ownStorage.readNbt(nbt, "main");
        this.nodeA.readNbt(nbt, "a");
        this.nodeB.readNbt(nbt, "b");
    }

    private void refreshModules() {
        class_2338 candidatePos;
        Optional candidate;
        this.moduleCount = 0;
        class_2338 startPos = this.field_11867.method_10086(2);
        for (int i = 0; i <= 1 && !(candidate = this.field_11863.method_35230(candidatePos = startPos.method_10069(0, i, 0), BlockEntitiesContent.REFINERY_MODULE_ENTITY)).isEmpty() && ((RefineryModuleBlockEntity)candidate.get()).isActive(((RefineryModuleBlockEntity)candidate.get()).method_11010()); ++i) {
            ++this.moduleCount;
            ((RefineryModuleBlockEntity)candidate.get()).setOwningRefinery(this);
        }
    }

    public int getModuleCount() {
        return this.moduleCount;
    }

    @Override
    protected Optional<class_8786<OritechRecipe>> getRecipe() {
        List candidates = Objects.requireNonNull(this.field_11863).method_8433().method_17877((class_3956)this.getOwnRecipeType(), this.getInputInventory(), this.field_11863);
        Optional<class_8786<OritechRecipe>> fluidRecipe = candidates.stream().filter(candidate -> CentrifugeBlockEntity.recipeInputMatchesTank(this.ownStorage.getInputContainer().getStack(), (OritechRecipe)candidate.comp_1933())).sorted(Comparator.comparingInt(a -> -((OritechRecipe)a.comp_1933()).getInputs().size())).findAny();
        if (fluidRecipe.isPresent()) {
            return fluidRecipe;
        }
        return Optional.empty();
    }

    @Override
    protected void craftItem(OritechRecipe activeRecipe, List<class_1799> outputInventory, List<class_1799> inputInventory) {
        super.craftItem(activeRecipe, outputInventory, inputInventory);
        this.craftFluids(activeRecipe);
    }

    @Override
    public List<class_1799> getCraftingResults(OritechRecipe activeRecipe) {
        List<class_1799> results = activeRecipe.getResults();
        if (results.isEmpty()) {
            return List.of();
        }
        return List.of(results.getFirst().method_46651(results.getFirst().method_7947() * this.getItemOutputMultiplier(activeRecipe)));
    }

    private void craftFluids(OritechRecipe activeRecipe) {
        this.ownStorage.getInputContainer().extract(this.ownStorage.getInputContainer().getStack().copyWithAmount(activeRecipe.getFluidInput().amount()), false);
        List<FluidStack> outputs = this.calculateOutputFluids(activeRecipe);
        for (int i = 0; i < outputs.size(); ++i) {
            FluidStack output = outputs.get(i);
            FluidApi.SingleSlotStorage outputTank = this.getOutputStorage(i);
            outputTank.insert(output, false);
        }
    }

    private List<FluidStack> calculateOutputFluids(OritechRecipe recipe) {
        if (recipe.getFluidOutputs().isEmpty()) {
            return List.of();
        }
        FluidStack outA = recipe.getFluidOutputs().get(0);
        if (recipe.getFluidOutputs().size() == 1) {
            return List.of(outA);
        }
        FluidStack outB = recipe.getFluidOutputs().get(1);
        return switch (this.moduleCount) {
            case 0 -> List.of(outA.copyWithAmount(outA.getAmount() * 2L));
            case 1 -> List.of(outA, outB.copyWithAmount(outB.getAmount() * 2L));
            case 2 -> recipe.getFluidOutputs();
            default -> throw new IllegalStateException("more than 2 modules is not supported/allowed");
        };
    }

    private int getItemOutputMultiplier(OritechRecipe recipe) {
        if (recipe.getFluidOutputs().size() <= 1) {
            return 1;
        }
        return this.getModuleCount() == 0 ? 2 : 1;
    }

    @Override
    public boolean canOutputRecipe(OritechRecipe recipe) {
        List<FluidStack> fluidOutputs = this.calculateOutputFluids(recipe);
        for (int i = 0; i <= this.moduleCount && i < fluidOutputs.size(); ++i) {
            FluidApi.SingleSlotStorage storage;
            long inserted;
            FluidStack fluidOutput = fluidOutputs.get(i);
            if (fluidOutput == null || fluidOutput.isEmpty() || (inserted = (storage = this.getOutputStorage(i)).insert(fluidOutput, true)) == fluidOutput.getAmount()) continue;
            return false;
        }
        return super.canOutputRecipe(recipe);
    }

    @Override
    @Nullable
    public class_1703 createMenu(int syncId, class_1661 playerInventory, class_1657 player) {
        return new RefineryScreenHandler(syncId, playerInventory, this);
    }

    @Override
    public ScreenProvider.BarConfiguration getFluidConfiguration() {
        return new ScreenProvider.BarConfiguration(28, 6, 21, 74);
    }

    @Override
    public long getDefaultCapacity() {
        return Oritech.CONFIG.processingMachines.refineryData.energyCapacity();
    }

    @Override
    public long getDefaultInsertRate() {
        return Oritech.CONFIG.processingMachines.refineryData.maxEnergyInsertion();
    }

    @Override
    protected OritechRecipeType getOwnRecipeType() {
        return RecipeContent.REFINERY;
    }

    @Override
    protected void useEnergy() {
        super.useEnergy();
        if ((double)this.field_11863.field_9229.method_43057() > 0.8) {
            return;
        }
        class_2350 facing = this.getFacing();
        class_243 offsetLocal = Geometry.rotatePosition(new class_243(0.3, 0.5, 0.3), facing);
        class_243 emitPosition = class_243.method_24953((class_2382)this.field_11867).method_1019(offsetLocal);
        ParticleContent.COOLER_WORKING.spawn(this.field_11863, emitPosition, (Object)1);
    }

    @Override
    public InventorySlotAssignment getSlotAssignments() {
        return new InventorySlotAssignment(0, 1, 1, 1);
    }

    @Override
    public List<ScreenProvider.GuiSlot> getGuiSlots() {
        return List.of(new ScreenProvider.GuiSlot(0, 62, 8), new ScreenProvider.GuiSlot(1, 62, 61, true));
    }

    @Override
    public class_3917<?> getScreenHandlerType() {
        return ModScreens.REFINERY_SCREEN;
    }

    @Override
    public int getInventorySize() {
        return 2;
    }

    @Override
    public boolean inputOptionsEnabled() {
        return false;
    }

    @Override
    public List<class_2382> getCorePositions() {
        return List.of(new class_2382(0, 1, 0), new class_2382(0, 0, -1), new class_2382(0, 1, -1), new class_2382(1, 0, -1), new class_2382(1, 1, -1), new class_2382(1, 0, 0), new class_2382(1, 1, 0), new class_2382(2, 0, -1), new class_2382(2, 1, -1));
    }

    @Override
    public ScreenProvider.ArrowConfiguration getIndicatorConfiguration() {
        return new ScreenProvider.ArrowConfiguration(Oritech.id("textures/gui/modular/arrow_empty.png"), Oritech.id("textures/gui/modular/arrow_full.png"), 54, 35, 29, 16, true);
    }

    @Override
    public List<class_2382> getAddonSlots() {
        return List.of();
    }

    @Override
    public FluidApi.FluidStorage getFluidStorage(@Nullable class_2350 direction) {
        return this.ownStorage;
    }

    public FluidApi.FluidStorage getFluidStorageForModule(class_2338 modulePos) {
        int yDist = modulePos.method_10264() - this.field_11867.method_10264();
        if (yDist == 2) {
            return this.nodeA;
        }
        if (yDist == 3) {
            return this.nodeB;
        }
        throw new IllegalStateException("Module needs to be either 1 or 2 blocks above");
    }

    @Override
    public List<class_3545<class_2561, class_2561>> getExtraExtensionLabels() {
        return List.of(new class_3545((Object)class_2561.method_43470((String)("\ud83d\udce6: " + this.moduleCount)), (Object)class_2561.method_43471((String)"tooltip.oritech.refinery_module_count")));
    }

    public FluidApi.SingleSlotStorage getOutputStorage(int i) {
        if (i == 0) {
            return this.ownStorage.getOutputContainer();
        }
        if (i == 1) {
            return this.nodeA;
        }
        if (i == 2) {
            return this.nodeB;
        }
        throw new IllegalArgumentException("Only has 2 storage modules, tried accessing: " + i);
    }

    @Override
    public ColorableMachine.ColorVariant getDefaultColor() {
        return ColorableMachine.ColorVariant.FLUXITE;
    }
}

