package rearth.oritech.item;

import org.jetbrains.annotations.Nullable;
import rearth.oritech.Oritech;
import rearth.oritech.block.entity.storage.UnstableContainerBlockEntity;
import rearth.oritech.client.init.ParticleContent;
import rearth.oritech.init.BlockContent;
import rearth.oritech.init.BlockEntitiesContent;
import rearth.oritech.init.TagContent;
import software.bernie.geckolib.animatable.GeoItem;
import software.bernie.geckolib.animatable.client.GeoRenderProvider;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.model.DefaultedBlockGeoModel;
import software.bernie.geckolib.renderer.GeoItemRenderer;
import software.bernie.geckolib.util.GeckoLibUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.class_124;
import net.minecraft.class_1269;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1838;
import net.minecraft.class_2248;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_437;
import net.minecraft.class_5250;
import net.minecraft.class_6862;
import net.minecraft.class_756;
import net.minecraft.class_7923;

public class UnstableContainerItem extends class_1792 implements GeoItem {
    private final AnimatableInstanceCache geoCache = GeckoLibUtil.createInstanceCache(this);
    private final float scale;
    private final String name;
    
    public UnstableContainerItem(class_1793 settings, float scale, String name) {
        super(settings);
        this.scale = scale;
        this.name = name;
    }
    
    @Override
    public void createGeoRenderer(Consumer<GeoRenderProvider> consumer) {
        
        consumer.accept(new GeoRenderProvider() {
            GeoItemRenderer<UnstableContainerItem> renderer = null;
            
            @Override
            public @Nullable class_756 getGeoItemRenderer() {
                if (this.renderer == null)
                    this.renderer = new GeoItemRenderer<>(new DefaultedBlockGeoModel<>(Oritech.id("models/" + name)));
                
                this.renderer.withScale(scale);
                
                return this.renderer;
            }
        });
    }
    
    @Override
    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
    
    }
    
    @Override
    public void method_7851(class_1799 stack, class_9635 context, List<class_2561> tooltip, class_1836 type) {
        
        var shiftPressed = class_437.method_25442();
        var ctrlPressed = class_437.method_25441();
        
        if (shiftPressed) {
            tooltip.add(class_2561.method_43471("tooltip.oritech.unstable_container.low").method_27692(class_124.field_1064));
            tooltip.addAll(getBlocksFromTag(TagContent.UNSTABLE_CONTAINER_SOURCES_LOW));
            tooltip.add(class_2561.method_43471("tooltip.oritech.unstable_container.medium").method_27692(class_124.field_1064));
            tooltip.addAll(getBlocksFromTag(TagContent.UNSTABLE_CONTAINER_SOURCES_MEDIUM));
            tooltip.add(class_2561.method_43471("tooltip.oritech.unstable_container.high").method_27692(class_124.field_1064));
            tooltip.addAll(getBlocksFromTag(TagContent.UNSTABLE_CONTAINER_SOURCES_HIGH));
        } else {
            tooltip.add(class_2561.method_43471("tooltip.oritech.unstable_container_extra_info").method_27692(class_124.field_1064).method_27692(class_124.field_1056));
        }
        
        if (ctrlPressed) {
            tooltip.add(class_2561.method_43471("tooltip.oritech.unstable_container.1").method_27692(class_124.field_1080));
            tooltip.add(class_2561.method_43471("tooltip.oritech.unstable_container.2").method_27692(class_124.field_1080));
            tooltip.add(class_2561.method_43471("tooltip.oritech.unstable_container.3").method_27692(class_124.field_1080));
            tooltip.add(class_2561.method_43471("tooltip.oritech.unstable_container.4").method_27692(class_124.field_1080));
            tooltip.add(class_2561.method_43471("tooltip.oritech.unstable_container.5").method_27692(class_124.field_1080));
        } else {
            tooltip.add(class_2561.method_43471("tooltip.oritech.item_extra_info").method_27692(class_124.field_1080).method_27692(class_124.field_1056));
        }
        super.method_7851(stack, context, tooltip, type);
        
    }
    
    @Override
    public class_1269 method_7884(class_1838 context) {
        
        var targetBlockPos = context.method_8037();
        var targetBlockState = context.method_8045().method_8320(targetBlockPos);
        
        var targetMultiplier = -1f;
        if (targetBlockState.method_26164(TagContent.UNSTABLE_CONTAINER_SOURCES_LOW)) {
            targetMultiplier = 0.3f;
        } else if (targetBlockState.method_26164(TagContent.UNSTABLE_CONTAINER_SOURCES_MEDIUM)) {
            targetMultiplier = 1f;
        } else if (targetBlockState.method_26164(TagContent.UNSTABLE_CONTAINER_SOURCES_HIGH)) {
            targetMultiplier = 5f;
        }
        
        for (var offset : UnstableContainerBlockEntity.getCoreOffsets()) {
            // the block is symetrical, so directions don't matter here
            var worldPos = targetBlockPos.method_10081(offset);
            var candidateState = context.method_8045().method_8320(worldPos);
            if (!candidateState.method_45474() && !offset.equals(new class_2382(0, -1, 0))) {   // ignore below block for dragon egg support blocks
                context.method_8036().method_43496(class_2561.method_43471("text.oritech.unstable_container_blocked"));
                ParticleContent.HIGHLIGHT_BLOCK.spawn(context.method_8045(), class_243.method_24954(worldPos));
                return class_1269.field_5814;
            }
        }
        
        if (targetMultiplier > 0) {
            context.method_8045().method_8501(targetBlockPos, BlockContent.UNSTABLE_CONTAINER.method_9564());
            var createdBlockState = context.method_8045().method_8320(targetBlockPos);
            createdBlockState.method_26204().method_9567(context.method_8045(), targetBlockPos, createdBlockState, context.method_8036(), context.method_8041());
            var createdEntity = context.method_8045().method_35230(targetBlockPos, BlockEntitiesContent.UNSTABLE_CONTAINER_BLOCK_ENTITY).get();
            createdEntity.setCapturedBlock(targetBlockState);
            createdEntity.qualityMultiplier = targetMultiplier;
            
            var player = context.method_8036();
            if (!player.method_7337()) {
                var stack = context.method_8041();
                stack.method_7934(1);
            }
            return class_1269.field_21466;
        }
        
        return super.method_7884(context);
    }
    
    @Override
    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return geoCache;
    }
    
    public static List<class_5250> getBlocksFromTag(class_6862<class_2248> tagKey) {
        
        var candidate = class_7923.field_41175.method_40266(tagKey);
        //noinspection OptionalIsPresent
        if (candidate.isEmpty()) return new ArrayList<>();
        
        return candidate.get().method_40239().map(blockRegistryEntry -> blockRegistryEntry.comp_349().method_9518().method_27695(class_124.field_1080, class_124.field_1056)).toList();
    }
}
