package rearth.oritech.client.ui;

import io.wispforest.owo.ui.component.Components;
import io.wispforest.owo.ui.component.LabelComponent;
import io.wispforest.owo.ui.container.FlowLayout;
import io.wispforest.owo.ui.core.PositionedRectangle;
import io.wispforest.owo.ui.core.Positioning;
import net.minecraft.class_124;
import net.minecraft.class_1661;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_5250;
import org.jetbrains.annotations.NotNull;
import rearth.oritech.Oritech;

public class CatalystScreen extends BasicMachineScreen<CatalystScreenHandler> {
    
    public static final class_2960 GUI_COMPONENTS = Oritech.id("textures/gui/modular/machine_gui_components_souls.png");
    public static final class_2960 BOOK_SLOT = Oritech.id("textures/gui/modular/book_slot_background.png");
    
    private LabelComponent costLabel;
    private LabelComponent stabilizationLabel;
    
    public CatalystScreen(CatalystScreenHandler handler, class_1661 inventory, class_2561 title) {
        super(handler, inventory, title);
    }
    
    @Override
    public class_2960 getGuiComponents() {
        return GUI_COMPONENTS;
    }
    
    @Override
    public boolean showExtensionPanel() {
        return false;
    }
    
    @Override
    public void fillOverlay(FlowLayout overlay) {
        super.fillOverlay(overlay);
        
        costLabel = Components.label(class_2561.method_43469("message.oritech.catalyst.cost", 0));
        stabilizationLabel = Components.label(class_2561.method_43471("title.oritech.catalyst.stable"));
        overlay.child(costLabel.positioning(Positioning.absolute(56, 58)));
        overlay.child(stabilizationLabel.positioning(Positioning.absolute(108, 39)));
        
        var slotConfig = field_2797.screenData.getGuiSlots().getFirst();
        overlay.child(Components.texture(BOOK_SLOT, 0, 0, 16, 16, 16, 16).positioning(Positioning.absolute(slotConfig.x(), slotConfig.y())));
        
    }
    
    @Override
    protected void method_37432() {
        super.method_37432();
        
        var cost = field_2797.catalyst.getDisplayedCost();
        costLabel.text(class_2561.method_43469("message.oritech.catalyst.cost", cost).method_27692(class_124.field_1074));
        
        if (cost == 0) {
            costLabel.zIndex(-5);
        } else {
            costLabel.zIndex(1);
        }
        
        var result = getStabilizationTitle();
        stabilizationLabel.text(result.method_27692(class_124.field_1074));
        
    }
    
    @NotNull
    private class_5250 getStabilizationTitle() {
        var currentSouls = field_2797.catalyst.collectedSouls;
        var baseSouls = field_2797.catalyst.baseSoulCapacity;
        var maxSouls = field_2797.catalyst.maxSouls;
        var soulBonus = maxSouls - baseSouls;
        var free = maxSouls - currentSouls;
        
        var result = class_2561.method_43471("title.oritech.catalyst.stable");
        
        if (soulBonus > 0 && currentSouls >= baseSouls) {
            if (free > 5) {
                result = class_2561.method_43471("title.oritech.catalyst.stabilized");;
            } else if (free > 0) {
                result = class_2561.method_43471("title.oritech.catalyst.semi_stable");;
            } else {
                result = class_2561.method_43471("title.oritech.catalyst.unstable");;
            }
        } else {
            if (free > 5) {
                result = class_2561.method_43471("title.oritech.catalyst.stable");;
            } else if (free > 0) {
                result = class_2561.method_43471("title.oritech.catalyst.semi_stable");;
            } else {
                result = class_2561.method_43471("title.oritech.catalyst.stable");;
            }
        }
        return result;
    }
    
    @Override
    protected void updateEnergyBar() {
        
        var capacity = field_2797.catalyst.maxSouls;
        var amount = field_2797.catalyst.collectedSouls;
        
        var fillAmount = (float) amount / capacity;
        var tooltipText = getSoulTooltip(amount, capacity);
        
        energyIndicator.tooltip(tooltipText);
        energyIndicator.visibleArea(PositionedRectangle.of(0, 96 - ((int) (96 * (fillAmount))), 24, (int) (96 * fillAmount)));
    }
    
    public class_2561 getSoulTooltip(long amount, long max) {
        return class_2561.method_43469("tooltip.oritech.spawner.collected_souls", amount, max);
    }
}
