package rearth.oritech.client.renderers;

import org.jetbrains.annotations.Nullable;
import rearth.oritech.Oritech;
import rearth.oritech.OritechClient;
import rearth.oritech.client.renderers.util.BeamRenderer;
import rearth.oritech.init.ToolsContent;
import rearth.oritech.item.tools.PortableLaserItem;
import software.bernie.geckolib.cache.object.BakedGeoModel;
import software.bernie.geckolib.renderer.GeoItemRenderer;
import software.bernie.geckolib.renderer.layer.AutoGlowingGeoLayer;

import static rearth.oritech.client.renderers.LaserArmRenderer.BEAM_TEXTURE;

import net.minecraft.class_1921;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_765;

public class PortableLaserRenderer extends GeoItemRenderer<PortableLaserItem> {
    
    public PortableLaserRenderer(String modelName) {
        super(new PortableLaserModel(Oritech.id("models/" + modelName)));
        addRenderLayer(new AutoGlowingGeoLayer<>(this));
    }
    
    @Override
    public void postRender(class_4587 matrices, PortableLaserItem animatable, BakedGeoModel model, class_4597 bufferSource, @Nullable class_4588 buffer, boolean isReRender, float partialTick, int packedLight, int packedOverlay, int colour) {
        super.postRender(matrices, animatable, model, bufferSource, buffer, isReRender, partialTick, packedLight, packedOverlay, colour);
        
        
        var client = class_310.method_1551();
        var player = client.field_1724;
        
        if (player == null) return;
        
        var heldStack = client.field_1724.method_6047();
        var world = client.field_1687;
        
        if (isReRender || !this.renderPerspective.method_29998()) return;
        
        var singleShotAge = world.method_8510() - PortableLaserItem.lastSingleShot;
        
        if (!OritechClient.laserActive && singleShotAge > 10) return;
        
        if (!heldStack.method_7909().equals(ToolsContent.PORTABLE_LASER)) return;
        if (animatable.getStoredEnergy(heldStack) < Oritech.CONFIG.portableLaserConfig.energyPerTick()) return;
        
        // at this point we know a laser is held and fired
        
        var startPos = player.method_33571();
        var lookVec = player.method_5828(0F);
        var endPos = startPos.method_1019(lookVec.method_1021(128));
        
        var hit = PortableLaserItem.getPlayerTargetRay(player);
        if (hit != null && hit.method_17783().equals(class_239.class_240.field_1333))
            endPos = hit.method_17784();
        
        var dist = (float) endPos.method_1022(startPos);
        
        matrices.method_22903();
        
        var localStart = new class_243(0, 0.05, 0);
        
        var deltaVec = new class_243(0, 0, -dist);
        
        var beamConsumer = bufferSource.getBuffer(class_1921.method_23026(BEAM_TEXTURE));
        
        float baseThickness = (float) (0.03f + Math.sin((world.method_8510() + partialTick) * 1.1f) * 0.01f);
        
        BeamRenderer.renderStraightBeam(
          matrices, beamConsumer, localStart, deltaVec,
          baseThickness * 0.3f,
          class_765.field_32767,
          LaserArmRenderer.CORE_COLOR_START,
          LaserArmRenderer.CORE_COLOR_END
        );
        
        BeamRenderer.renderStraightBeam(
          matrices, beamConsumer, localStart, deltaVec,
          baseThickness,
          class_765.field_32767,
          LaserArmRenderer.GLOW_COLOR_START,
          LaserArmRenderer.GLOW_COLOR_END
        );
        
        matrices.method_22909();
        
    }
}
