package rearth.oritech.block.entity.processing;

import org.jetbrains.annotations.Nullable;
import rearth.oritech.api.energy.EnergyApi;
import rearth.oritech.api.fluid.FluidApi;
import rearth.oritech.api.fluid.containers.DelegatingFluidStorage;
import rearth.oritech.api.item.ItemApi;
import rearth.oritech.api.networking.NetworkedBlockEntity;
import rearth.oritech.api.networking.SyncField;
import rearth.oritech.api.networking.SyncType;
import rearth.oritech.init.BlockEntitiesContent;
import rearth.oritech.util.AutoPlayingSoundKeyframeHandler;
import rearth.oritech.util.ColorableMachine;
import rearth.oritech.util.MultiblockMachineController;
import software.bernie.geckolib.animatable.GeoBlockEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.util.GeckoLibUtil;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2487;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_7225;

import static rearth.oritech.block.base.block.MultiblockMachine.ASSEMBLED;
import static rearth.oritech.block.base.entity.MachineBlockEntity.*;

public class RefineryModuleBlockEntity extends NetworkedBlockEntity implements MultiblockMachineController, FluidApi.BlockProvider, GeoBlockEntity, ColorableMachine {
    
    // multiblock
    private final ArrayList<class_2338> coreBlocksConnected = new ArrayList<>();
    private float coreQuality = 1f;
    
    @SyncField({SyncType.SPARSE_TICK, SyncType.INITIAL})
    public ColorableMachine.ColorVariant currentColor = getDefaultColor();
    
    //animation
    protected final AnimatableInstanceCache animatableInstanceCache = GeckoLibUtil.createInstanceCache(this);
    private final AnimationController<RefineryModuleBlockEntity> animationController = getAnimationController();
    
    // this field is updated by a refinery when checking for modules
    private RefineryBlockEntity owningRefinery;
    
    // fluid delegator
    private final DelegatingFluidStorage fluidStorage = new DelegatingFluidStorage(
      () -> owningRefinery.getFluidStorageForModule(field_11867),
      () -> isActive(method_11010()) && owningRefinery != null);
    
    
    public RefineryModuleBlockEntity(class_2338 pos, class_2680 state) {
        super(BlockEntitiesContent.REFINERY_MODULE_ENTITY, pos, state);
    }
    
    @Override
    protected void method_11007(class_2487 nbt, class_7225.class_7874 registryLookup) {
        super.method_11007(nbt, registryLookup);
        addMultiblockToNbt(nbt);
        addColorToNbt(nbt);
    }
    
    @Override
    protected void method_11014(class_2487 nbt, class_7225.class_7874 registryLookup) {
        super.method_11014(nbt, registryLookup);
        loadMultiblockNbtData(nbt);
        loadColorFromNbt(nbt);
    }
    
    @Override
    public ColorVariant getCurrentColor() {
        return currentColor;
    }
    
    @Override
    public void assignColor(ColorVariant color) {
        this.currentColor = color;
        
        if (this.field_11863 != null && !this.field_11863.method_8608()) {
            this.setChanged(false);
            this.sendUpdate(SyncType.SPARSE_TICK);
        }
    }
    
    @Override
    public ColorVariant getDefaultColor() {
        return ColorVariant.FLUXITE;
    }
    
    @Override
    public List<class_2382> getCorePositions() {
        return List.of(
          new class_2382(0, 0, -1),    // right
          new class_2382(1, 0, -1),    // back right
          new class_2382(1, 0, 0),    // back middle
          new class_2382(2, 0, -1),    // backer right
          new class_2382(2, 0, 0)
        );
    }
    
    @Override
    public class_2350 getFacingForMultiblock() {
        var state = method_11010();
        return state.method_11654(class_2741.field_12481);
    }
    
    @Override
    public class_2338 getPosForMultiblock() {
        return field_11867;
    }
    
    @Override
    public class_1937 getWorldForMultiblock() {
        return field_11863;
    }
    
    @Override
    public ArrayList<class_2338> getConnectedCores() {
        return coreBlocksConnected;
    }
    
    @Override
    public void setCoreQuality(float quality) {
        this.coreQuality = quality;
    }
    
    @Override
    public float getCoreQuality() {
        return coreQuality;
    }
    
    @Override
    public ItemApi.InventoryStorage getInventoryForMultiblock() {
        return null;
    }
    
    @Override
    public EnergyApi.EnergyStorage getEnergyStorageForMultiblock(class_2350 direction) {
        return null;
    }
    
    @Override
    public FluidApi.FluidStorage getFluidStorage(@Nullable class_2350 direction) {
        return fluidStorage;
    }
    
    @Override
    public void triggerSetupAnimation() {
        triggerAnim("base_controller", "setup");
    }
    
    @Override
    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(animationController);
    }
    
    @Override
    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return animatableInstanceCache;
    }
    
    private AnimationController<RefineryModuleBlockEntity> getAnimationController() {
        return new AnimationController<>(this, state -> {
            
            if (state.isCurrentAnimation(SETUP)) {
                if (state.getController().hasAnimationFinished()) {
                    state.setAndContinue(IDLE);
                } else {
                    return state.setAndContinue(SETUP);
                }
            }
            
            if (isActive(method_11010())) {
                return state.setAndContinue(IDLE);
            } else {
                return state.setAndContinue(PACKAGED);
            }
        }).setSoundKeyframeHandler(new AutoPlayingSoundKeyframeHandler<>()).triggerableAnim("setup", SETUP);
    }
    
    public boolean isActive(class_2680 state) {
        return state.method_11654(ASSEMBLED);
    }
    
    public void setOwningRefinery(RefineryBlockEntity owner) {
        this.owningRefinery = owner;
    }
    
    @Override
    public void serverTick(class_1937 world, class_2338 pos, class_2680 state, NetworkedBlockEntity blockEntity) {
    
    }
}
