package rearth.oritech.block.entity.pipes;

import rearth.oritech.Oritech;
import rearth.oritech.api.energy.EnergyApi;
import rearth.oritech.api.energy.containers.SimpleEnergyStorage;
import rearth.oritech.block.blocks.pipes.energy.EnergyPipeBlock;
import rearth.oritech.block.blocks.pipes.energy.SuperConductorBlock;
import rearth.oritech.init.BlockContent;
import rearth.oritech.init.BlockEntitiesContent;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2680;
import net.minecraft.class_7225;

public class EnergyPipeInterfaceEntity extends GenericPipeInterfaceEntity implements EnergyApi.BlockProvider {
    
    private final SimpleEnergyStorage energyStorage;
    private final boolean isSuperConductor;
    
    private List<EnergyApi.EnergyStorage> cachedTargets = List.of();
    private int cacheHash;
    
    public EnergyPipeInterfaceEntity(class_2338 pos, class_2680 state) {
        super(BlockEntitiesContent.ENERGY_PIPE_ENTITY, pos, state);
        
        isSuperConductor = state.method_26204().equals(BlockContent.SUPERCONDUCTOR_CONNECTION) || state.method_26204().equals(BlockContent.FRAMED_SUPERCONDUCTOR_CONNECTION);
        
        if (isSuperConductor) {
            energyStorage = new SimpleEnergyStorage(Oritech.CONFIG.superConductorTransferRate(), Oritech.CONFIG.superConductorTransferRate(), Oritech.CONFIG.superConductorTransferRate());
        } else {
            energyStorage = new SimpleEnergyStorage(Oritech.CONFIG.energyPipeTransferRate(), Oritech.CONFIG.energyPipeTransferRate(), Oritech.CONFIG.energyPipeTransferRate());
        }
        
    }
    
    @Override
    protected void method_11007(class_2487 nbt, class_7225.class_7874 registryLookup) {
        super.method_11007(nbt, registryLookup);
        nbt.method_10544("energy", energyStorage.getAmount());
    }
    
    @Override
    protected void method_11014(class_2487 nbt, class_7225.class_7874 registryLookup) {
        super.method_11014(nbt, registryLookup);
        energyStorage.setAmount(nbt.method_10537("energy"));
    }
    
    @Override
    public EnergyApi.EnergyStorage getEnergyStorage(class_2350 direction) {
        return energyStorage;
    }
    
    @Override
    public void tick(class_1937 world, class_2338 pos, class_2680 state, GenericPipeInterfaceEntity blockEntity) {
        // if energy is available
        // gather all connection targets supporting insertion
        // shuffle em
        // insert until no more energy is available
        
        if (world.field_9236 || energyStorage.getAmount() <= 0) return;
        
        var dataSource = isSuperConductor ? SuperConductorBlock.SUPERCONDUCTOR_DATA : EnergyPipeBlock.ENERGY_PIPE_DATA;
        
        var data = dataSource.getOrDefault(world.method_27983().method_29177(), new PipeNetworkData());
        var targets = findNetworkTargets(pos, data);
        
        if (targets == null) return;    // this should never happen
        
        var targetHash = targets.hashCode();
        
        List<EnergyApi.EnergyStorage> energyStorages;
        
        if (this.cacheHash == targetHash) {
            energyStorages = this.cachedTargets;
        } else {
            energyStorages = targets.stream()
                               .map(target -> EnergyApi.BLOCK.find(world, target.method_15442(), target.method_15441()))
                               .filter(obj -> Objects.nonNull(obj) && obj.supportsInsertion())
                               .collect(Collectors.toList());
            this.cachedTargets = energyStorages;
            this.cacheHash = targetHash;
        }
        
        Collections.shuffle(energyStorages);
        
        for (var targetStorage : energyStorages) {
            if (energyStorage.getAmount() <= 0) break;
            EnergyApi.transfer(energyStorage, targetStorage, Long.MAX_VALUE, false);
        }
        
    }
    
    @Override
    public void method_5431() {
        if (this.field_11863 != null)
            field_11863.method_8524(field_11867);
    }
}
