package rearth.oritech.block.entity.generators;

import rearth.oritech.Oritech;
import rearth.oritech.block.base.entity.MultiblockGeneratorBlockEntity;
import rearth.oritech.client.init.ModScreens;
import rearth.oritech.init.BlockEntitiesContent;
import rearth.oritech.init.recipes.OritechRecipeType;
import rearth.oritech.init.recipes.RecipeContent;
import rearth.oritech.util.InventorySlotAssignment;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2680;
import net.minecraft.class_3545;
import net.minecraft.class_3917;

public class BioGeneratorEntity extends MultiblockGeneratorBlockEntity {
    public BioGeneratorEntity(class_2338 pos, class_2680 state) {
        super(BlockEntitiesContent.BIO_GENERATOR_ENTITY, pos, state, Oritech.CONFIG.generators.bioGeneratorData.energyPerTick());
    }
    
    @Override
    protected Set<class_3545<class_2338, class_2350>> getOutputTargets(class_2338 pos, class_1937 world) {
        
        var res = new HashSet<class_3545<class_2338, class_2350>>();
        res.add(new class_3545<>(pos.method_10086(2), class_2350.field_11033));
        res.add(new class_3545<>(pos.method_10074(), class_2350.field_11033));
        res.add(new class_3545<>(pos.method_10078(), class_2350.field_11039));
        res.add(new class_3545<>(pos.method_10078().method_10084(), class_2350.field_11039));
        res.add(new class_3545<>(pos.method_10072(), class_2350.field_11043));
        res.add(new class_3545<>(pos.method_10072().method_10084(), class_2350.field_11043));
        res.add(new class_3545<>(pos.method_10067(), class_2350.field_11034));
        res.add(new class_3545<>(pos.method_10067().method_10084(), class_2350.field_11034));
        res.add(new class_3545<>(pos.method_10095(), class_2350.field_11035));
        res.add(new class_3545<>(pos.method_10095().method_10084(), class_2350.field_11035));
        
        return res;
        
    }
    
    @Override
    protected OritechRecipeType getOwnRecipeType() {
        return RecipeContent.BIO_GENERATOR;
    }
    
    @Override
    public InventorySlotAssignment getSlotAssignments() {
        return new InventorySlotAssignment(0, 1, 1, 0);
    }
    
    @Override
    public List<GuiSlot> getGuiSlots() {
        return List.of(
          new GuiSlot(0, 80, 21));
    }
    
    @Override
    public class_3917<?> getScreenHandlerType() {
        return ModScreens.BIO_GENERATOR_SCREEN;
    }
    
    @Override
    public int getInventorySize() {
        return 1;
    }
    
    @Override
    public List<class_2382> getAddonSlots() {
        
        return List.of(
          new class_2382(1, 0, 0),
          new class_2382(1, 1, 0)
        );
    }
    
    @Override
    public long getDefaultExtractionRate() {
        return Oritech.CONFIG.generators.bioGeneratorData.maxEnergyExtraction();
    }
    
    @Override
    public long getDefaultCapacity() {
        return Oritech.CONFIG.generators.bioGeneratorData.energyCapacity();
    }
    
    @Override
    public List<class_2382> getCorePositions() {
        return List.of(
          new class_2382(0, 1, 0)
        );
    }
}
