package rearth.oritech.block.blocks.augmenter;

import com.mojang.serialization.MapCodec;
import dev.architectury.registry.menu.ExtendedMenuProvider;
import dev.architectury.registry.menu.MenuRegistry;
import org.jetbrains.annotations.Nullable;
import rearth.oritech.OritechClient;
import rearth.oritech.block.entity.augmenter.AugmentApplicationEntity;
import rearth.oritech.client.ui.PlayerModifierScreenHandler;

import rearth.oritech.util.Geometry;

import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import net.minecraft.class_124;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1750;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2343;
import net.minecraft.class_2350;
import net.minecraft.class_2383;
import net.minecraft.class_243;
import net.minecraft.class_2464;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_259;
import net.minecraft.class_2591;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2738;
import net.minecraft.class_2741;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3545;
import net.minecraft.class_3726;
import net.minecraft.class_3965;
import net.minecraft.class_5558;

import static rearth.oritech.block.base.block.MultiblockMachine.ASSEMBLED;
import static rearth.oritech.util.TooltipHelper.addMachineTooltip;


public class AugmentApplicationBlock extends class_2383 implements class_2343 {
    
    private final class_265[] HITBOXES = computeShapes();
    private final HashMap<class_1657, Long> lastContact = new HashMap<>();
    
    public static class_3545<Long, class_1657> lastTeleportedPlayer;    // used to skip inv opening if a player just teleported in
    
    public AugmentApplicationBlock(class_2251 settings) {
        super(settings);
        method_9590(method_9564().method_11657(class_2741.field_12481, class_2350.field_11043).method_11657(ASSEMBLED, false));
    }
    
    @Override
    protected class_265 method_9530(class_2680 state, class_1922 world, class_2338 pos, class_3726 context) {
        
        if (!state.method_11654(ASSEMBLED)) {
            return super.method_9530(state, world, pos, context);
        }
        
        var facing = state.method_11654(class_2741.field_12481);
        return HITBOXES[facing.ordinal()];
    }
    
    @Override
    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(class_2741.field_12481, ASSEMBLED);
    }
    
    private class_265[] computeShapes() {
        
        var result = new class_265[6];
        
        for (var facing : class_2741.field_12481.method_11898()) {
            
            result[facing.ordinal()] = class_259.method_1084(
              Geometry.rotateVoxelShape(class_259.method_1081(0, 0, 0, 1, 2 / 16f, 1), facing, class_2738.field_12475),
              Geometry.rotateVoxelShape(class_259.method_1081(0, 3 / 16f, 14 / 16f, 1f, 1f, 1f), facing, class_2738.field_12475)
            );
        }
        
        return result;
        
    }
    
    @Nullable
    @Override
    public class_2680 method_9605(class_1750 ctx) {
        return Objects.requireNonNull(super.method_9605(ctx)).method_11657(class_2741.field_12481, ctx.method_8042().method_10153());
    }
    
    @Override
    protected class_2464 method_9604(class_2680 state) {
        return class_2464.field_11456;
    }
    
    @Override
    protected MapCodec<? extends class_2383> method_53969() {
        return null;
    }
    
    @Override
    protected void method_9548(class_2680 state, class_1937 world, class_2338 pos, class_1297 entity) {
        
        if (world.field_9236 || !state.method_11654(ASSEMBLED)) return;
        
        if (!(entity instanceof class_1657 player)) return;
        
        if (lastTeleportedPlayer != null) {
            var age = world.method_8510() - lastTeleportedPlayer.method_15442();
            if (age < 20) {
                return;
            }
        }
        
        var centerPos = pos.method_61082().method_1031(0, 0.2, 0);
        
        var dist = entity.method_19538().method_1022(centerPos);
        
        if (dist < 0.45) {
            
            var ageWithoutContact = world.method_8510() - lastContact.getOrDefault(player, 0L);
            
            var time = world.method_8510();
            lastContact.put(player, time);
            
            if (ageWithoutContact > 15) {
                var locked = lockPlayer(player, centerPos, state);
                if (locked) {
                    var blockEntity = (AugmentApplicationEntity) world.method_8321(pos);
                    blockEntity.loadAvailableStations(player);
                    
                    var handler = (ExtendedMenuProvider) world.method_8321(pos);
                    MenuRegistry.openExtendedMenu((class_3222) player, handler);
                }
            }
        }
        
    }
    
    private boolean lockPlayer(class_1657 player, class_243 lockPos, class_2680 state) {
        
        var maxVelocity = Math.max(Math.max(Math.abs(player.method_18798().field_1352), Math.abs(player.method_18798().field_1351)), Math.abs(player.method_18798().field_1350));
        
        if (maxVelocity < 0.01 || player.field_7512 instanceof PlayerModifierScreenHandler) return false;
        
        player.method_37908().method_45447(null, player.method_24515(), class_3417.field_14675, class_3419.field_15245);
        
        var facing = state.method_11654(class_2741.field_12481);
        var rotation = switch (facing) {
            case field_11043 -> 180;
            case field_11039 -> 90;
            case field_11034 -> -90;
            default -> 0;
        };
        player.method_18799(class_243.field_1353);
        player.method_48105((class_3218) player.method_37908(), lockPos.field_1352, lockPos.field_1351, lockPos.field_1350, Set.of(), rotation, 0);
        
        var dist = player.method_19538().method_1022(lockPos);
        
        return dist < 0.1;
    }
    
    @Override
    public class_1269 method_55766(class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_3965 hit) {
        
        if (world.field_9236)
            return class_1269.field_5812;
        
        var entity = world.method_8321(pos);
        if (!(entity instanceof AugmentApplicationEntity modifierEntity)) {
            return class_1269.field_5812;
        }
        
        var wasAssembled = state.method_11654(ASSEMBLED);
        
        if (!wasAssembled) {
            var corePlaced = modifierEntity.tryPlaceNextCore(player);
            if (corePlaced) return class_1269.field_5812;
        }
        
        var isAssembled = modifierEntity.initMultiblock(state);
        
        // first time created
        if (isAssembled && !wasAssembled) {
            modifierEntity.triggerSetupAnimation();
            return class_1269.field_5812;
        }
        
        if (!isAssembled) {
            player.method_43496(class_2561.method_43471("message.oritech.machine.missing_core"));
            return class_1269.field_5812;
        }
        
        var blockEntity = (AugmentApplicationEntity) world.method_8321(pos);
        blockEntity.loadAvailableStations(player);
        
        var handler = (ExtendedMenuProvider) world.method_8321(pos);
        MenuRegistry.openExtendedMenu((class_3222) player, handler);
        
        return class_1269.field_5812;
    }
    
    @Override
    public class_2680 method_9576(class_1937 world, class_2338 pos, class_2680 state, class_1657 player) {
        
        if (!world.method_8608()) {
            
            var entity = world.method_8321(pos);
            
            if (entity instanceof AugmentApplicationEntity storageBlock) {
                storageBlock.onControllerBroken();
                var stacks = storageBlock.inventory.heldStacks;
                for (var heldStack : stacks) {
                    if (!heldStack.method_7960()) {
                        var itemEntity = new class_1542(world, pos.method_10263(), pos.method_10264(), pos.method_10260(), heldStack);
                        world.method_8649(itemEntity);
                    }
                }
                
                storageBlock.inventory.heldStacks.clear();
                storageBlock.inventory.method_5431();
            }
        }
        
        return super.method_9576(world, pos, state, player);
    }
    
    @Nullable
    @Override
    public class_2586 method_10123(class_2338 pos, class_2680 state) {
        return new AugmentApplicationEntity(pos, state);
    }
    
    @Nullable
    @Override
    public <T extends class_2586> class_5558<T> method_31645(class_1937 world, class_2680 state, class_2591<T> type) {
        return (world1, pos, state1, blockEntity) -> {
            if (blockEntity instanceof class_5558 ticker)
                ticker.tick(world1, pos, state1, blockEntity);
        };
    }
    
    @Override
    public void method_9568(class_1799 stack, class_1792.class_9635 context, List<class_2561> tooltip, class_1836 options) {
        super.method_9568(stack, context, tooltip, options);
        var hotkey = OritechClient.AUGMENT_SELECTOR.field_1655.method_27445();
        tooltip.add(class_2561.method_43471("tooltip.oritech.augmenter.1").method_27692(class_124.field_1080));
        
        if (hotkey.method_54160() != null)
            tooltip.add(class_2561.method_43469("tooltip.oritech.augmenter.2", hotkey.method_54160()).method_27692(class_124.field_1080));
        addMachineTooltip(tooltip, this, this);
    }
}
