package rearth.oritech.block.blocks.accelerator;

import org.jetbrains.annotations.Nullable;
import rearth.oritech.block.entity.accelerator.AcceleratorParticleLogic;
import java.util.List;
import java.util.Objects;
import net.minecraft.class_124;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1750;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2758;
import net.minecraft.class_3726;
import net.minecraft.class_3965;
import net.minecraft.class_437;

public class AcceleratorRingBlock extends AcceleratorPassthroughBlock {
    
    public static final class_2758 BENT = class_2758.method_11867("bent", 0, 2);    // 0 = straight, 1 = left, 2 = right
    public static final class_2758 REDSTONE_STATE = class_2758.method_11867("redstone_state", 0, 3);    // 0-2 = same as bent, 3 = was never powered
    
    public AcceleratorRingBlock(class_2251 settings) {
        super(settings);
        method_9590(method_9564().method_11657(BENT, 0).method_11657(REDSTONE_STATE, 3));
    }
    
    @Override
    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        super.method_9515(builder);
        builder.method_11667(BENT, REDSTONE_STATE);
    }
    
    @Nullable
    @Override
    public class_2680 method_9605(class_1750 ctx) {
        return Objects.requireNonNull(super.method_9605(ctx)).method_11657(BENT, 0).method_11657(REDSTONE_STATE, 3);
    }
    
    @Override
    protected class_265 method_9530(class_2680 state, class_1922 world, class_2338 pos, class_3726 context) {
        return class_2248.method_9541(2, 0, 2, 14, 12, 14);
    }
    
    // allow redstone to connect
    @Override
    protected boolean method_9506(class_2680 state) {
        return true;
    }
    
    @Override
    public void method_9612(class_2680 state, class_1937 world, class_2338 pos, class_2248 sourceBlock, class_2338 sourcePos, boolean notify) {
        super.method_9612(state, world, pos, sourceBlock, sourcePos, notify);
        
        if (world.field_9236) return;
        
        var isPowered = world.method_49803(pos);
        var lastRedstone = state.method_11654(REDSTONE_STATE);
        var lastBent = state.method_11654(BENT);
        
        // straight pipes don't react to redstone
        if (lastBent == 0 && lastRedstone == 3) return;
        
        // on new redstone signal (redstone stored is not bent)
        if (isPowered && (lastRedstone == 0 || lastRedstone == 3)) {
            // store bent state and set straight
            world.method_30092(pos, state.method_11657(REDSTONE_STATE, lastBent).method_11657(BENT, 0), class_2248.field_31028, 1);
            AcceleratorParticleLogic.resetCachedGate(pos);
        } else if (!isPowered && lastRedstone != 3 && lastRedstone != 0) {   // on redstone disabled
            // set bent to lastbent, set redstone to straight
            world.method_30092(pos, state.method_11657(REDSTONE_STATE, 0).method_11657(BENT, lastRedstone), class_2248.field_31028, 1);
            AcceleratorParticleLogic.resetCachedGate(pos);
        }
        
    }
    
    @Override
    public class_1269 method_55766(class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_3965 hit) {
        
        var newBent = (state.method_11654(BENT) + 1) % 3;
        world.method_8501(pos, state.method_11657(BENT, newBent).method_11657(REDSTONE_STATE, 3));
        AcceleratorParticleLogic.resetCachedGate(pos);
        
        return class_1269.field_5812;
    }
    
    @Override
    public void method_9568(class_1799 stack, class_1792.class_9635 context, List<class_2561> tooltip, class_1836 options) {
        var showExtra = class_437.method_25441();
        if (!showExtra) {
            tooltip.add(class_2561.method_43471("tooltip.oritech.item_extra_info").method_27692(class_124.field_1080).method_27692(class_124.field_1056));
        } else {
            tooltip.add(class_2561.method_43471("tooltip.oritech.accelerator_ring").method_27692(class_124.field_1080));
        }
    }
}
