package rearth.oritech.block.base.block;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import rearth.oritech.util.MachineAddonController;
import rearth.oritech.util.MultiblockMachineController;
import java.util.function.BiConsumer;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1927;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2746;
import net.minecraft.class_3965;

public abstract class MultiblockMachine extends UpgradableMachineBlock {
    
    public static final class_2746 ASSEMBLED = class_2746.method_11825("machine_assembled");
    
    public MultiblockMachine(class_2251 settings) {
        super(settings);
        method_9590(method_9564().method_11657(ASSEMBLED, false));
    }
    
    @Override
    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        super.method_9515(builder);
        builder.method_11667(ASSEMBLED);
    }
    
    @Override
    public class_1269 method_55766(class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_3965 hit) {
        
        if (!world.field_9236) {
            
            var entity = world.method_8321(pos);
            if (!(entity instanceof MultiblockMachineController machineEntity)) {
                return class_1269.field_5812;
            }
            
            var wasAssembled = state.method_11654(ASSEMBLED);
            
            if (!wasAssembled) {
                var corePlaced = machineEntity.tryPlaceNextCore(player);
                if (corePlaced) return class_1269.field_5812;
            }
            
            var isAssembled = machineEntity.initMultiblock(state);
            
            // first time created
            if (isAssembled && !wasAssembled) {
                machineEntity.triggerSetupAnimation();
                if (entity instanceof MachineAddonController controllerEntity)
                    controllerEntity.initAddons();
                return class_1269.field_5812;
            }
            
            if (!isAssembled) {
                player.method_43496(class_2561.method_43471("message.oritech.machine.missing_core"));
                return class_1269.field_5812;
            }
            
        }
        
        return super.method_55766(state, world, pos, player, hit);
    }
    
    @Override
    public @NotNull class_2680 method_9576(class_1937 world, class_2338 pos, class_2680 state, class_1657 player) {
        resetMultiblock(state, world, pos);
        return super.method_9576(world, pos, state, player);
    }
    
    @Override
    public void method_9556(class_1937 level, class_1657 player, class_2338 pos, class_2680 state, @Nullable class_2586 blockEntity, class_1799 tool) {
        resetMultiblock(state, level, pos);
        super.method_9556(level, player, pos, state, blockEntity, tool);
    }
    
    @Override
    public void method_9585(class_1936 level, class_2338 pos, class_2680 state) {
        resetMultiblock(state, level, pos);
        super.method_9585(level, pos, state);
    }
    
    @Override
    protected void method_55124(class_2680 state, class_1937 world, class_2338 pos, class_1927 explosion, BiConsumer<class_1799, class_2338> stackMerger) {
        resetMultiblock(state, world, pos);
        super.method_55124(state, world, pos, explosion, stackMerger);
    }
    
    private void resetMultiblock(class_2680 state, class_1936 world, class_2338 pos) {
        if (!world.method_8608() && state.method_11654(ASSEMBLED)) {
            var entity = world.method_8321(pos);
            if (entity instanceof MultiblockMachineController machineEntity) {
                machineEntity.onControllerBroken();
            }
        }
    }
}
