package rearth.oritech.api.recipe;

import net.minecraft.class_2960;
import net.minecraft.class_8790;
import rearth.oritech.init.recipes.RecipeContent;

public class PulverizerRecipeBuilder extends OritechRecipeBuilder {

    protected PulverizerRecipeBuilder() {
        super(RecipeContent.PULVERIZER, "pulverizer");
        this.time = 120;
    }

    public static PulverizerRecipeBuilder build() {
        return new PulverizerRecipeBuilder();
    }

    @Override
    public void validate(class_2960 id) throws IllegalStateException {
        if ((inputs == null || inputs.isEmpty()) || (results == null || results.isEmpty()))
            throw new IllegalStateException("inputs and results required for recipe " + id + " (type " + type + ")");
    }

    @Override
    public void export(class_8790 exporter, String suffix) {
        super.export(exporter, suffix);

        if (addToGrinder)
            GrinderRecipeBuilder.build().input(inputs).result(results).export(exporter, suffix);
    }
}
