package rearth.oritech.api.fluid.containers;

import dev.architectury.fluid.FluidStack;
import rearth.oritech.api.fluid.FluidApi;

import java.util.function.Consumer;
import net.minecraft.class_1799;
import net.minecraft.class_9334;

public class SimpleItemFluidStorage extends SimpleFluidStorage {
    
    private final class_1799 itemStack;
    public Consumer<class_1799> contextCallback;
    
    public SimpleItemFluidStorage(Long capacity, class_1799 itemStack) {
        super(capacity);
        this.itemStack = itemStack;
        this.setStack(itemStack.method_57825(FluidApi.ITEM.getFluidComponent(), FluidStack.empty()));
        
        if (!this.getStack().isEmpty())
            itemStack.method_57379(class_9334.field_50071, 1);
    }
    
    @Override
    public void update() {
        super.update();
        
        if (this.getStack().isEmpty()) {
            itemStack.method_57381(FluidApi.ITEM.getFluidComponent());
            itemStack.method_57379(class_9334.field_50071, itemStack.method_7909().method_7882());
            return;
        }
        
        itemStack.method_57379(FluidApi.ITEM.getFluidComponent(), this.getStack());
        itemStack.method_57379(class_9334.field_50071, 1);
        
        if (contextCallback != null) contextCallback.accept(itemStack);
    }
    
    public SimpleItemFluidStorage withCallback(Consumer<class_1799> contextCallback) {
        this.contextCallback = contextCallback;
        return this;
    }
}
