/*
 * Decompiled with CFR 0.152.
 */
package rearth.oritech.init.compat.jei;

import dev.architectury.fluid.FluidStack;
import dev.architectury.platform.Platform;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableAnimated;
import mezz.jei.api.gui.drawable.IDrawableStatic;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1935;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_332;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import rearth.oritech.Oritech;
import rearth.oritech.block.base.entity.MachineBlockEntity;
import rearth.oritech.client.ui.BasicMachineScreen;
import rearth.oritech.init.recipes.OritechRecipe;
import rearth.oritech.init.recipes.OritechRecipeType;
import rearth.oritech.util.FluidIngredient;
import rearth.oritech.util.InventorySlotAssignment;
import rearth.oritech.util.ScreenProvider;

public class OritechJeiRecipeCategory
implements IRecipeCategory<OritechRecipe> {
    public final OritechRecipeType type;
    private final List<ScreenProvider.GuiSlot> slots;
    private final InventorySlotAssignment slotOffsets;
    public final IDrawable icon;
    public final IDrawableAnimated arrow;
    public final IDrawableStatic background;
    public final IDrawableStatic fluidBackground;
    private final ScreenProvider.ArrowConfiguration indicatorConfig;

    public OritechJeiRecipeCategory(OritechRecipeType type, Class<? extends MachineBlockEntity> screenProviderSource, class_2248 machine, IGuiHelper helper) {
        this.type = type;
        this.icon = helper.createDrawableItemStack(new class_1799((class_1935)machine.method_8389()));
        try {
            MachineBlockEntity screenProvider = screenProviderSource.getDeclaredConstructor(class_2338.class, class_2680.class).newInstance(new class_2338(0, 0, 0), machine.method_9564());
            this.slots = screenProvider.getGuiSlots();
            this.slotOffsets = screenProvider.getSlotAssignments();
            this.indicatorConfig = screenProvider.getIndicatorConfiguration();
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
        this.arrow = helper.createAnimatedRecipeArrow(40);
        this.background = helper.getSlotDrawable();
        this.fluidBackground = helper.drawableBuilder(BasicMachineScreen.GUI_COMPONENTS, 48, 0, 14, 50).setTextureSize(98, 96).build();
    }

    public OritechJeiRecipeCategory(OritechRecipeType type, class_2248 machine, IGuiHelper helper, Boolean isGenerator, List<ScreenProvider.GuiSlot> slots, InventorySlotAssignment slotOffsets) {
        this.type = type;
        this.icon = helper.createDrawableItemStack(new class_1799((class_1935)machine.method_8389()));
        this.arrow = helper.createAnimatedRecipeArrow(40);
        this.background = helper.getSlotDrawable();
        this.fluidBackground = helper.drawableBuilder(BasicMachineScreen.GUI_COMPONENTS, 48, 0, 14, 50).setTextureSize(98, 96).build();
        this.slots = slots;
        this.slotOffsets = slotOffsets;
        this.indicatorConfig = new ScreenProvider.ArrowConfiguration(Oritech.id("textures/gui/modular/arrow_empty.png"), Oritech.id("textures/gui/modular/arrow_full.png"), 80, 35, 29, 16, true);
    }

    @NotNull
    public RecipeType<OritechRecipe> getRecipeType() {
        return RecipeType.create((String)this.type.getIdentifier().method_12836(), (String)this.type.getIdentifier().method_12832(), OritechRecipe.class);
    }

    @NotNull
    public class_2561 getTitle() {
        return class_2561.method_43471((String)("emi.category.oritech." + this.type.getIdentifier().method_12832()));
    }

    @Nullable
    public IDrawable getIcon() {
        return this.icon;
    }

    public int getWidth() {
        return 150;
    }

    public int getHeight() {
        return 70;
    }

    public void draw(OritechRecipe recipe, IRecipeSlotsView recipeSlotsView, class_332 guiGraphics, double mouseX, double mouseY) {
        this.arrow.draw(guiGraphics, this.indicatorConfig.x() - 23, this.indicatorConfig.y() - 17);
        String duration = String.format("%.0f", Float.valueOf((float)recipe.getTime() / 20.0f));
        guiGraphics.method_27535(class_310.method_1551().field_1772, (class_2561)class_2561.method_43469((String)"emi.title.oritech.cookingtime", (Object[])new Object[]{duration, recipe.getTime()}), (int)((double)this.getWidth() * 0.35), (int)((double)this.getHeight() * 0.9), 0xFFFFFF);
    }

    public void setRecipe(@NotNull IRecipeLayoutBuilder builder, OritechRecipe recipe, @NotNull IFocusGroup focuses) {
        int offsetX = 23;
        int offsetY = 17;
        List<class_1856> inputs = recipe.getInputs();
        for (int i = 0; i < inputs.size(); ++i) {
            class_1856 input = inputs.get(i);
            if (input.method_8103()) continue;
            ScreenProvider.GuiSlot pos = this.slots.get(this.slotOffsets.inputStart() + i);
            int usedY = Math.clamp(2L, pos.y() - offsetY, this.getHeight() - 18 - 4);
            ((IRecipeSlotBuilder)builder.addInputSlot(pos.x() - offsetX, usedY).addIngredients(input)).setBackground((IDrawable)this.background, -1, -1);
        }
        if (recipe.getFluidInput() != null && recipe.getFluidInput().amount() > 0L) {
            FluidIngredient fluidIngredient = recipe.getFluidInput();
            long shownAmount = Math.max(1L, fluidIngredient.amount());
            if (Platform.isModLoaded((String)"jei")) {
                IRecipeSlotBuilder inputSlot = builder.addInputSlot(10, 6).setBackground((IDrawable)this.fluidBackground, -2, -2).setFluidRenderer(shownAmount, false, 10, 46);
                for (FluidStack fluidStack : fluidIngredient.getFluidStacks()) {
                    inputSlot = inputSlot.addFluidStack(fluidStack.getFluid(), shownAmount);
                }
            }
        }
        List<class_1799> outputs = recipe.getResults();
        for (int i = 0; i < outputs.size(); ++i) {
            class_1799 output = outputs.get(i);
            if (output.method_7960()) continue;
            ScreenProvider.GuiSlot pos = this.slots.get(this.slotOffsets.outputStart() + i);
            int usedY = Math.clamp(1L, pos.y() - offsetY, this.getHeight() - 18 - 4);
            ((IRecipeSlotBuilder)builder.addOutputSlot(pos.x() - offsetX, usedY).addItemStack(output)).setBackground((IDrawable)this.background, -1, -1);
        }
        int tankCount = 0;
        int tankStartX = recipe.getFluidOutputs().size() > 1 ? 80 : 120;
        for (FluidStack fluidResult : recipe.getFluidOutputs()) {
            if (fluidResult.isEmpty()) continue;
            builder.addOutputSlot(tankStartX + tankCount * 20, 6).addFluidStack(fluidResult.getFluid(), fluidResult.getAmount()).setBackground((IDrawable)this.fluidBackground, -2, -2).setFluidRenderer(fluidResult.getAmount(), false, 10, 46);
            ++tankCount;
        }
    }
}

