/*
 * Decompiled with CFR 0.152.
 */
package rearth.oritech.client.renderers;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1657;
import net.minecraft.class_1747;
import net.minecraft.class_1750;
import net.minecraft.class_1799;
import net.minecraft.class_1921;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2343;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_2586;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_310;
import net.minecraft.class_3965;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_638;
import net.minecraft.class_746;
import net.minecraft.class_761;
import net.minecraft.class_7833;
import rearth.oritech.Oritech;
import rearth.oritech.block.base.block.MultiblockMachine;
import rearth.oritech.block.blocks.augmenter.AugmentResearchStationBlock;
import rearth.oritech.block.blocks.processing.RefineryModuleBlock;
import rearth.oritech.block.blocks.storage.LargeStorageBlock;
import rearth.oritech.block.blocks.storage.SmallStorageBlock;
import rearth.oritech.init.BlockContent;
import rearth.oritech.init.ItemContent;
import rearth.oritech.init.TagContent;
import rearth.oritech.init.ToolsContent;
import rearth.oritech.item.tools.harvesting.PromethiumPickaxeItem;
import rearth.oritech.util.Geometry;
import rearth.oritech.util.MultiblockMachineController;

public class BlockOutlineRenderer {
    public static void render(class_638 world, class_4184 camera, class_4587 matrixStack, class_4597 consumer) {
        if (world == null) {
            return;
        }
        class_310 client = class_310.method_1551();
        class_746 player = client.field_1724;
        if (player == null || player.method_5715()) {
            return;
        }
        if (client.field_1765 == null || client.field_1765.method_17783() != class_239.class_240.field_1332) {
            return;
        }
        class_1799 itemStack = player.method_6047();
        class_2338 blockPos = ((class_3965)client.field_1765).method_17777();
        if (Oritech.CONFIG.showMachinePreview()) {
            BlockOutlineRenderer.renderBlockPlacementPreviewOutline(world, camera, matrixStack, consumer, itemStack, player, blockPos);
            BlockOutlineRenderer.renderParticlePlacementHelper(world, camera, matrixStack, consumer, itemStack, player, blockPos);
        }
        BlockOutlineRenderer.renderPromethiumPickaxeOutline(world, camera, matrixStack, consumer, itemStack, player, blockPos);
    }

    private static void renderBlockPlacementPreviewOutline(class_638 world, class_4184 camera, class_4587 matrixStack, class_4597 consumer, class_1799 itemStack, class_746 player, class_2338 blockPos) {
        class_2680 placementState;
        class_2586 entity;
        class_2343 entityProvider;
        class_2248 block;
        block15: {
            block14: {
                boolean hasBlockItem;
                boolean bl = hasBlockItem = itemStack.method_7909() instanceof class_1747 || itemStack.method_7909().equals(ItemContent.UNSTABLE_CONTAINER);
                if (!hasBlockItem) {
                    return;
                }
                class_2248 class_22482 = block = itemStack.method_7909() instanceof class_1747 ? ((class_1747)itemStack.method_7909()).method_7711() : BlockContent.UNSTABLE_CONTAINER;
                if (!(block instanceof class_2343)) break block14;
                entityProvider = (class_2343)block;
                if (block.method_9564().method_28498((class_2769)MultiblockMachine.ASSEMBLED)) break block15;
            }
            return;
        }
        class_2338 machinePos = blockPos.method_10081(((class_3965)player.field_3937.field_1765).method_17780().method_10163());
        if (itemStack.method_7909().equals(ItemContent.UNSTABLE_CONTAINER)) {
            machinePos = blockPos;
        }
        if (!((entity = entityProvider.method_10123(machinePos, placementState = block.method_9605(new class_1750((class_1657)player, player.field_6266, itemStack, (class_3965)player.field_3937.field_1765)))) instanceof MultiblockMachineController)) {
            return;
        }
        MultiblockMachineController multiblockController = (MultiblockMachineController)entity;
        if (itemStack.method_7909().equals(ItemContent.UNSTABLE_CONTAINER)) {
            boolean isValid;
            class_2680 blockState = world.method_8320(machinePos);
            boolean bl = isValid = blockState.method_26164(TagContent.UNSTABLE_CONTAINER_SOURCES_LOW) || blockState.method_26164(TagContent.UNSTABLE_CONTAINER_SOURCES_MEDIUM) || blockState.method_26164(TagContent.UNSTABLE_CONTAINER_SOURCES_HIGH);
            if (!isValid) {
                return;
            }
        }
        List<class_2382> coreOffsets = multiblockController.getCorePositions();
        class_2350 machineFacing = BlockOutlineRenderer.getFacingFromState(placementState);
        if (block instanceof LargeStorageBlock) {
            machineFacing = player.method_5735().method_10153();
        } else if (block instanceof AugmentResearchStationBlock) {
            machineFacing = player.method_58149();
        } else if (!(block instanceof MultiblockMachine) && !(block instanceof RefineryModuleBlock)) {
            machineFacing = machineFacing.method_10153();
        }
        ArrayList<class_2382> fullList = new ArrayList<class_2382>(coreOffsets);
        fullList.add(class_2382.field_11176);
        matrixStack.method_22903();
        class_243 cameraPos = camera.method_19326();
        matrixStack.method_22904(-cameraPos.method_10216(), -cameraPos.method_10214(), -cameraPos.method_10215());
        matrixStack.method_46416(0.005f, 0.005f, 0.005f);
        class_265 shape = class_259.method_1077();
        for (class_2382 coreOffset : fullList) {
            class_2382 fixedOffset = new class_2382(coreOffset.method_10263(), coreOffset.method_10264(), coreOffset.method_10260());
            class_2382 worldOffset = Geometry.offsetToWorldPosition(machineFacing, fixedOffset, (class_2382)machinePos);
            shape = class_259.method_1084((class_265)shape, (class_265)class_259.method_1081((double)worldOffset.method_10263(), (double)worldOffset.method_10264(), (double)worldOffset.method_10260(), (double)(worldOffset.method_10263() + 1), (double)(worldOffset.method_10264() + 1), (double)(worldOffset.method_10260() + 1)));
        }
        class_761.method_3291((class_4587)matrixStack, (class_4588)consumer.getBuffer(class_1921.method_23594()), (class_265)shape, (double)0.0, (double)0.0, (double)0.0, (float)1.0f, (float)1.0f, (float)1.0f, (float)0.7f);
        matrixStack.method_22909();
    }

    private static class_2350 getFacingFromState(class_2680 state) {
        if (state.method_28498((class_2769)class_2741.field_12481)) {
            return (class_2350)state.method_11654((class_2769)class_2741.field_12481);
        }
        if (state.method_28498((class_2769)class_2741.field_12525)) {
            return (class_2350)state.method_11654((class_2769)class_2741.field_12525);
        }
        if (state.method_28498((class_2769)SmallStorageBlock.TARGET_DIR)) {
            return (class_2350)state.method_11654((class_2769)SmallStorageBlock.TARGET_DIR);
        }
        return class_2350.field_11043;
    }

    private static void renderPromethiumPickaxeOutline(class_638 world, class_4184 camera, class_4587 matrixStack, class_4597 consumer, class_1799 itemStack, class_746 player, class_2338 blockPos) {
        if (!itemStack.method_31574(ToolsContent.PROMETHIUM_PICKAXE)) {
            return;
        }
        List<class_2338> offsetBlocks = PromethiumPickaxeItem.getOffsetBlocks((class_1937)world, (class_1657)player, blockPos);
        matrixStack.method_22903();
        class_243 cameraPos = camera.method_19326();
        matrixStack.method_22904(-cameraPos.method_10216(), -cameraPos.method_10214(), -cameraPos.method_10215());
        for (class_2338 offsetPos : offsetBlocks) {
            class_2680 offsetState = world.method_8320(offsetPos);
            class_265 renderShape = offsetState.method_26218((class_1922)world, offsetPos);
            matrixStack.method_22903();
            matrixStack.method_46416((float)offsetPos.method_10263(), (float)offsetPos.method_10264(), (float)offsetPos.method_10260());
            class_761.method_3291((class_4587)matrixStack, (class_4588)consumer.getBuffer(class_1921.method_23594()), (class_265)renderShape, (double)0.0, (double)0.0, (double)0.0, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.35f);
            matrixStack.method_22909();
        }
        matrixStack.method_22909();
    }

    private static void renderParticlePlacementHelper(class_638 world, class_4184 camera, class_4587 matrixStack, class_4597 consumer, class_1799 itemStack, class_746 player, class_2338 blockPos) {
        boolean isRing = itemStack.method_31574(BlockContent.ACCELERATOR_RING.method_8389());
        boolean isMotor = itemStack.method_31574(BlockContent.ACCELERATOR_MOTOR.method_8389());
        if (!isRing && !isMotor) {
            return;
        }
        assert (player.field_3937.field_1765 != null);
        class_2350 facing = player.method_5735();
        class_243 cameraPos = camera.method_19326();
        class_3965 blockHit = (class_3965)player.field_3937.field_1765;
        class_243 targetPos = class_243.method_24954((class_2382)blockHit.method_17777().method_10081(blockHit.method_17780().method_10163()));
        if (isMotor) {
            facing = facing.method_10170();
        }
        class_265 shape = class_259.method_1081((double)0.4375, (double)0.4375, (double)0.0, (double)0.5625, (double)0.5625, (double)1.0);
        class_265 halfShape = class_259.method_1081((double)0.25, (double)0.4375, (double)0.8, (double)0.375, (double)0.5625, (double)1.3f);
        class_265 halfShapeLeft = class_259.method_1081((double)0.5, (double)0.4375, (double)0.3, (double)0.625, (double)0.5625, (double)0.8f);
        matrixStack.method_22903();
        matrixStack.method_22904(-cameraPos.method_10216(), -cameraPos.method_10214(), -cameraPos.method_10215());
        matrixStack.method_22904(targetPos.field_1352, targetPos.field_1351, targetPos.field_1350);
        matrixStack.method_46416(0.005f, 0.005f, 0.005f);
        int rotationY = 0;
        class_243 extraOffset = class_243.field_1353;
        if (facing.equals((Object)class_2350.field_11039)) {
            rotationY = 90;
            extraOffset = new class_243(0.0, 0.0, 1.0);
        }
        if (facing.equals((Object)class_2350.field_11035)) {
            rotationY = 180;
            extraOffset = new class_243(1.0, 0.0, 1.0);
        }
        if (facing.equals((Object)class_2350.field_11034)) {
            rotationY = 270;
            extraOffset = new class_243(1.0, 0.0, 0.0);
        }
        matrixStack.method_22904(extraOffset.field_1352, extraOffset.field_1351, extraOffset.field_1350);
        matrixStack.method_22907(class_7833.field_40716.rotationDegrees((float)rotationY));
        class_761.method_3291((class_4587)matrixStack, (class_4588)consumer.getBuffer(class_1921.method_23594()), (class_265)shape, (double)0.0, (double)0.0, (double)0.0, (float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (isRing) {
            matrixStack.method_22903();
            matrixStack.method_22907(class_7833.field_40716.rotationDegrees(30.0f));
            class_761.method_3291((class_4587)matrixStack, (class_4588)consumer.getBuffer(class_1921.method_23594()), (class_265)halfShape, (double)0.0, (double)0.0, (double)0.0, (float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            matrixStack.method_22909();
            matrixStack.method_22903();
            matrixStack.method_22907(class_7833.field_40716.rotationDegrees(-30.0f));
            class_761.method_3291((class_4587)matrixStack, (class_4588)consumer.getBuffer(class_1921.method_23594()), (class_265)halfShapeLeft, (double)0.0, (double)0.0, (double)0.0, (float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            matrixStack.method_22909();
        }
        matrixStack.method_22909();
    }
}

