/*
 * Decompiled with CFR 0.152.
 */
package rearth.oritech.block.base.entity;

import dev.architectury.fluid.FluidStack;
import dev.architectury.hooks.fluid.FluidStackHooks;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_1262;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2371;
import net.minecraft.class_2487;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_3612;
import net.minecraft.class_3956;
import net.minecraft.class_7225;
import net.minecraft.class_8786;
import org.jetbrains.annotations.Nullable;
import rearth.oritech.api.fluid.FluidApi;
import rearth.oritech.api.fluid.containers.SimpleFluidStorage;
import rearth.oritech.api.networking.NetworkedBlockEntity;
import rearth.oritech.api.networking.SyncField;
import rearth.oritech.block.base.entity.MultiblockGeneratorBlockEntity;
import rearth.oritech.init.recipes.OritechRecipe;
import rearth.oritech.init.recipes.OritechRecipeType;
import rearth.oritech.util.FluidIngredient;
import rearth.oritech.util.InventorySlotAssignment;
import rearth.oritech.util.ScreenProvider;
import rearth.oritech.util.StackContext;

public abstract class FluidMultiblockGeneratorBlockEntity
extends MultiblockGeneratorBlockEntity
implements FluidApi.BlockProvider {
    @SyncField
    public final SimpleFluidStorage fluidStorage = new SimpleFluidStorage(this, 4L * FluidStackHooks.bucketAmount(), this::method_5431){

        @Override
        public long insert(FluidStack toInsert, boolean simulate) {
            if (toInsert.getFluid().equals(class_3612.field_15910)) {
                return 0L;
            }
            return super.insert(toInsert, simulate);
        }
    };

    public FluidMultiblockGeneratorBlockEntity(class_2591<?> type, class_2338 pos, class_2680 state, int energyPerTick) {
        super(type, pos, state, energyPerTick);
    }

    @Override
    public void serverTick(class_1937 world, class_2338 pos, class_2680 state, NetworkedBlockEntity blockEntity) {
        if (this.bucketInputAllowed() && !world.field_9236 && this.isActive(state)) {
            this.processBuckets();
        }
        super.serverTick(world, pos, state, blockEntity);
    }

    private void processBuckets() {
        boolean canFill;
        class_1799 inStack = this.inventory.method_5438(0);
        boolean bl = canFill = this.fluidStorage.getAmount() < this.fluidStorage.getCapacity();
        if (!canFill || inStack.method_7960() || inStack.method_7947() > 1) {
            return;
        }
        StackContext stackRef = new StackContext(inStack, updated -> this.inventory.method_5447(0, (class_1799)updated));
        FluidApi.FluidStorage candidate = FluidApi.ITEM.find(stackRef);
        if (candidate == null || !candidate.supportsExtraction()) {
            return;
        }
        long moved = FluidApi.transferFirst(candidate, this.fluidStorage, this.fluidStorage.getCapacity(), false);
        if (moved == 0L) {
            class_1799 outStack = this.inventory.method_5438(1);
            if (outStack.method_7960()) {
                this.inventory.method_5447(1, stackRef.getValue());
                this.inventory.method_5447(0, class_1799.field_8037);
            } else if (outStack.method_7909().equals(stackRef.getValue().method_7909()) && outStack.method_7947() < outStack.method_7914()) {
                outStack.method_7933(1);
                this.inventory.method_5447(0, class_1799.field_8037);
            }
        }
    }

    @Override
    protected void tryConsumeInput() {
        if (this.isProducingSteam && (this.boilerStorage.getInStack().getAmount() == 0L || this.boilerStorage.getOutStack().getAmount() >= this.boilerStorage.getCapacity())) {
            return;
        }
        Optional<class_8786<OritechRecipe>> recipeCandidate = this.getRecipe();
        if (recipeCandidate.isEmpty()) {
            this.currentRecipe = OritechRecipe.DUMMY;
        }
        if (recipeCandidate.isPresent()) {
            OritechRecipe activeRecipe;
            this.currentRecipe = activeRecipe = (OritechRecipe)recipeCandidate.get().comp_1933();
            this.consumeFluidRecipeInput(activeRecipe);
        }
    }

    protected void consumeFluidRecipeInput(OritechRecipe activeRecipe) {
        int recipeTime;
        this.progress = recipeTime = (int)((float)this.currentRecipe.getTime() * this.getSpeedMultiplier() * (1.0f / this.getEfficiencyMultiplier()));
        this.setCurrentMaxBurnTime(recipeTime);
        FluidStack fluidStack = this.fluidStorage.getStack().copyWithAmount(activeRecipe.getFluidInput().amount());
        this.fluidStorage.extract(fluidStack, false);
    }

    @Override
    protected Optional<class_8786<OritechRecipe>> getRecipe() {
        return this.getRecipe(this.fluidStorage);
    }

    protected Optional<class_8786<OritechRecipe>> getRecipe(SimpleFluidStorage checkedTank) {
        return FluidMultiblockGeneratorBlockEntity.getRecipe(checkedTank, this.field_11863, this.getOwnRecipeType());
    }

    public static Optional<class_8786<OritechRecipe>> getRecipe(FluidApi.SingleSlotStorage checkedTank, class_1937 world, OritechRecipeType ownType) {
        if (checkedTank.getStack().isEmpty()) {
            return Optional.empty();
        }
        List availableRecipes = world.method_8433().method_30027((class_3956)ownType);
        for (class_8786 recipeEntry : availableRecipes) {
            OritechRecipe recipe = (OritechRecipe)recipeEntry.comp_1933();
            FluidIngredient recipeFluid = recipe.getFluidInput();
            if (!recipeFluid.matchesFluid(checkedTank.getStack()) || checkedTank.getStack().getAmount() < recipeFluid.amount()) continue;
            return Optional.of(recipeEntry);
        }
        return Optional.empty();
    }

    @Override
    protected void method_11007(class_2487 nbt, class_7225.class_7874 registryLookup) {
        super.method_11007(nbt, registryLookup);
        this.fluidStorage.writeNbt(nbt, "");
        class_1262.method_5427((class_2487)nbt, (class_2371)this.inventory.heldStacks, (boolean)false, (class_7225.class_7874)registryLookup);
    }

    @Override
    protected void method_11014(class_2487 nbt, class_7225.class_7874 registryLookup) {
        super.method_11014(nbt, registryLookup);
        this.fluidStorage.readNbt(nbt, "");
        class_1262.method_5429((class_2487)nbt, (class_2371)this.inventory.heldStacks, (class_7225.class_7874)registryLookup);
    }

    @Override
    public boolean inputOptionsEnabled() {
        return false;
    }

    @Override
    public List<ScreenProvider.GuiSlot> getGuiSlots() {
        return List.of(new ScreenProvider.GuiSlot(0, 55, 35), new ScreenProvider.GuiSlot(1, 112, 35, true));
    }

    @Override
    public InventorySlotAssignment getSlotAssignments() {
        return new InventorySlotAssignment(0, 1, 1, 1);
    }

    public boolean bucketInputAllowed() {
        return true;
    }

    @Override
    public int getInventorySize() {
        return 2;
    }

    @Override
    public FluidApi.FluidStorage getFluidStorage(@Nullable class_2350 direction) {
        return this.fluidStorage;
    }
}

